

{Simulate ReadMode interrupt using the DPMI. Based on SIMRMI in C from
the Microsoft DDK Dept.


Rex K. Perkins, CIS 70651,1611


6th March 1992}



Unit SimRMI;

Interface

Uses WinProcs,WinTypes,Debug;

Type  PRealModeRecord=^TRealModeRecord;
      TRealModeRecord= {Real Mode register record for DPMI services}
                      Record
                        EDI:LongInt;         {Register EDI}
                        ESI:LongInt;         {Register ESI}
                        EBP:LongInt;         {Register EBP}
                        Reserved:LongInt;    {Reserved}
                        EBX:LongInt;         {Register EBX}
                        EDX:LongInt;         {Register EDX}
                        ECX:LongInt;         {Register ECX}
                        EAX:LongInt;         {Register EAX}

                        Flags:Word;          {Register Flags}
                        ES:Word;             {Register ES}
                        DS:Word;             {Register DS}
                        FS:Word;             {Register FS}
                        GS:Word;             {Register GS}
                        IP:Word;             {Register IP}
                        CS:Word;             {Register CS}
                        SP:Word;             {Register SP}
                        SS:Word              {Register SS}
                      End;

Const
             {Pass this constant if you don't need to define the registers}
        DontCareRMR:TRealModeRecord=(
                                     EDI:0;
                                     ESI:0;
                                     EBP:0;
                                     Reserved:0;
                                     EBX:0;
                                     EDX:0;
                                     ECX:0;
                                     EAX:0;
                                     Flags:0;
                                     ES:0;
                                     DS:0;
                                     FS:0;
                                     GS:0;
                                     IP:0;
                                     CS:0;
                                     SP:0;
                                     SS:0);



  Function SimRealModeInt(IntNumber:Byte; RealModeRecord:PRealModeRecord):Boolean;

    {Simulate a call to the spectified real mode interrupt. The real mode registers
     are defined in RealModeRecord, and are returned in this same structure. Returns
     False if there was an error.}

  Function CheckISRInstalled(IntVec:Byte):Boolean;

    {Check that there is an Interrupt Service Routine installed. Returns true if a non-zero segment
     was found in the specified ISR vector. If returns False, there is not a valid
     address in the interrupt vector so the interrupt should not be called}



Implementation




  Function SimRealModeInt(IntNumber:Byte; RealModeRecord:PRealModeRecord):Boolean;

    {Simulate a call to the spectified real mode interrupt. The real mode registers
     are defined in RealModeStruct, and are returned in this same structure. Returns
     False if there was an error.}

  Var Status:Boolean;

  Begin
    ASM
        push di
        push es

        mov  bh,00               {For DOSX to reset the int controller and A20 line.  Windows ingores it.}
        mov  bl,IntNumber        {Tell DPMI which interrupt to simulate}
        xor  cx,cx               {0 bytes to copy to real mode stack}
        les  di,RealModeRecord   {Get the real mode structure}
        mov  ax,$0300            {0300h is simulate real mode interrupt}
        int  31h

        jc   @Error              {The carry flag was set, so there was an error}
        mov  Status,True         {Return no error}
        jmp  @AllDone

      @Error:
        mov  Status,False        {Return false indicating an error}

      @AllDone:
        pop  es
        pop  di
    End
  End;






  Function CheckISRInstalled(IntVec:Byte):Boolean;

    {Check that there is an ISR installed. Returns true if a non-zero segment
     was found in the specified ISR vector. If returns False, there is not a valid
     address in the interrupt vector so the interrupt should not be called}

  Var ISRSegment:Word;

  Begin
    ASM
      mov     ax,0200h       {DPMI Get Real Mode Interrupt Vector}
      mov     bl,IntVec      {Check for the specified interrupt}
      int     31h            {Call DPMI}
      mov     ISRSegment,cx  {CX holds the ISR segment}
    End;

    If ISRSegment<>0 Then {The Int vector is not 0 so there must be an ISR}
      CheckISRInstalled:=True
    Else
      CheckISRInstalled:=False
  End;



Begin
End.

