{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{$M 16384,0,655360}
{ This program verifies the performance of unit RAND.PAS }
Program TestRand;
Uses Rand, Crt;

Const
  TicksPerDay = 1573040;
  SecsPerDay = 24 * 60 * 60;
  SecsPerTick = SecsPerDay / TicksPerDay;

Var
  BiosClockTick : LongInt Absolute $40:$6C;
  i, j, seed, Ticks : LongInt;
  ch : Char;

Procedure ParkMiller;
{ This is the seed computation portion of the Park/Miller random number
  generator.  See CACM Oct. '88. }
Const
  a = 16807;
  m = 2147483647;
  q = 127773;
  r = 2836;
Var
  lo, hi, test : LongInt;
Begin
  hi := seed div q;
  lo := seed mod q;
  test := a * lo - r * hi;
  If test > 0 Then
    seed := test
  Else
    seed := test + m;
End;

Begin
  seed := 1;
  RandSeed := 1;
  Ticks := BiosClockTick;
  For i := 1 To 10000 Do Begin
    ParkMiller;
    j := IRand;
    If (i Mod 100000) = 0 Then { for timing };
  End;
  Ticks := BiosClockTick - Ticks;
  WriteLn('10000 ', Seed, ' ', RandSeed);
  { Both Seed and RandSeed should be 1043618065 (See CACM Oct. '88) }
  If (seed = 1043618065) And (seed = RandSeed) Then Begin
    WriteLn('Generators check OK at 10,000 iterations.');
    WriteLn('You may now begin checking the full cycle, if you wish');
    WriteLn('Warning: this could take a while - This cpu takes about ',
       (SecsPerTick * Ticks * 10):4:1, ' sec per 100,000');
    WriteLn('iterations.  The full cycle is ', RandModulo, ' iterations ',
      '(about ', ((RandModulo/10000)*Ticks*SecsPerTick)/SecsPerDay:3:1,
      ' cpu days).');
    WriteLn('You may stop after any block of 100000 by pressing the ',
      '<Escape> key.');
    Write('Do you wish to begin checking the full cycle (Y/N)? ');
    ch := UpCase(ReadKey);
    WriteLn(ch);
    If ch = 'Y' Then Begin
      WriteLn('You asked for it!');
      WriteLn('The two seed values will be displayed every 100000 iterations');
      WriteLn('To terminate at next 100000, press <Escape>');
      seed := 1;
      RandSeed := 1;
      For i := 1 To RandModulo Do Begin
        ParkMiller;
        j := IRand;
        If (i Mod 100000) = 0 Then Begin
          WriteLn(i, ' ', seed, ' ', RandSeed);
          ch := ' ';
          While KeyPressed Do ch := ReadKey;
          If ch = ^[ Then Halt;
        End;
      End;
    End;
  End;
End.