 page ,132
;
;This TSR maintains a circular buffer of random numbers.  After the TSR is
;  loaded, it hooks to the multiplex interrupt.  To obtain n random numbers,
;  set al=n ; ah=aeh ; dx = 726eh ; es:di=buffer address for the numbers
;  INT 2F
;  Returns with al=ffh (success) or al=00 (not all n values returned)
;  dx = number of values returned
;  all other registers unchanged
;
;The TSR stores one random byte every time the keyboard interrupt (INT9)
;  is activated.  The byte is bits 9-2 of the current Timer 0 value.
;Note that n=0 can be used to determine whether or not the TSR has been
;  loaded
;
;Written by Joseph R Ahlgren, BBS 703-241-7980, CompuServe 70461,2340
;  This program is freeware.  It may be used without restriction, provided
;  the original source is acknowledged.
;  91/06/28
;
 assume cs:cseg,ds:cseg,ss:cseg
cseg segment para public 'code'
FirstCode:
 org 100h
TableBase label byte
LoadTSR:
 jmp cs:[Last]
Last dw LastCode
 org 200h
ByteLoc dw TableBase+00ffh
LastByte dw Tablebase+00ffh
Continue9 dd ?
Continue2F dd ?
INT9:
 push ax
 push bx
 mov bx,cs:[ByteLoc]
 inc bl
 cmp bx,cs:[LastByte]
 je exit
 xor ax,ax
 out   43h,al
 in    al,40h
 mov   ah,al
 in    al,40h
 xchg al,ah
 shr ax,1
 shr ax,1
 mov cs:[ByteLoc],bx
 mov cs:[bx],al
exit:
 pop bx
 pop ax
 jmp cs:[continue9]
INT2F:
 cmp ah,0aeh
 jne exit2f
 cmp dx,726eh ;'rn'
 jne exit2f
 push bx
 push cx
 mov dx,di
 or al,al
 jz DoneOK
 mov cl,al
 xor ch,ch
Loop1:
 cli
 mov bx,cs:[LastByte]
 cmp bx,cs:[ByteLoc]
 je DoneShort
 inc bl
 mov al,cs:[bx]
 mov cs:[LastByte],bx
 sti
 stosb
 loop loop1
DoneOK:
 mov al,0ffh
DoneDone:
 sub di,dx
 xchg dx,di
 pop cx
 pop bx
 iret
DoneShort:
 xor al,al
 jmp DoneDone
exit2f:
 jmp cs:[continue2f]
LastCode:
 mov ax,0ae00h
 mov dx,0726eh
 int 2fh
 cmp al,0ffh
 jnz NotLoaded
 or dx,dx
 jz AlreadyLoaded
NotLoaded:
 mov ax,3509h
 int 21h  ;get int 9
 mov [word ptr Continue9],bx
 mov [word ptr Continue9+2],es
 mov ax,2509h
 mov dx,offset INT9
 int 21h  ;link to INT9
 mov ax,352Fh
 int 21h  ;get int 2F
 mov [word ptr Continue2F],bx
 mov [word ptr Continue2F+2],es
 mov ax,252Fh
 mov dx,offset INT2F
 int 21h  ;link to INT2F
 mov dx,offset Success
 mov ah,9
 int 21h
 mov ax,3100h  ;TSR
 mov dx,(LastCode+15-FirstCode)/16
 int 21h  ;TSR
AlreadyLoaded:
 mov dx,offset Already
 mov ah,9
 int 21h
 mov ax,4c01h
 int 21h
Success db 0dh,0ah,0ah,'RANTSR loaded and linked to INT 2F',0ah,0dh
        db ' Joseph R Ahlgren, BBS 703-241-2661',0ah,0dh,0ah,'$'
Already db 0dh,0ah,0ah,'RANTSR already loaded',0ah,0dh,0ah,'$'
cseg ends
 end LoadTSR


