Unit QSort5;
(*****************************************************************************
 *    General Purpose                                                        *
 *    Iterative Quicksort Routine
 *    For Turbo Pascal V 5
 *
 *
 *
 *    Call Via :                                                             *
 *    QuickSort(Top, Bottom,YourCompare,YourSwap);                           *
 *                                                                           *
 *    Top and Bottom are LongInts that define the                            *
 *    inclusive range for the sort. i.e. array boundries etc.                *
 *    Top and Bottom can be specified in any order, the subroutine will      *
 *    figure it out (Top = Bottom will work, but is rather silly).           *
 *                                                                           *
 *    YourCompare is a Function and YourSwap is a Procedure.                 *
 *                                                                           *
 *    Both you write and they MUST be compiled with far calls                *
 *    forced ({$F+}) to work.                                                *
 *                                                                           *
 *    YourCompare is a function that returns a short integer (shortint)      *
 *    it takes as arguments two LongInts, which each represents              *
 *    two elements of whatever you're sorting.                               *
 *                                                                           *
 *    YourCompare should return 0 if both elements are equal.                *
 *                             -1 if the elements are not in sort order,     *
 *                                in the order that they were specified      *
 *                              1 if the elements are in sort order in       *
 *                                the order that they are specified.         *
 *                                                                           *
 *    The Header should look something like this:                            *
 *                                                                           *
 *    Function YourCompare(i,j : LongInt) : ShortInt;                        *
 *                                                                           *
 *    YourSwap is a procedure that takes as arguments two LongInts           *
 *    that represents two elements of whatever you're sorting. YourSwap      *
 *    should swap the two elements. What ever was in the first element       *
 *    is now in the second and vis-versa.                                    *
 *                                                                           *
 *    The Header should look something like this:                            *
 *                                                                           *
 *    Procedure YourSwap(i,j : LongInt);                                     *
 *                                                                           *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * V 1.01   11 Oct 88 - revised for Turbo Pascal 5.0                         *
 *                      round about way of calling removed, now uses (new to *
 *                      Turbo Pascal) procedure/function types.              *
 *                      Some examples of raw stupidity and muddled thinking  *
 *                      (on my part) removed and new kludges added.          *
 *                                                                           *
 *****************************************************************************)

{$A-}
{$O+} (* allow to be an overlay unit, if desired *)
Interface

{$F+}
Type

  CompareFunctionType = Function (i,j : LongInt) : ShortInt;
  SwapProcedureType   = Procedure (i,j : LongInt);


Procedure QuickSort(Top, Bottom : LongInt;
               CompareFunction : CompareFunctionType;
               SwapProcedure   : SwapProcedureType);

Implementation

{$B-}

Procedure QuickSort(Top, Bottom : LongInt;
             CompareFunction : CompareFunctionType;
             SwapProcedure   : SwapProcedureType);


(* Get median of three arguments *)

Function Middle(a, b, c : LongInt) : LongInt;

Begin

  If (CompareFunction(a, b)) = (CompareFunction(b, c))
     Then
       Middle := b
     Else
       If (CompareFunction(b, a)) = (CompareFunction(a, c))
          Then Middle := a
          Else Middle := c;
End;


(* Partition a list and return the pivot location *)

Function Partition(Low, High : LongInt) :  LongInt;

Var

Pivot : LongInt;

Begin

  (* This makes the median value of the Top, middle and Bottom elements
     the pivot (and puts it in the Bottom position)*)

  SwapProcedure(Middle(Low,(Succ(High+Low) shr 1),High),High);

  Pivot := High;

  Dec(High);

  (* The actual partitioning *)
  Repeat

    While ((Low <= High) and (CompareFunction(Low, Pivot) >= 0)) do
      Inc(Low);

    While ((Low <= High) and (CompareFunction(High, Pivot) <= 0)) do
      Dec(High);

    If (Low < High) then SwapProcedure(Low, High);

  Until (Low > High);

  SwapProcedure(Low, Pivot);

  Partition := Low;

End;

(* The "real" quick sort routine *)
(* may not be "optimum", but at least it's fairly un-cryptic (?) *)

Procedure Qksort(Top, Bottom:LongInt);

Var

 CurrentPivot : LongInt;
 StPtr        : Integer;
 CurRStack    : LongInt;
 CurLStack    : LongInt;
 LrgRStack    : LongInt;
 LrgLStack    : LongInt;

Const

 StMAX = 40;  (* Should NEVER need this many *)

Var

 LStack       : Array[0..StMAX] of LongInt;  (* stores boundries ... *)
 RStack       : Array[0..StMAX] of LongInt;  (* of sub-partitions.   *)

Begin

  StPtr := 1;          (* next element to stack *)

  CurLStack := Top;    (* First time 'round with entire list *)
  CurRStack := Bottom;

  Repeat (* until stacks are empty *)

    CurrentPivot := Partition(CurLStack, CurRStack);

    If (CurrentPivot-CurLStack) < (CurRStack-CurrentPivot)
      Then
        Begin (*Right side was larger partition*)
          LrgLStack := Succ(CurrentPivot);
          LrgRStack := CurRStack;
          CurRStack := Pred(CurrentPivot);
        End
      Else
        Begin (*Left side was larger partition*)
          LrgLStack := CurLStack;
          LrgRStack := Pred(CurrentPivot);
          CurLStack := Succ(CurrentPivot);
        End;

      If (LrgRStack - LrgLStack) > 1
        Then  (* if larger partition non-trival, stack *)
          Begin
            LStack[StPtr] := LrgLStack;
            RStack[StPtr] := LrgRStack;
            Inc(StPtr);
          End
        Else (* process the trival cases *)
            If (LrgRStack <> LrgLStack)
                and (CompareFunction(LrgLStack, LrgRStack) < 0)
                   Then
                     SwapProcedure(LrgLStack, LrgRStack);

      If (CurRStack - CurLStack) <= 1 (*If trivial ...*)
        Then (* process then get new current values from stack*)
          Begin
            If (CurRStack <> CurLStack)
                and (CompareFunction(CurLStack, CurRStack) < 0)
                   Then
                     SwapProcedure(CurLStack, CurRStack);
            Dec(StPtr);
            CurLStack := LStack[StPtr];     (* Pop New Current limits*)
            CurRStack := RStack[StPtr];
          End;

  Until StPtr <= 0; (* Stacks are empty *)

End;

(* This is actually the main routine *)

Begin

  If Top < Bottom
    Then
     Qksort(Top, Bottom)
    Else
     Qksort(Bottom, Top);
End;

End.