{$N+,E+,V-}
(* Copyright (c) 1990 by Borland International, Inc. *)
PROGRAM PxTest;


USES
  CRT, PXEngine, PXShell;

VAR

  Ch, PromptKey : Char;
  PXSampleTbl : PXS_TableDesc;
  I, StartY, StartX : Integer;

  PROCEDURE Init(VAR PXTbl : PXS_TableDesc);
  VAR
    Exists : Boolean;
  BEGIN

    FillChar(PXTbl, SizeOf(PXTbl), 0);
    PXTbl.TableName := 'PXTEST';

    IF Error(PXTblExist(PXTbl.TableName, Exists)) OR(NOT Exists) THEN
      BEGIN
        WriteLn('PXTest does not exist. Creating...');
        IF NOT PXTbl.PXSCreateDummy THEN
          BEGIN
            WriteLn('Cannot create dummy file. Halting...');
            Halt(1);
          END;
      END;

    IF NOT PXTbl.PXSOpen(PXTbl) THEN
      BEGIN
        WriteLn('Could not open ', PXTbl.TableName, '. Halting...');
        Halt(1);
      END;

  END;

  PROCEDURE DisplayInfo(VAR PXTbl : PXS_TableDesc);
  VAR
    FldNumber : Integer;
  BEGIN
    WriteLn('Table ', PXTbl.TableName, ' has ', PXTbl.NBRRecs, ' records');
    WriteLn;
    Write('There are ', PXTbl.NBRFields, ' fields');
    WriteLn(' and ', PXTbl.NBRKeys, ' keys');
    WriteLn('The structure is :');
    FOR FldNumber := 1 TO PXTbl.NBRFields DO
      BEGIN
        WriteLn(PXTbl.Field[FldNumber].F_Name:12, ' : ',
                PXTbl.Field[FldNumber].F_Type);
      END;                        {For FldNumber}
    WriteLn;
  END;

  PROCEDURE ListRecords(VAR PXTbl : PXS_TableDesc);
  VAR
    FldNumber : Integer;
    CurrRec : LongInt;
  BEGIN
    IF PXTbl.NBRRecs = 0 THEN
      BEGIN
        WriteLn('0 records to list');
      END
    ELSE
      BEGIN
        FOR CurrRec := 1 TO PXTbl.NBRRecs - 1 DO
          BEGIN
            IF NOT(PXTbl.PXSReadNext(PXTbl)) THEN
              BEGIN
                WriteLn('Could not get next record. Halting...');
                Halt(1);
              END;

            FOR FldNumber := 1 TO PXTbl.NBRFields DO
              BEGIN
                WriteLn('[', PXTbl.Field[FldNumber].F_Type:4, ']',
                        PXTbl.Field[FldNumber].F_Name:12, ' : ',
                        PXTbl.Field[FldNumber].F_Content);
              END;                {For FldNumber}
          END;                    {For CurrRec}
      END;
  END;

  PROCEDURE ChangeTable(VAR PXTbl : PXS_TableDesc);
  VAR
    TableNameStr : String;
    Exists : Boolean;
  BEGIN
    Write('Enter the new table name : ');
    ReadLn(TableNameStr);
    IF (PXTblExist(TableNameStr, Exists) > 0) OR(NOT Exists) THEN
      BEGIN
        Write('Table ', TableNameStr, ' does not exist. ');
      END
    ELSE
      BEGIN
        PXTbl.TableName := TableNameStr;
        IF NOT PXTbl.PXSOpen(PXTbl) THEN
          BEGIN
            WriteLn('Cannot Open Table ', TableNameStr);
            Halt(1);
          END;
      END;
  END;

  PROCEDURE ViewTable(VAR PXTbl : PXS_TableDesc);
  VAR
    Ch   : Char;
    NoMore : Boolean;
    TempNumFlds, FldNumber : LongInt;
  BEGIN
    GotoXY(1, 1);
    WriteLn('Press PAGE UP/Up Arrow for Previous record, PAGE DOWN/Down Arrow for NEXT');
    WriteLn('Press HOME for first, END for last, ESC to abort');
    TempNumFlds := PXTbl.NBRFields MOD 20;
    NoMore := False;
    WHILE NOT NoMore DO
      BEGIN
        IF Error(PXRecNum(PXTbl.TableHandle, PXTbl.CurrRec)) THEN
          BEGIN
            WriteLn('Error getting current record number. Halting...');
            Halt(1);
          END;
        GotoXY(1, 3);
        WriteLn('REC # ', PXTbl.CurrRec:6);
        IF NOT PXTbl.PXSReadCurr(PXTbl) THEN
          BEGIN
            WriteLn('Could not get record. Halting ...');
            Halt(1);
          END;
        FOR FldNumber := 1 TO TempNumFlds DO
          BEGIN
            GotoXY(1, FldNumber + 3);
            Write(PXTbl.Field[FldNumber].F_Name:12, ' : ',
                  PXTbl.Field[FldNumber].F_Content);
            ClrEol;
            WriteLn;
          END;

        Ch := ReadKey;
        IF Ch = #0 THEN Ch := ReadKey;

        CASE Ch OF
          #27 : BEGIN
                  NoMore := True;
                END;
          #72, #73 : BEGIN        {Page Up, Up Arrow}
                       IF PXTbl.CurrRec > 1 THEN
                         IF Error(PXRecPrev(PXTbl.TableHandle)) THEN
                           BEGIN
                             WriteLn('Cannot access previous RECORD. Halting');
                             Halt(1);
                           END;
                     END;
          #80, #81 : BEGIN        {Page Down, Down Arrow}
                       IF PXTbl.CurrRec < PXTbl.NBRRecs THEN
                         IF Error(PXRecNext(PXTbl.TableHandle)) THEN
                           BEGIN
                             WriteLn('Cannot access next RECORD. Halting');
                             Halt(1);
                           END;
                     END;         {Page Down}

          #71 : BEGIN             {Home}
                  IF Error(PXRecGoto(PXTbl.TableHandle, 1)) THEN
                    BEGIN
                      WriteLn('Cannot access first RECORD. Halting');
                      Halt(1);
                    END;
                END;

          #79 : BEGIN             {End}
                  IF Error(PXRecGoto(PXTbl.TableHandle,
                                     PXTbl.NBRRecs)) THEN
                    BEGIN
                      WriteLn('Cannot access last RECORD. Halting');
                      Halt(1);
                    END;
                END;

        END;                      {Case}
      END;                        {While}
  END;

  PROCEDURE SearchTable(VAR PXTbl : PXS_TableDesc);
  VAR
    Ch   : Char;
    TempNumFlds, FldNumber : LongInt;
    SearchStr : String;
  BEGIN
    GotoXY(1, 1); WriteLn('Which Field # to search ?');
    TempNumFlds := PXTbl.NBRFields MOD 20;
    FOR FldNumber := 1 TO TempNumFlds DO
      IF NOT PXTbl.PXSGetData(FldNumber, PXTbl) THEN
        BEGIN
          WriteLn('Error retrieving data. Halting...');
          Halt(1);
        END
      ELSE
        BEGIN
          GotoXY(1, FldNumber + 3);
          WriteLn('[', FldNumber, ']',
                  PXTbl.Field[FldNumber].F_Name:12, ' : ',
                  PXTbl.Field[FldNumber].F_Content);
        END;
    FldNumber := 0;
    REPEAT
      GotoXY(1, 22); Write(' ? ');
      ReadLn(FldNumber);
      IF (FldNumber > 18) OR(FldNumber > PXTbl.NBRFields) THEN
        Write('Not a valid field');
    UNTIL (FldNumber < 18) AND(FldNumber <= PXTbl.NBRFields);
    Write('Value : ');
    ReadLn(PXTbl.Field[FldNumber].F_Content);
    IF NOT PXTbl.PXSPutData(FldNumber, PXTbl) THEN
      BEGIN
        WriteLn('Incorrect search criteria...');
        Exit;
      END;
    WriteLn('Searching for : ', PXTbl.Field[FldNumber].F_Content);
    Write('(F)irst or (S)econd occurrance or (P)artial first or (N) Partial Next?  ');
    Ch := ReadKey;

    CASE Upcase(Ch) OF
      'F' : BEGIN
              IF Error(PXSrchFld(PXTbl.TableHandle, PXTbl.RecHandle,
                                 FldNumber, SearchFirst + ClosestRecord)) THEN
                WriteLn('Not found.');
            END;
      'S' : BEGIN
              IF Error(PXSrchFld(PXTbl.TableHandle, PXTbl.RecHandle,
                                 FldNumber, SearchNext + ClosestRecord)) THEN
                WriteLn('Not found.');
            END;
      'P' : BEGIN
              IF Error(PXTbl.PXSPartialSearch(PXTbl, FldNumber,
                                              PXTbl.Field[FldNumber].F_Content,
                                              SearchFirst, False)) THEN
                WriteLn('Not found.');
            END;
      'N' : BEGIN
              IF Error(PXTbl.PXSPartialSearch(PXTbl, FldNumber,
                                              PXTbl.Field[FldNumber].F_Content,
                                              SearchNext, False)) THEN
                WriteLn('Not found.');
            END;
    END;
  END;

  PROCEDURE ModifyRecord(VAR PXTbl : PXS_TableDesc);

  CONST
    Terminators : CharSet = [ESC, CR, UpKey, DownKey];
    Printable : CharSet = [#32..#127];

  VAR
    TempNumFlds, FldNumber, TempLength : Integer;
    TempStr : String;
    FldUpdated : Boolean;
    TC   : Char;

  BEGIN

    TempNumFlds := PXTbl.NBRFields MOD 20;

    FOR FldNumber := 1 TO TempNumFlds DO
      IF NOT PXTbl.PXSGetData(FldNumber, PXTbl) THEN
        BEGIN
          WriteLn('Error retrieving data. Halting...');
          Halt(1);
        END
      ELSE
        BEGIN
          GotoXY(1, FldNumber + 3);
          FldUpdated := False;
          Write(PXTbl.Field[FldNumber].F_Name:12, ' : ');
          WHILE NOT FldUpdated DO
            BEGIN
              EditLine(PXTbl.Field[FldNumber].F_Content,
                       SizeOf(PXTbl.Field[FldNumber].F_Content) - 1,
                       16, FldNumber + 3, Printable, Terminators, TC);
              FldUpdated := PXTbl.PXSPutData(FldNumber, PXTbl);
              IF NOT FldUpdated THEN
                BEGIN
                  GotoXY(1, 22); WriteLn('Improper format. Enter again');
                END;
            END;
        END;

    GotoXY(1, 22);

    IF Error(PXRecUpdate(PXTbl.TableHandle, PXTbl.RecHandle)) THEN
      WriteLn('Update failed')
    ELSE
      WriteLn('Updated');
    Delay(100);

  END;

  PROCEDURE SortTable(VAR PXTbl : PXS_TableDesc);
  VAR
    NFieldsToSort, I : Word;
    SortFields : WordArray;
    Ch   : Char;
  BEGIN
    NFieldsToSort := 0;
    DisplayInfo(PXSampleTbl);
    Write('How many fields to sort on ? ');
    WHILE (NFieldsToSort < 1) OR(NFieldsToSort > PXTbl.NBRFields) DO
      ReadLn(NFieldsToSort);
    WriteLn('Enter field # ');
    FOR I := 1 TO NFieldsToSort DO
      BEGIN
        Write('[', I, '] ? ');
        ReadLn(SortFields[I]);
      END;
    WriteLn; Write('(A)scending or (D)escending ? ');
    Ch := ReadKey;
    WriteLn;
    WriteLn('Sorting...');
    IF Upcase(Ch) = 'A' THEN
      PXTbl.TableSort(PXTbl, NFieldsToSort, SortFields, ASCENDING)
    ELSE
      PXTbl.TableSort(PXTbl, NFieldsToSort, SortFields, DESCENDING);

  END;


BEGIN                             (* MP *)

  ClrScr;
  TextColor(White); TextBackground(Black);
  Init(PXSampleTbl);
  StartY := 8; StartX := 25;

  Ch := 'Z';

  WHILE Upcase(Ch) <> 'X' DO
    BEGIN
      ClrScr;
      GotoXY(StartX, StartY); Write('(L)ist all records in table');
      GotoXY(StartX, StartY + 1); Write('(I)nfo on table');
      GotoXY(StartX, StartY + 2); Write('(C)hange table');
      GotoXY(StartX, StartY + 3); Write('(V)iew one record');
      GotoXY(StartX, StartY + 4); Write('(S)earch for a record');
      GotoXY(StartX, StartY + 5); Write('(M)odify one record');
      GotoXY(StartX, StartY + 6); Write('(T) Sort table');
      GotoXY(StartX, StartY + 7); Write('(D)elete current record');
      GotoXY(StartX, StartY + 8); Write('(U)pdate current record');
      GotoXY(StartX, StartY + 9); Write('(A)ppend current record');
      GotoXY(StartX, StartY + 12); Write('(X)it program  ');
      Ch := ReadKey;
      ClrScr;

      CASE Upcase(Ch) OF
        'I' : BEGIN
                DisplayInfo(PXSampleTbl);
              END;                { I }
        
        'L' : BEGIN
                ListRecords(PXSampleTbl);
              END;                { L }

        'C' : BEGIN
                ChangeTable(PXSampleTbl);
              END;

        'V' : BEGIN
                ViewTable(PXSampleTbl);
              END;

        'S' : BEGIN
                SearchTable(PXSampleTbl);
              END;

        'M' : BEGIN
                ModifyRecord(PXSampleTbl);
              END;                {M}

        'T' : BEGIN
                SortTable(PXSampleTbl);
              END;

        'D' : BEGIN
                IF NOT PXSampleTbl.DelCurrRec(PXSampleTbl) THEN
                  WriteLn('Not deleted')
                ELSE
                  WriteLn('Deleted');
              END;

        'U' : BEGIN
                IF NOT PXSampleTbl.UpdateRec(PXSampleTbl) THEN
                  WriteLn('Not Updated')
                ELSE
                  WriteLn('Updated');
              END;

        'A' : BEGIN
                IF NOT PXSampleTbl.AppendRec(PXSampleTbl) THEN
                  WriteLn('Not Appended')
                ELSE
                  WriteLn('Appended');
              END;

        'X' : WriteLn;

      END;                        { Case }

      GotoXY(1, 25); Write(' press any key.. . ');
      PromptKey := ReadKey;

    END;                          {While Not X}

  I := PXTblClose(PXSampleTbl.TableHandle);
  I := PXExit;

END.
