UNIT PXShell;

INTERFACE

  {$N+,E+,V-}
  (* Copyright (c) 1990 by Borland International, Inc. *)


USES
  CRT, PXEngine;

CONST
  NULL = #0;
  BS   = #8;
  LF   = #10;
  CR   = #13;
  ESC  = #27;
  Space = #32;
  Tab  = ^I;

  F1   = #187;
  F2   = #188;
  F3   = #189;
  F4   = #190;
  F5   = #191;
  F6   = #192;
  F7   = #193;
  F8   = #194;
  F9   = #195;
  F10  = #196;
  UpKey = #200;
  DownKey = #208;
  LeftKey = #203;
  RightKey = #205;
  PgUpKey = #201;
  PgDnKey = #209;
  HomeKey = #199;
  EndKey = #207;
  InsKey = #210;
  DelKey = #211;

  (* Function Returns *)
  SUCCESS = True;                 (* function succeeded *)
  FAILURE = False;                (* function failed *)

  (*Edit the following constants to customize your database*)
  NETUSERNAME = 'JAMES';          (* network username *)
  NETPATH = 'L:\PDOXDATA';        (* net directory *)
  NETTYPE = NOVELLNET;            (* network type *)
  MAXNBRFLDS = 100;

TYPE
  CharSet = SET OF Char;
  SortOrderT = (ASCENDING, DESCENDING);
  PXS_FieldDescRec = RECORD
                       F_Name : NameString;
                       F_Type : NameString;
                       F_Content : String;
                     END;

  PXS_FldDesc = ARRAY[1..MAXNBRFLDS] OF PXS_FieldDescRec;

  PXS_TableDesc = OBJECT
                    TableHandle : Word;
                    RecHandle : Word;
                    NBRFields : Integer;
                    NBRKeys : Integer;
                    NBRRecs : LongInt;
                    TableName : String;
                    CurrRec : LongInt;
                    Field : PXS_FldDesc;
                    FUNCTION Error(RC : Integer) : Boolean;
                    PROCEDURE ErrIgnore(RC : Integer);
                    PROCEDURE Init(VAR PXS_TD : PXS_TableDesc);
                    FUNCTION PXSOpen(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSGetData(FH : Word; VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSPutData(FH : Word; VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSCreateDummy : Boolean;
                    FUNCTION PXSReadCurr(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSReadNext(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSReadPrev(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION PXSPartialSearch(VAR PXS_TD : PXS_TableDesc;
                                              FldHandle : FieldHandle;
                                              SearchString : String;
                                              Mode : Integer;
                                              CaseSensitive : Boolean) : Integer;
                    FUNCTION Compare(CompField : Word;
                                     SortOrder : SortOrderT;
                                     RecHandle1, RecHandle2 : Word) : Integer;
                    PROCEDURE ProcessElement(Rec1, Rec2 : LongInt;
                                             RecHandle1, RecHandle2 : LongInt;
                                             NFields : Integer;
                                             SortFields : WordArray;
                                             SortOrder : SortOrderT);
                    PROCEDURE TableSort(VAR PXS_TD : PXS_TableDesc;
                                        NFieldsToSort : Integer;
                                        SortFields : WordArray;
                                        SortOrder : SortOrderT);
                    FUNCTION DelCurrRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION UpdateRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
                    FUNCTION AppendRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
                  END;

  PXS_TDPTR = ^PXS_TableDesc;

VAR
  PXD_SwapSize, PXD_MaxTables, PXD_MaxRecBufs,
  PXD_MaxLocks, PXD_Maxfiles : Integer;
  PXD_SortTable : Pointer;


FUNCTION Error(RC : Integer) : Boolean;

  {These functions are from MISCTOOL, the old Database Toolbox}

FUNCTION ScanKey : Char;
PROCEDURE EditLine(VAR S : String;
                   Len, X, Y : Byte;
                   LegalChars,
                   Term : CharSet;
                   VAR TC : Char);

IMPLEMENTATION

(*
 *    Procedure:
 *          Error
 *
 *    Arguments:
 *          PXErr                   Paradox Engine error code
 *
 *    Description:
 *          Prints the message of the error code stored in pxErr,
 *              exits the engine, and terminates the program, if an error
 *          occures.
 *
 *    Returns:
 *          None
 *)
  PROCEDURE PXSortError(PXErr : Integer);

  BEGIN
    IF PXErr <> 0 THEN
      BEGIN
        WriteLn('Paradox Engine Error: ', PXErrMsg(PXErr));
        IF PXExit = 0 THEN ;      (* ignore return code *)
        Halt(PXErr);
      END;
  END;                            (* Error *)

(*
** Function:		UpCaseStr
**
** Parameters:
**
**		S string to convert to upper case
**
** Returns:
**		Upper case equivalent of the passed parameter
**
*)
  FUNCTION UpCaseStr(S : String) : String;
  VAR
    Result : String;
    I    : Integer;

  BEGIN

    Result := '';
    FOR I := 1 TO Length(S) DO
      Result := Result + Upcase(S[I]);

    UpCaseStr := Result;

  END;

{$V-}

  PROCEDURE Abort(M : String);
{ Simple fatal error reporter: Goes to the bottom of the screen,
  Prints M and terminates execution of the program. }

  BEGIN
    Window(1, 1, 80, 25);
    TextColor(White);
    TextBackground(Black);
    LowVideo;
    GotoXY(1, 25);
    Write(M);
    ClrEol;
    Halt;
  END;                            { Abort }

  PROCEDURE Beep;
{ Generates a sound from the speaker to alert the user.  Useful
  for error handling routines. }
  BEGIN
    Sound(220);
    Delay(200);
    NoSound;
  END;                            { Beep }

  FUNCTION ScanKey : Char;
{ Reads a key from the keyboard and converts 2 scan code escape
  sequences into 1 character. }

  VAR
    Ch   : Char;
  BEGIN
    Ch := ReadKey;
    IF (Ch = #0) AND KeyPressed THEN
      BEGIN
        Ch := ReadKey;
        IF Ord(Ch) < 128 THEN
          Ch := Chr(Ord(Ch) + 128);
      END;
    IF Ch = ^C THEN
      Abort('Program terminated by user');
    ScanKey := Ch;
  END;                            { ScanKey }

  PROCEDURE EditLine(VAR S : String;
                     Len, X, Y : Byte;
                     LegalChars, Term : CharSet;
                     VAR TC : Char);
{  EditLn implements a line editor that supports WordStar commands
   as well as left-right arrow keys , Home, End, back space, etc.
   Paramaters:
     S : String to be edited
     Len : Maximum characters allowed to be edited
     X, Y : Starting x an y cordinates
     LegalChars : Set of characters that will be accepted
     Term : Set of characters that will cause EditLine to Exit
            (Note LegalChars need not contain Term)
     TC : Character that caused EditLn to exit
}

  VAR
    P    : Byte;
    Ch   : Char;
    first : Boolean;

  BEGIN
    first := True;
    GotoXY(X, Y); Write(S);
    P := 0;
    REPEAT
      GotoXY(X + P, Y);
      Ch := ScanKey;
      IF NOT(Upcase(Ch) IN Term) THEN
        CASE Ch OF
          #32..#126 : IF (P < Len) AND
                      (Ch IN LegalChars) THEN
                        BEGIN
                          IF first THEN
                            BEGIN
                              Write(' ':Len);
                              Delete(S, P + 1, Len);
                              GotoXY(X + P, Y);
                            END;
                          IF Length(S) = Len THEN
                            Delete(S, Len, 1);
                          P := Succ(P);
                          Insert(Ch, S, P);
                          Write(Copy(S, P, Len));
                        END
                      ELSE Beep;
          ^S, LeftKey : IF P > 0 THEN
                          P := Pred(P);
          ^D, RightKey : IF P < Length(S) THEN
                           P := Succ(P);
          ^A, HomeKey : P := 0;
          ^F, EndKey : P := Length(S);
          ^G, DelKey : IF P < Length(S) THEN
                         BEGIN
                           Delete(S, P + 1, 1);
                           Write(Copy(S, P + 1, Len), ' ');
                         END;
          BS : IF P > 0 THEN
                 BEGIN
                   Delete(S, P, 1);
                   Write(^H, Copy(S, P, Len), ' ');
                   P := Pred(P);
                 END;
          ^Y : BEGIN
                 Write(' ':Len);
                 Delete(S, P + 1, Len);
               END;
        ELSE ;
        END;                      {of case}
      first := False;
    UNTIL Upcase(Ch) IN Term;
    P := Length(S);
    GotoXY(X + P, Y);
    Write('':Len - P);
    TC := Upcase(Ch);
  END;                            { EditLine }

(*
 *    Function:
 *      Error
 *
 *    Arguments:
 *        RC                  return code from a PX... function
 *
 *    Description:
 *        Writes error message if an error has occurred.
 *
 *    Returns:
 *        True if Error
 *        else False
 *)
  FUNCTION PXS_TableDesc.Error(RC : Integer) : Boolean;

  BEGIN
    IF RC <> PXSUCCESS THEN
      BEGIN
        GotoXY(1, 1);
        WriteLn('PxTest: ', RC, ':', PXErrMsg(RC));
      END;
    Error := RC <> PXSUCCESS;
  END;                            (* Error *)


  FUNCTION Error(RC : Integer) : Boolean;
  VAR
    Ch   : Char;
  BEGIN
    IF RC <> PXSUCCESS THEN
      BEGIN
        GotoXY(1, 1);
        WriteLn('PxTest: ', RC, ':', PXErrMsg(RC));
        Ch := ReadKey;
      END;
    Error := RC <> PXSUCCESS;
  END;                            (* Error *)

(*
 *    Procedure:
 *      ErrIgnore
 *
 *    Arguments:
 *        RC                  return code from a PX... function
 *
 *    Description:
 *        Writes error message if an error has occurred.
 *
 *    Returns:
 *      None
 *)
  PROCEDURE PXS_TableDesc.ErrIgnore(RC : Integer);

  BEGIN
    IF Error(RC) THEN ;           (* ignore error return code *)
  END;                            (* ErrIgnore *)

  PROCEDURE PXS_TableDesc.Init(VAR PXS_TD : PXS_TableDesc);
  BEGIN
    FillChar(PXS_TD, SizeOf(PXS_TD), 0);
  END;

  FUNCTION PXS_TableDesc.PXSOpen(VAR PXS_TD : PXS_TableDesc) : Boolean;

  VAR
    I    : Integer;

  BEGIN
    PXSOpen := True;

    WITH PXS_TD DO
      BEGIN

        IF Error(PXTblOpen(TableName, TableHandle, 0, False)) THEN
          BEGIN
            PXSOpen := False;
            WriteLn('OpenFiles failed');
            Exit;
          END;

        IF Error(PXTblName(TableHandle, TableName)) THEN
          BEGIN
            WriteLn('Cannot access table ', TableName);
            Halt(1);
          END;

        IF Error(PXRecBufOpen(TableHandle, RecHandle)) THEN
          BEGIN
            PXSOpen := False;
            WriteLn('Error in Record buffer open');
            Exit;
          END;

        IF Error(PXRecNFlds(TableHandle, NBRFields)) THEN
          BEGIN
            Write('Error in # Fields');
            Halt(1);
          END;

        IF Error(PXKeyNFlds(TableHandle, NBRKeys)) THEN
          BEGIN
            Write('Error in # keys');
            Halt(1);
          END;

        FOR I := 1 TO NBRFields DO
          BEGIN
            IF Error(PXFldName(TableHandle, I, Field[I].F_Name)) THEN
              BEGIN
                PXSOpen := False;
                WriteLn('Error in FieldName');
                Exit;
              END;
            IF Error(PXFldType(TableHandle, I, Field[I].F_Type)) THEN
              BEGIN
                PXSOpen := False;
                WriteLn('Error in field type');
                Exit;
              END;
          END;

        IF Error(PXTblNRecs(TableHandle, NBRRecs)) THEN
          BEGIN
            WriteLn('Cannot access table ', TableName);
            PXSOpen := False;
            Exit;
          END;

        IF NBRRecs > 0 THEN
          BEGIN
            IF Error(PXRecFirst(TableHandle)) THEN
              BEGIN
                PXSOpen := False;
                WriteLn('Error in RecFirst');
                Exit;
              END;


            IF Error(PXRecGet(TableHandle, RecHandle)) THEN
              BEGIN
                PXSOpen := False;
                WriteLn('Error in RecGet');
                Exit;
              END;
          END;
      END;
  END;

  FUNCTION PXS_TableDesc.PXSGetData(FH : Word; VAR PXS_TD : PXS_TableDesc) : Boolean;

  VAR
    TheDate : LongInt;
    Month, Day, Year : Integer;
    TheValue : Double;
    TheShort : Integer;
    IsBlank : Boolean;
    Help : String;
    TheChar : Char;

  BEGIN
    (* if this field is blank, we want to return a blank string *)
    PXSGetData := SUCCESS;

    WITH PXS_TD DO
      BEGIN

        TheChar := Field[FH].F_Type[1];
        IF NOT Error(PXFldBlank(RecHandle, FH, IsBlank)) THEN
          IF IsBlank THEN
            Field[FH].F_Content := ''
          ELSE
            CASE Upcase(TheChar) OF
              'A' :
                IF Error(PXGetAlpha(RecHandle, FH, Field[FH].F_Content)) THEN
                  PXSGetData := FAILURE;
              'D' :
                IF NOT Error(PXGetDate(RecHandle, FH, TheDate)) THEN
                  BEGIN
                    ErrIgnore(PXDateDecode(TheDate, Month, Day, Year));
                    Str(Month, Field[FH].F_Content);
                    Str(Day, Help);
                    Field[FH].F_Content := Field[FH].F_Content + '/' + Help;
                    Str(Year, Help);
                    Field[FH].F_Content := Field[FH].F_Content + '/' + Help;
                  END
                ELSE
                  PXSGetData := FAILURE;
              'N' :
                IF NOT Error(PXGetDoub(RecHandle, FH, TheValue)) THEN
                  Str(TheValue:5:0, Field[FH].F_Content)
                ELSE
                  PXSGetData := FAILURE;
              '$' :
                IF NOT Error(PXGetDoub(RecHandle, FH, TheValue)) THEN
                  Str(TheValue:6:2, Field[FH].F_Content)
                ELSE
                  PXSGetData := FAILURE;
              'S' :
                IF NOT Error(PXGetShort(RecHandle, FH, TheShort)) THEN
                  Str(TheShort, Field[FH].F_Content)
                ELSE
                  PXSGetData := FAILURE;
            END                   (* CASE *)
        ELSE
          PXSGetData := FAILURE;  (* an error occured in PXFldBlank *)
        {69}
      END;
  END;                            (* GetData *)

  FUNCTION PXS_TableDesc.PXSPutData(FH : Word; VAR PXS_TD : PXS_TableDesc) : Boolean;

  VAR
    TheDate : LongInt;
    Month, Day, Year : Integer;
    TheValue : Double;
    TheShort : Integer;
    IsBlank : Boolean;
    Help : String;
    TheChar : Char;
    ErrCode : Integer;

  BEGIN
    PXSPutData := SUCCESS;

    WITH PXS_TD DO
      BEGIN

        TheChar := Field[FH].F_Type[1];
        CASE Upcase(TheChar) OF
          'A' : IF Error(PXPutAlpha(RecHandle, FH, Field[FH].F_Content)) THEN
                  BEGIN
                    {WriteLn('Invalid Alpha string');}
                    PXSPutData := FAILURE;
                  END;
          'D' : BEGIN
                  Val(Copy(Field[FH].F_Content, 1, 2), Month, ErrCode);
                  IF ErrCode <> 0 THEN
                    BEGIN
                      WriteLn('Invalid Month.');
                      Exit;
                    END;
                  Val(Copy(Field[FH].F_Content, 4, 2), Day, ErrCode);
                  IF ErrCode <> 0 THEN
                    BEGIN
                      WriteLn('Invalid Day.');
                      Exit;
                    END;
                  Val(Copy(Field[FH].F_Content, 7, 2), Year, ErrCode);
                  IF ErrCode <> 0 THEN
                    BEGIN
                      WriteLn('Invalid Day.');
                      Exit;
                    END;
                  IF Error(PxDateEncode(Month, Day, Year, TheDate)) THEN
                    BEGIN
                      WriteLn('Incorrect date format.');
                      Exit;
                    END;
                  IF Error(PXPutDate(RecHandle, FH, TheDate)) THEN
                    PXSPutData := FAILURE;
                END;
          'N' : BEGIN
                  IF Field[FH].F_Content = '' THEN Field[FH].F_Content := '0';
                  Val(Field[FH].F_Content, TheValue, ErrCode);
                  IF Error(PXPutDoub(RecHandle, FH, TheValue)) OR
                  (ErrCode <> 0) THEN
                    PXSPutData := FAILURE;
                END;
          '$' : BEGIN
                  IF Field[FH].F_Content = '' THEN Field[FH].F_Content := '0';
                  Val(Field[FH].F_Content, TheValue, ErrCode);
                  IF Error(PXPutDoub(RecHandle, FH, TheValue)) OR
                  (ErrCode <> 0) THEN
                    BEGIN
                      {WriteLn('Error $');}
                      PXSPutData := FAILURE;
                    END;
                END;
          'S' : BEGIN
                  IF Field[FH].F_Content = '' THEN Field[FH].F_Content := '0';
                  Val(Field[FH].F_Content, TheValue, ErrCode);
                  IF Error(PXPutShort(RecHandle, FH, TheShort)) OR
                  (ErrCode <> 0) THEN
                    PXSPutData := FAILURE;
                END;
        END;
      END;
  END;                            (* GetData *)

  FUNCTION PXS_TableDesc.PXSCreateDummy : Boolean;
  VAR
    PXTestFields, PXTestTypes : NamesArrayPtr;
  BEGIN

    PXSCreateDummy := True;
    New(PXTestFields);
    New(PXTestTypes);
    PXTestFields^[1] := 'First Field';
    PXTestTypes^[1] := 'A10';
    PXTestFields^[2] := 'Second Field';
    PXTestTypes^[2] := 'A10';
    PXTestFields^[3] := 'Third Field';
    PXTestTypes^[3] := 'A10';
    PXTestFields^[4] := 'Fourth Field';
    PXTestTypes^[4] := 'A10';
    IF Error(PXTblCreate('PXTEST', 4, PXTestFields, PXTestTypes)) THEN
      BEGIN
        WriteLn('Cannot Open PXTEST. Halting...');
        PXSCreateDummy := False;
        Halt(1);
      END;

  END;

  FUNCTION PXS_TableDesc.PXSReadCurr(VAR PXS_TD : PXS_TableDesc) : Boolean;
  VAR
    FldNumber : Integer;
  BEGIN
    IF Error(PXRecGet(PXS_TD.TableHandle, PXS_TD.RecHandle)) THEN
      BEGIN
        WriteLn('Could not get record data. Halting...');
        PXSReadCurr := False;
      END
    ELSE
      FOR FldNumber := 1 TO PXS_TD.NBRFields DO
        IF NOT PXSGetData(FldNumber, PXS_TD) THEN
          PXSReadCurr := False
        ELSE
          PXSReadCurr := True;
  END;

  FUNCTION PXS_TableDesc.PXSReadNext(VAR PXS_TD : PXS_TableDesc) : Boolean;
  VAR
    FldNumber : Integer;
  BEGIN
    IF Error(PXRecNext(PXS_TD.TableHandle)) OR
    Error(PXRecGet(PXS_TD.TableHandle, PXS_TD.RecHandle)) THEN
      BEGIN
        WriteLn('Could not get record data. Halting...');
        PXSReadNext := False;
      END
    ELSE
      FOR FldNumber := 1 TO PXS_TD.NBRFields DO
        IF NOT PXSGetData(FldNumber, PXS_TD) THEN
          PXSReadNext := False
        ELSE
          PXSReadNext := True;
  END;

  FUNCTION PXS_TableDesc.PXSReadPrev(VAR PXS_TD : PXS_TableDesc) : Boolean;
  VAR
    FldNumber : Integer;
  BEGIN
    IF Error(PXRecPrev(PXS_TD.TableHandle)) OR
    Error(PXRecGet(PXS_TD.TableHandle, PXS_TD.RecHandle)) THEN
      BEGIN
        WriteLn('Could not get record data. Halting...');
        PXSReadPrev := False;
      END
    ELSE
      FOR FldNumber := 1 TO PXS_TD.NBRFields DO
        IF NOT PXSGetData(FldNumber, PXS_TD) THEN
          PXSReadPrev := False
        ELSE
          PXSReadPrev := True;
  END;

(*
** Function:		PxPartialSearch
**
** Parameters:
**
**                      TblHandle	table to search
**
**			SearchString	string to locate
**
**			FldHandle	field to search
**
**			Mode		SEARCHFIRST or SEARCHNEXT
**
**                      CaseSensitive	True if CaseSensitive
**
** Returns:
**
**			PXSUCCESS if record found
**			PXERR_RECNOTFOUND if record not found
**
*)
  FUNCTION PXS_TableDesc.PXSPartialSearch(VAR PXS_TD : PXS_TableDesc;
                                          FldHandle : FieldHandle;
                                          SearchString : String;
                                          Mode : Integer;
                                          CaseSensitive : Boolean) : Integer;
  CONST
    Found : Boolean = False;

  VAR
    PXErr : Integer;
    Buf, Buf2 : String;
    LckHandle : LockHandle;

  BEGIN

(* Make a copy of the search string, switch to uppercase if case-insensitive
   search *)
    Buf := SearchString;

    IF CaseSensitive THEN
      Buf := UpCaseStr(Buf);

    (* save current record in case we need to return if string not found *)
    IF Mode = SearchFirst THEN
      PXErr := PXRecFirst(TableHandle)
    ELSE
      PXErr := PXRecNext(TableHandle);

    IF PXErr = PXSUCCESS THEN

      BEGIN

        PXErr := PXRecBufOpen(TableHandle, RecHandle);

        IF PXErr = PXSUCCESS THEN

          REPEAT

            PXErr := PXRecGet(TableHandle, RecHandle);
            IF PXErr = PXSUCCESS THEN
              BEGIN

                IF PXSGetData(FldHandle, PXS_TD) THEN PXErr := 0
                ELSE PXErr := 1;
                Buf2 := PXS_TD.Field[FldHandle].F_Content;

                {PxErr:=PxGetAlpha(RecHandle,FldHandle,Buf2);}

                IF PXErr = PXSUCCESS THEN
                  BEGIN

                    IF CaseSensitive THEN
                      Buf2 := UpCaseStr(Buf2);

                    IF Pos(Buf, Buf2) <> 0 THEN
                      Found := True
                    ELSE
                      PXErr := PXRecNext(TableHandle);
                  END;

              END;

          UNTIL Found OR(PXErr <> PXSUCCESS);

      END;

    IF Found THEN

      BEGIN

        PXSPartialSearch := PXSUCCESS;
        Exit;

      END

    ELSE
      IF PXErr = PxErr_EndofTable THEN
        PXSPartialSearch := PXErr_RecNotFound

    ELSE

      PXSPartialSearch := PXErr;

  END;                            { of Function PxPartialSearch }


(*
 *    Function:
 *          Compare
 *
 *    Arguments:
 *          Field             Field handle of field to compare
 *          SortOrder         ASCENDING or DESCENDING
 *
 *    Description:
 *          Compares a given field of two records
 *
 *    Returns:
 *          0                 Records are equal
 *          < 0               Records need switching
 *          > 0               Records are in sorted order
 *)
  FUNCTION PXS_TableDesc.Compare(CompField : Word;
                                 SortOrder : SortOrderT;
                                 RecHandle1, RecHandle2 : Word) : Integer;

  VAR
    RH1, RH2 : Word;
    Long1, Long2 : LongInt;
    Short1, Short2 : Integer;
    Doub1, Doub2 : Double;
    Alpha1, Alpha2 : String;
    FldType : NameString;

  BEGIN
    (* Setup records according to sortorder *)
    IF SortOrder = ASCENDING THEN
      BEGIN
        RH1 := RecHandle1;
        RH2 := RecHandle2;
      END
    ELSE
      BEGIN
        RH1 := RecHandle2;
        RH2 := RecHandle1;
      END;

    (* Get field type *)
    PXSortError(PXFldType(TableHandle, CompField, FldType));
    (* Compare fields *)
    CASE FldType[1] OF
      'D' :
        BEGIN
          PXSortError(PXGetDate(RH1, CompField, Long1));
          PXSortError(PXGetDate(RH2, CompField, Long2));
          Compare := Long2 - Long1;
        END;
      'S' :
        BEGIN
          PXSortError(PXGetShort(RH1, CompField, Short1));
          PXSortError(PXGetShort(RH2, CompField, Short2));
          Compare := Short2 - Short1;
        END;
      'A' :
        BEGIN
          PXSortError(PXGetAlpha(RH1, CompField, Alpha1));
          PXSortError(PXGetAlpha(RH2, CompField, Alpha2));
          IF Alpha2 < Alpha1 THEN
            Compare := - 1
          ELSE IF Alpha2 > Alpha1 THEN
            Compare := 1
          ELSE
            Compare := 0;
        END;
      'N', '$' :
        BEGIN
          PXSortError(PXGetDoub(RH1, CompField, Doub1));
          PXSortError(PXGetDoub(RH2, CompField, Doub2));
          IF Doub2 < Doub1 THEN
            Compare := - 1
          ELSE IF Doub2 > Doub1 THEN
            Compare := 1
          ELSE
            Compare := 0;
        END
    ELSE Compare := 0;
    END;                          (* CASE *)
  END;                            (* Compare *)

(*
 *    Procedure:
 *          ProcessElement
 *
 *    Arguments:
 *          Rec1                    Record number of first comparison record
 *          Rec2                    Record number of second comparison record
 *          NFields                       Number of fields to use in sort comparison
 *          Fields                        Array of fieldhandles
 *          SortOrder               ASCENDING or DESCENDING
 *
 *    Description:
 *          Compares two record numbers and exchanges them if needed
 *
 *    Returns:
 *          None
 *)
  PROCEDURE PXS_TableDesc.ProcessElement(Rec1, Rec2 : LongInt;
                                         RecHandle1, RecHandle2 : LongInt;
                                         NFields : Integer;
                                         SortFields : WordArray;
                                         SortOrder : SortOrderT);

  VAR
    NeedSwitch : Boolean;
    I, Ret : Integer;

  BEGIN
    (* Get the records *)

    PXSortError(PXRecGoto(TableHandle, Rec1));
    PXSortError(PXRecGet(TableHandle, RecHandle1));
    PXSortError(PXRecGoto(TableHandle, Rec2));
    PXSortError(PXRecGet(TableHandle, RecHandle2));
    (* Compare each field *)
    I := 1;
    Ret := 0;
    WHILE (I <= NFields) AND(Ret = 0) DO
      BEGIN
        Ret := Compare(SortFields[I], SortOrder, RecHandle1, RecHandle2);
        NeedSwitch := Ret < 0;
        Inc(I);
      END;
    (* Switch and update if needed *)
    IF NeedSwitch THEN
      BEGIN
        PXSortError(PXRecGoto(TableHandle, Rec1));
        PXSortError(PXRecUpdate(TableHandle, RecHandle2));
        PXSortError(PXRecGoto(TableHandle, Rec2));
        PXSortError(PXRecUpdate(TableHandle, RecHandle1));
      END;
  END;                            (* ProcessElement *)



(*
 *    Procedure:
 *          TableSort
 *
 *    Arguments:
 *          TblName                       Name of table to sort
 *          NFields                       Number of fields to use in sort
 *          Fields                        Array of field handles
 *          SortOrder               ASCENDING or DESCENDING
 *
 *    Description:
 *          Sorts a table using a standard Shell sort on a given
 *          table
 *
 *    Returns:
 *          None
 *)
  PROCEDURE PXS_TableDesc.TableSort(VAR PXS_TD : PXS_TableDesc;
                                    NFieldsToSort : Integer;
                                    SortFields : WordArray;
                                    SortOrder : SortOrderT);

  VAR
    Span,                         (* span of current sort *)
    NRecs : LongInt;
    RecHandle1, RecHandle2 : Word;
    I    : Integer;               (* Shell sort counter *)

  BEGIN
    (* Open table with buffering *)
    {PXSortError(PXTblOpen(TableName, TableHandle, 0, True));}
    (* Get number of recs *)
    PXSortError(PXTblNRecs(TableHandle, NRecs));
    (* Allocate 2 record handles *)
    PXSortError(PXRecBufOpen(TableHandle, RecHandle1));
    PXSortError(PXRecBufOpen(TableHandle, RecHandle2));
    (* Perform Shell sort on records *)
    FOR Span := NRecs DIV 2 DOWNTO 1 DO
      FOR I := 1 TO NRecs - Span DO
        ProcessElement(I, I + Span, RecHandle1, RecHandle2,
                       NFieldsToSort, SortFields, SortOrder);
    (* Deallocate everything *)
    PXSortError(PXRecBufClose(RecHandle1));
    PXSortError(PXRecBufClose(RecHandle2));
    {PXSortError(PXTblClose(TableHandle));}
  END;                            (* TableSort *)

  FUNCTION PXS_TableDesc.DelCurrRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
  BEGIN
    IF Error(PXRecDelete(TableHandle)) THEN DelCurrRec := False
    ELSE DelCurrRec := True;
  END;

  FUNCTION PXS_TableDesc.UpdateRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
  BEGIN
    IF Error(PXRecUpdate(TableHandle, RecHandle)) THEN UpdateRec := False
    ELSE UpdateRec := True;
  END;

  FUNCTION PXS_TableDesc.AppendRec(VAR PXS_TD : PXS_TableDesc) : Boolean;
  BEGIN
    IF Error(PXRecAppend(TableHandle, RecHandle)) THEN AppendRec := False
    ELSE AppendRec := True;
  END;

BEGIN

  (* Initialize the Engine *)
  IF Error(PXNetInit(NETPATH, NETTYPE, NETUSERNAME)) THEN
    BEGIN
      WriteLn('Could not initialize PARADOX ENGINE');
      Halt;
    END;

  IF Error(PXGetDefaults(PXD_SwapSize, PXD_MaxTables, PXD_MaxRecBufs,
                         PXD_MaxLocks, PXD_Maxfiles, PXD_SortTable)) THEN
    BEGIN
      WriteLn('Could not get defaults');
      Halt;
    END;

END.
