COMMENT *

FILE        pWINDOW.ASM

            John Tal
            Rollins Medical/Dental Systems
            Southfield, MI

             
            Wget(BX,By,Bw,Bh,BUFFER) will save the specified window into 
            BUFFER.   Bx,By,Bw,Bh are BYTES, Buffer is a BYTE array

            Wget(Bx,By,Bw,Bh,BUFFER) will restore the specified window 
            from BUFFER.

 
            Based on RWINDOW routines by Rollins Medical/Dental Systems
            for saving screen images to QuickBasic string type.



            Thanks to

                     John Sieraski (Sysop Bproga) 76117,2022
                     Michael Day                  73577,2225
                     Brian Foley                  76317,3247

                and especially

                     Steve Rollins, original author of Rwindow.Asm.

                     
                     Without the assistance of these brave men, this
                     trivial piece of code would not be possible.



* ----------------------------------------------------------------

DATA        SEGMENT BYTE PUBLIC

WX1         DB      ?                   ; X1
WY1         DB      ?                   ; Y1
WX2         DB      ?                   ; X2
WY2         DB      ?                   ; Y2


DATA        ENDS



CODE        SEGMENT BYTE PUBLIC

            ASSUME  CS:CODE,DS:DATA

            PUBLIC  WGET,WPUT

;  procedure  Wget (x,  y,  w,  h:byte; buffer:buff_ptr);
;stack positions -> 16, 14, 12, 10,     8:6 pointer (DS:SI)


WGET        PROC    FAR                 ; entry point 

            PUSH    BP                  ; save Turbos's bp & ds
            MOV     BP,SP               ; get addressability to stack

            PUSH    DS                  ; setup for local data  

            MOV     AX,DATA
            MOV     DS,AX

            MOV     AX,[BP+8]           ; get Pointer Segment to byte BUFFER pushed first 

            MOV     ES,AX 		; will use ES:DI to get at buffer

            MOV     DI,[BP+6]           ; get Pointer Offset, next word paramater
                                        ; 

            MOV     AL,[BP+16]          ; 
            DEC     AL                  ; change col to 0 - 24
            MOV     WX1,AL              ; BX = X1

            MOV     AH,[BP+14]          ;
            DEC     AH                  ; change row to 0 - 24
            MOV     WY1,AH              ; BY = Y1

            MOV     CL,[BP+12]          ; bw
            DEC     CL                  ;
            ADD     CL,AL               ; BX+BW = X2
            MOV     WX2,CL              ;

            MOV     CH,[BP+10]          ; bh
            DEC     CH                  ;
            ADD     CH,AH               ; BY+BH = Y2
            MOV     WY2,CH              ; 




            MOV     AH,15D              ; service 15: get current video mode
            INT     10H                 ; request ROM-BIOS video service
                                        ; this puts display page into bh

            MOV     AH,3D               ; service 3: read cursor position
            INT     10H                 ; request ROM-BIOS video service

            MOV     [DI],CX             ; put cursor size in buffer$
            INC     DI                  ; 
            INC     DI                  ; 

            MOV     [DI],DX             ; put cursor pos BUFFER   
            INC     DI                  ;
            INC     DI                  ;



            MOV     DH,WY1              ; set row to top

LOOP1:      MOV     DL,WX1              ; set column to left

LOOP2:      MOV     AH,2D               ; service 2: set cursor position
            INT     10H                 ; request ROM-BIOS video service

            MOV     AH,8D               ; service 8: read character and attribute
            INT     10H                 ; request ROM-BIOS video service

            MOV     [DI],AX          
            INC     DI                  ; increment past char
            INC     DI                  ; increment  past attrib

            INC     DL                  ; increment column
            CMP     DL,WX2              ; finished with this row?
            JLE     LOOP2               ; jump if not

            INC     DH                  ; increment row
            CMP     DH,WY2              ; finshed?
            JLE     LOOP1               ; jump if not

ENDSAVE:    
            POP     DS                  ; restore ds
            POP     BP                  ; restore bp

            RET     12                  ; 

WGET        ENDP


;  procedure  Wput (x,  y,  w,  h:byte; buffer:buff_ptr);
;stack positions -> 16, 14, 12, 10,     8:6 pointer (DS:SI)


WPUT        PROC    FAR                 ; entry point

            PUSH    BP                  ; save Turbo bp & ds
            MOV     BP,SP               ; get addressability to stack

            PUSH    DS

            MOV     AX,DATA
            MOV     DS,AX

            MOV     AX,[BP+8]           ; get Pointer Segment to byte BUFFER 

            MOV     ES,AX 

            MOV     DI,[BP+6]            ; get Pointer Offset 


            MOV     AL,[BP+16]          ; get top row
            DEC     AL                  ; change row to 0 - 24
            MOV     WX1,AL              ; BX = X1

            MOV     AH,[BP+14]          ; get bottom row
            DEC     AH                  ; change row to 0 - 24
            MOV     WY1,AH              ; BY = Y1

            MOV     CL,[BP+12]          ; bw
            DEC     CL                  ;
            ADD     CL,AL               ; BX+BW = X2
            MOV     WX2,CL              ;

            MOV     CH,[BP+10]          ; bw
            DEC     CH                  ;
            ADD     CH,AH               ; BY+BH = Y2
            MOV     WY2,CH              ; 

	    PUSH    DI
            ADD     DI,4                ; set si to first char/byte

            MOV     AH,15D              ; service 15: get current video mode
            INT     10H                 ; request ROM-BIOS video service
                                        ; this puts display page into bh

            MOV     CX,1                ; repetition count for service 9



            MOV     DH,WY1              ; set row to top

LOOP3:      MOV     DL,WX1              ; set column to left

LOOP4:      MOV     AH,2D               ; service 2: set cursor position
            INT     10H                 ; request ROM-BIOS video service

            MOV     AL,[DI]             ; get character
            INC     DI                  ; increment si
            MOV     BL,[DI]             ; get attribute
            INC     DI                  ; increment si
            MOV     AH,9D               ; service 8: write character and attribute
            INT     10H                 ; request ROM-BIOS video service

            INC     DL                  ; increment column
            CMP     DL,WX2              ; finished with this row?
            JLE     LOOP4               ; jump if not

            INC     DH                  ; increment row
            CMP     DH,WY2              ; finshed?
            JLE     LOOP3               ; jump if not

            POP     DI                  ; retrieve address of BUFFER start

            MOV     CX,[DI]             ; get cursor size
            MOV     AH,1D               ; service 1: set cursor size
            INT     10H                 ; request ROM-BIOS video service

            MOV     DX,[DI+2]           ; get row and column
            MOV     AH,2D               ; service 2: set cursor position
            INT     10H                 ; request ROM-BIOS video service

ENDREST:    POP     DS
            POP     BP                  ; restore bp

            RET     12                  ; 4 byte/words and byte pointer

WPUT        ENDP



CODE        ENDS

            END

