{ ========================================================================== }
{ Goof.pas - Displays fatal programming errors            ver 7.0b, 09-24-93 }
{                                                                            }
{ This file contains a convenient way to alert you of programming errors     }
{ since it is possible to create unseen errors with virtual and hidden       }
{ windows.  You can edit and recompile this unit at any time since it is     }
{ a circular call.                                                           }
{   Copyright (C) 1993 by James H. LeMay,  All rights reserved.              }
{ ========================================================================== }

{$A-,B-,F-,P-,Q-,R-,S-,T-,V-,X+}

{ Set $D+ in your compiler if you want to see the error messages at run time.}


UNIT Goof;

INTERFACE

procedure ShowGoof (ErrorNum: byte);


IMPLEMENTATION

uses
  Qwik, Wndw;

procedure ShowGoof; { (ErrorNum: byte); }
type
  Str41 = string[41];
var
  Msg1,Msg2,MemS,MaxS: Str41;
begin
{$ifopt D+ }
  Msg2 := '';
  case ErrorNum of
    1: begin
         Msg1 := 'Not enough Heap space!';
         Str (memavail,MemS);
         Str (maxavail,MaxS);
         Msg2 := 'Mem='+MemS+'/'+'Max='+MaxS;
       end;
    2: Msg1 := 'Too many Windows!';
     {$ifdef AddVirtual }
    3: Msg1 := 'Too many Virtual Windows!';
     {$endif }
    4: Msg1 := 'Perm window out of order!';
    5: Msg1 := 'No window to remove!';
    6: Msg1 := 'Hidden window not found!';
     {$ifdef AddVirtual }
    7: Msg1 := 'Virtual screen not found!';
     {$endif }
     {$ifdef MultiPage }
    8: Msg1 := 'Video page not available!';
     {$endif }
   10: Msg1 := 'A Submenu could not fit!';
  end;
{$endif }
  TopWndwStat := WndwStat[0];   { Get original CRT stat }
  QScrRec := TWS.VScrRec;       { Set Qwik stats }
   {$ifdef MultiPage }
  QwritePage (0);               { Ensure we are writing to page 0 }
  QviewPage (0);                { Ensure we are viewing page 0 }
   {$endif }
  LI  := 0;                     { Set top window level }
  HLI := 2;                     { Prevent index conflict }
  WindowModes := RelMode;
  MakeWindow (0,0,5,42,LightGrayBG,LightGrayBG+Blink,DoubleBrdr,aWindow);
{$ifopt D+ }
  WWriteC (1,Msg1);
  WWriteC (2,Msg2);
{$endif }
  WWriteC (3,'Program halted.');
  GotoRC (CrtRows-1,1);
  SetCursor (CursorInitial);
  Halt;
end;

END.
