{ ========================================================================== }
{ Strs.pas - accesses Str procedure for use as a          ver 7.0b, 09-24-93 }
{            function.                                                       }
{                                                                            }
{ Directly addressing the function result keeps routine from having to copy  }
{ the string twice and thus increasing speed.  Functions save code in the    }
{ long run.  In addition, code can be removed as is from this unit and       }
{ placed in a main program if near calls and returns are preferred.          }
{                                                                            }
{  Copyright (C) 1993 James H. LeMay, All rights reserved.                   }
{ ========================================================================== }

UNIT Strs;

INTERFACE

function StrL   (L: longint):                       string;
function StrLF  (L: longint; Field: integer):       string;
function StrR   (R: real):                          string;
function StrRF  (R: real; Field: integer):          string;
function StrRFD (R: real; Field,Decimals: integer): string;


IMPLEMENTATION

type
  tLStkRec =
    record
      StkLong: longint;
      pResult: ^string;
    end;
  tRStkRec =
    record
      StkReal: real;
      pResult: ^string;
    end;

function StrL (L: longint): string;
var  StkRec: tLStkRec absolute L;
begin
  str (L,StkRec.pResult^);
end;

function StrLF (L: longint; Field: integer): string;
var  StkRec: tLStkRec absolute L;
begin
  str (L:Field,StkRec.pResult^);
end;

function StrR (R: real): string;
var  StkRec: tRStkRec absolute R;
begin
  str (R,StkRec.pResult^);
end;

function StrRF (R: real; Field: integer): string;
var  StkRec: tRStkRec absolute R;
begin
  str (R:Field,StkRec.pResult^);
end;

function StrRFD (R: real; Field,Decimals: integer): string;
var  StkRec: tRStkRec absolute R;
begin
  str (R:Field:Decimals,StkRec.pResult^);
end;

END.
