{

                                                      ͻ
                                                         XMS Heap       
                                                                        
                                                          Rev.  1.03    
                                                      ͼ

}

{$F+} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Unit XMSHeap;

Interface

Uses DosMem,TPXMS;

Const
  MaxPointers       = 255;

  BlockFree         = 0;        {Free XMS Memory Block}
  BlockUsed         = 1;        {Allocated in XMS, not in Conventional}
  BlockRead         = 2;        {Allocated in XMS and Conventional (Read Mode)}
  BlockReadWrite    = 3;        {Allocated in XMS and Conventional (R/W Mode)}
  BlockWrite        = 4;        {Allocated in XMS and Conventional (Write Mode)}

  XMSReadMode       = 0;
  XMSReadWriteMode  = 1;
  XMSWriteMode      = 2;

  DebugFileName     = 'FREEXMS.PAS';

Type
  XMSModes          = XMSReadMode..XMSWriteMode;

  OneXMSPointer     = Record
                        XMSAddr  :LongInt;    {Offset into XMS Heap}
                        ConvAddr :Pointer;    {Pointer to Conventional Memory}
                        Size     :LongInt;    {Size in Bytes of Pointer}
                        Status   :Byte;       {Block Status}
                      End;

  AllXMSPointers    = Array [1..MaxPointers] Of OneXMSPointer;

Procedure GetXMSHeap     (Amount:Word);
Procedure FreeXMSHeap;

Function  MaxXMSAvail    :LongInt;
Function  XMSAvail       :LongInt;

Procedure GetXMS         (Var Handle:Word;Size:LongInt);
Procedure FreeXMS        (Handle:Word);

Procedure AwakePointer   (Handle:Word;Var P:Pointer;Mode:XMSModes);
Procedure SleepPointer   (Handle:Word);

Var
  XMSHeapSize   :Word;

Implementation

Var
  HeapPointer   :^AllXMSPointers;
  OldExitProc   :Pointer;
  HeapHandle    :Word;

{$IFNDEF FINAL}

Procedure CreateDebugFile;

Var
  F     :Text;

Begin
  Assign(F,DebugFileName);
  Rewrite(F);
  WriteLn(F,'Uses TPXMS;');
  WriteLn(F,'Begin');
  WriteLn(F,'FreeExtMemBlockXMS(',HeapHandle,');');
  WriteLn(F,'End.');
  Close(F);
End;

{$ENDIF}

Procedure Fatal(Num:Word);
Begin
  WriteLn;
  Case Num Of
     1:WriteLn('XMS Heap Overflow (Need more XMS Memory)');
     2:WriteLn('Out of XMS Heap Handles (Programming Error)');
     3:WriteLn('XMS Data Transfer Error ',XMSError,'.');
  End;
  WriteLn;
  Halt;
End;

Procedure GetXMSHeap(Amount:Word);         {Call ONCE Only}
Begin
  HeapHandle:=AllocExtMemBlockXMS(Amount);
  If XMSResult=1 Then
  Begin
    OldExitProc:=ExitProc;
    ExitProc:=@FreeXMSHeap;
    HeapPointer^[1].Size:=LongInt(Amount)*1024;
    HeapPointer^[1].XMSAddr:=0;
    XMSHeapSize:=Amount;
    {$IFNDEF FINAL} CreateDebugFile; {$ENDIF}
  End
  Else
  Begin
    HeapHandle:=0;
    XMSHeapSize:=0;
  End;
End;

Procedure FreeXMSHeap;
Begin
  FreeExtMemBlockXMS(HeapHandle);
  ExitProc:=OldExitProc;
  FillChar(HeapPointer^,SizeOf(HeapPointer^),0);

  {$IFNDEF FINAL}

  If XMSResult<>1 Then Fatal(3);

  {$ENDIF}
End;

Function MaxXMSAvail:LongInt;

Var
  Size   :LongInt;
  X      :Word;

Begin
  X:=2;
  Size:=HeapPointer^[1].Size;
  While (HeapPointer^[X].Size>0) And (X<=MaxPointers) do
  Begin
    If HeapPointer^[X].Status=BlockFree Then
      If HeapPointer^[X].Size>Size Then
        Size:=HeapPointer^[X].Size;
    Inc(X);
  End;
  MaxXMSAvail:=Size;
End;

Function XMSAvail:LongInt;

Var
  Size   :LongInt;
  X      :Word;

Begin
  X:=2;
  Size:=HeapPointer^[1].Size;
  While (HeapPointer^[X].Size>0) And (X<=MaxPointers) do
  Begin
    If HeapPointer^[X].Status=BlockFree Then
      Size:=Size+HeapPointer^[X].Size;
    Inc(X);
  End;
  XMSAvail:=Size;
End;

Function IndexForData(Amount:LongInt):Word;

Var
  X     :Word;
  Found :Boolean;

Begin
  X:=1;
  Found:=False;
  While (Not Found) And (X<=MaxPointers) do
  Begin
    If (HeapPointer^[X].Status=BlockFree) And (HeapPointer^[X].Size>=Amount) Then
      Found:=True
    Else
      Inc(X);
  End;
  If Not Found Then
    IndexForData:=0
  Else
    IndexForData:=X;
End;

Function FindBlankIndex:Word;

Var
  X     :Word;
  Found :Boolean;

Begin
  X:=1;
  Found:=False;
  While (Not Found) And (X<MaxPointers) do
  Begin
    If HeapPointer^[X].Size=0 Then
      Found:=True
    Else
      Inc(X);
  End;
  If Not Found Then
    FindBlankIndex:=0
  Else
    FindBlankIndex:=X;
End;

Procedure GetXMS(Var Handle:Word;Size:LongInt);

Var
  FreeIndex  :Word;

Begin
  If Odd(Size) Then Inc(Size);
  Handle:=IndexForData(Size);
  If Handle = 0 Then Fatal(1);
  If HeapPointer^[Handle].Size>Size Then
  Begin
    FreeIndex:=FindBlankIndex;
    If FreeIndex=0 Then Fatal(2);

    HeapPointer^[FreeIndex].Size     :=HeapPointer^[Handle].Size - Size;
    HeapPointer^[FreeIndex].Status   :=BlockFree;
    HeapPointer^[FreeIndex].XMSAddr  :=HeapPointer^[Handle].XMSAddr + Size;

    HeapPointer^[Handle].Size        :=Size;
  End;

  HeapPointer^[Handle].Status        :=BlockUsed;
End;

Procedure FreeXMS(Handle:Word);

Var
  X     :Word;

Begin
  HeapPointer^[Handle].Status:=BlockFree;

  X:=Handle+1;
  While (X<MaxPointers) And (HeapPointer^[X].Status=BlockFree) do
  Begin
    If HeapPointer^[X].Size>0 Then
    Begin
      Inc(HeapPointer^[Handle].Size,HeapPointer^[X].Size);
      HeapPointer^[X].Size:=0;
    End;
    Inc(X);
  End;
End;

Procedure AwakePointer(Handle:Word;Var P:Pointer;Mode:XMSModes);

Var
  AlreadyIn:Boolean;
  XMSInfo  :ExtMemMoveStruct;

Begin
  If HeapPointer^[Handle].Status in [BlockRead,BlockReadWrite,BlockWrite] Then
    AlreadyIn:=True
  Else
    AlreadyIn:=False;

  Case Mode Of
    XMSReadMode      :HeapPointer^[Handle].Status:=BlockRead;
    XMSReadWriteMode :HeapPointer^[Handle].Status:=BlockReadWrite;
    XMSWriteMode     :HeapPointer^[Handle].Status:=BlockWrite;
  End;

  If AlreadyIn Then
    P:=HeapPointer^[Handle].ConvAddr
  Else
  Begin
    GetMem(P,HeapPointer^[Handle].Size);
    HeapPointer^[Handle].ConvAddr:=P;
    If Mode in [XMSReadMode,XMSReadWriteMode] Then
    Begin
      XMSInfo.Length       :=HeapPointer^[Handle].Size;
      XMSInfo.SourceHandle :=HeapHandle;
      XMSInfo.SourceOffset :=HeapPointer^[Handle].XMSAddr;
      XMSInfo.DestHandle   :=0;
      PokeAddrXMS(XMSInfo.DestOffset,Seg(P^),Ofs(P^));
      MoveExtMemBlockXMS(XMSInfo);

      {$IFNDEF FINAL}

      If XMSResult<>1 Then Fatal(3);

      {$ENDIF}

    End;
  End;
End;

Procedure SleepPointer(Handle:Word);

Var
  XMSInfo  :ExtMemMoveStruct;

Begin
  If Not(HeapPointer^[Handle].Status=BlockRead) Then
  Begin
    XMSInfo.Length       :=HeapPointer^[Handle].Size;
    XMSInfo.SourceHandle :=0;
    PokeAddrXMS(XMSInfo.SourceOffset,Seg(HeapPointer^[Handle].ConvAddr^),
                                     Ofs(HeapPointer^[Handle].ConvAddr^) );
    XMSInfo.DestHandle   :=HeapHandle;
    XMSInfo.DestOffset   :=HeapPointer^[Handle].XMSAddr;
    MoveExtMemBlockXMS(XMSInfo);

    {$IFNDEF FINAL}

    If XMSResult<>1 Then Fatal(3);

    {$ENDIF}

  End;
  FreeMem(HeapPointer^[Handle].ConvAddr,HeapPointer^[Handle].Size);
  HeapPointer^[Handle].Status:=BlockUsed;
End;

Begin
  System.New(HeapPointer);
  FillChar(HeapPointer^,SizeOf(HeapPointer^),0);
End.

{ Copyright 1993, Michael Gallias }
