{

                                                      ͻ
                                                        PGUI BGI        
                                                        Mouse Unit      
                                                          Rev.  1.00    
                                                      ͼ

}

Unit PGUIBMSE;

{$F+} {$O-} {$A+} {$G+}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Interface

Uses Graph,PGUIMDef,Icons;

Var
  MouseX,
  MouseY,
  MouseSizeX,
  MouseSizeY,
  MouseMaxX,
  MouseMaxY             :Word;
  MouseBackgroundSize   :Word;
  MousePicture,
  MouseMask,
  MouseBackgroundSave,
  MouseDefaultPicture,
  MouseDefaultMask      :Pointer;
  MouseHideCount        :Byte;          {255 is Show}
  OldExitProc           :Pointer;

Procedure ControlMouse;
Procedure Show;
Procedure Hide;
Procedure SetXY          (X,Y:Word);
Procedure SetBounds      (X1,Y1,X2,Y2:Word);
Procedure SetShape       (Shape:Pointer);

Implementation

Var
  Busy  :Boolean;

{$S-}
Procedure ControlMouse;
Begin
  Asm
    pusha
    push     ds
    push     es
    mov      ax, SEG @Data
    mov      ds, ax
  End;

  If Not Busy Then
  Begin

    If MouseHideCount=255 Then
    Begin
      PutImage(MouseX,MouseY,MouseBackgroundSave^,CopyPut);
      Asm
        mov   ax, 3
        int   33h
        mov   MouseX, cx
        mov   MouseY, dx
      End;
      GetImage(MouseX,MouseY,MouseX+MouseSizeX,MouseY+MouseSizeY,MouseBackgroundSave^);
      PutImage(MouseX,MouseY,MouseMask^,AndPut);
      PutImage(MouseX,MouseY,MousePicture^,OrPut);
    End
    Else
    Asm
      mov   ax, 3
      int   33h
      mov   MouseX, cx
      mov   MouseY, dx
    End;

  End;

  Asm
    pop      es
    pop      ds
    popa
  End;
End;
{$IFNDEF FINAL} {$S+} {$ENDIF}

Procedure Show;
Begin
  Busy:=True;
  If MouseHideCount<255 Then
  Begin
    Inc(MouseHideCount);
    If MouseHideCount=255 Then
    Begin
      GetImage(MouseX,MouseY,MouseX+MouseSizeX,MouseY+MouseSizeY,MouseBackgroundSave^);
      PutImage(MouseX,MouseY,MouseMask^,AndPut);
      PutImage(MouseX,MouseY,MousePicture^,OrPut);
    End;
  End;
  Busy:=False;
End;

Procedure Hide;
Begin
  Busy:=True;
  If MouseHideCount=255 Then
    PutImage(MouseX,MouseY,MouseBackgroundSave^,CopyPut);
  If MouseHideCount>0 Then Dec(MouseHideCount);
  Busy:=False;
End;

Procedure SetXY(X,Y:Word);
Begin
  Hide;
  Asm
    mov  ax,4
    mov  cx,X
    mov  dx,Y
    int  33h
  End;
  Show;
End;

Procedure SetBounds(X1,Y1,X2,Y2:Word);
Begin
  Hide;
  Asm
    mov  ax,7
    mov  cx,X1
    mov  dx,X2
    int  33h
    mov  ax,8
    mov  cx,Y1
    mov  dx,Y2
    int  33h
  End;
  Show;
End;

Procedure SetShape(Shape:Pointer);

Var
  P, Q      :Pointer;

Begin
  Hide;
  FreeMem(MouseBackgroundSave,ImageSize(0,0,MouseSizeX,MouseSizeY));

  If BGIMouseShapePtr(Shape)^.Picture=NIL Then
    MousePicture :=MouseDefaultPicture
  Else
    MousePicture :=BGIMouseShapePtr(Shape)^.Picture;

  If BGIMouseShapePtr(Shape)^.Mask=NIL Then
    MouseMask    :=MouseDefaultMask
  Else
    MouseMask    :=BGIMouseShapePtr(Shape)^.Mask;

  P              :=Ptr(Seg(MousePicture^),Ofs(MousePicture^)+0);
  Q              :=Ptr(Seg(MouseMask^),Ofs(MouseMask^)+0);
  MouseSizeX     :=Word(P^);
  If Word(P^)<>Word(Q^) Then Halt;
  P              :=Ptr(Seg(MousePicture^),Ofs(MousePicture^)+2);
  Q              :=Ptr(Seg(MouseMask^),Ofs(MouseMask^)+2);
  MouseSizeY     :=Word(P^);
  If Word(P^)<>Word(Q^) Then Halt;
  MouseBackgroundSize:=ImageSize(0,0,MouseSizeX,MouseSizeY);
  GetMem(MouseBackgroundSave,MouseBackgroundSize);

  Show;
End;

Begin
  ComputerSpeed :=1000;
  Active        :=False;
  Busy          :=False;
  MouseDefaultPicture :=@Icons.IconBGIMouseCursorA;
  MouseDefaultMask    :=@Icons.IconBGIMouseMaskA;
End.

{ Copyright 1993, Michael Gallias }
