unit UniDrv;
  {- Some functions which can be used in the most printer drivers ! -}

interface

uses  Objects,WinAPI,Strings,XStream,XPrinter;

const PrnPort     : PStream = nil;

var   PrnErr      : dll_PrintError;
      ResPrinter  : TResourceFile;
      Printer     : PPrinter;

procedure WritePrn(St:String);
procedure WriteSeq(P:PPrnSeq);

implementation

{- Stnd. Errorhandler : Do nothing ! }
procedure PrinterError( Error, Status : Integer ); far;
begin end;

{- This is the function which would be called on a Stream.Error ! }
procedure PortError( var S:TStream );
begin PrnErr( S.ErrorInfo, S.Status );
end;

{- Exit the DLL and close the printer-Resource }

var SavExitProc : Pointer;
procedure DllExit; far;
begin
  ExitProc := SavExitProc;
  If PrnPort <> nil then begin
     Dispose(PrnPort,Done);
     PrnPort:= nil;
  end;
  ResPrinter.Done;
end;

{- Write a String to the port }
procedure WritePrn(St:String);
begin
  If PrnPort <> nil then
     PrnPort^.Write( St[1],Length(St));
end;

{- Write a Sequenz to the port }
procedure WriteSeq(P:PPrnSeq);
begin
  If (P <> nil) and (P^.Seq <> nil) then
     WritePrn( P^.Seq^);
end;

begin
  RegisterObjects;
  RegisterXPrinter;
  RegisterXStream;
  ResPrinter.Init( New( PDosStream, Init( 'PRINTER.RES', stOpenRead )));
  SavExitProc := ExitProc;
  ExitProc    := @DllExit;
end.
