{
   This is only a simple printer DLL I've written to show how
   interfacing my printer tools with a DLL. I hope that many
   programer enhance this idea for their own application so that
   it can be a standard interface for DOS printer drivers. Instead
   of accessing the PRINTER.RES file here you can writeout the
   printer-codes directly in the code. Please send me your own
   Printer-DLL's and PRINTER.RES files I then pack it to my
   ZIP-file !

                                        - Mfg Stefc -
}


{$C FIXED PRELOAD PERMANENT } {$D-,L-}
library CanBJ20;

uses  Objects,WinAPI,XPrinter,XStream,UniDrv;

{- This function would be called to setup a new printjob }
procedure InitPrinter; export;
begin
  WriteSeq(PPrnSeq(Printer^.Others^.FindItem(xpReset)))
end;

{- This function would be called to reset the printer at
   the end of a list or form. }
procedure ResetPrinter;                                 export;
begin
  WriteSeq(PPrnSeq(Printer^.Others^.FindItem(xpReset)))
end;

{- With this Enum-Procedure the programmer can look what fonts
   supported for this printer ! }
type EnumFont = procedure( Name:String; Cpi:Real );

procedure EnumFonts(CallBack:EnumFont);                 export;
  procedure EnumFont(P:PPrnFont); far;
  begin CallBack( P^.Key^, P^.Cpi ); end;
begin
  Printer^.Fonts^.ForEach(@EnumFont);
end;

procedure FormFeed;                                     export;
begin
  WriteSeq(PPrnSeq(Printer^.Others^.FindItem(xpFormFeed)));
end;

procedure StrOut(St:String);                            export;
begin
  WritePrn(St);
end;

procedure DataOut(Data:Pointer;Count:Word);             export;
begin
  If PrnPort <> nil then
     PrnPort^.Write(Data,Count );
end;

procedure SwitchPort( P:PMemoryStream );               export;
  var ShareStream : TSharedStream;
begin
  ShareStream.Init( P );
  if PrnPort <> nil then begin
     Dispose(PrnPort,Done);
     PrnPort := nil;
  end;
  PrnPort := PStream(ShareStream.Get);
  if PrnPort = nil then
     PrnPort := PStream(New( PNulStream, Init ));
  ShareStream.Done;
end;

exports InitPrinter,ResetPrinter,EnumFonts,FormFeed,StrOut,DataOut,
        SwitchPort;
begin
  Printer := PPrinter(ResPrinter.Get( 'Canon BJ-20' ));
  if Printer = nil then
     halt(210);
end.
