
unit timer ;

{
 Title     : TIMER.PAS
 Author    : Robert Upleger
 Date      : March 24, 1991
 Intent    : Timing function performed by the IBM 8253 timer chip
}

interface

     function Current_Sec : real ;
     { returns the number of seconds since most recent midnight }


implementation

uses DOS ;

     function Current_Sec : real ;
     { returns the number of seconds since most recent midnight }
     var
          hour,                { 0 - 24 }
          min,                 { 0 - 60 }
          sec,                 { 0 - 60 }
          frac  : integer   ;  { 0 - 99 }
          regs  : registers ;
     begin
          regs.ah := $2C    ;
          msdos ( regs )    ;
          hour := regs.ch   ;
          min  := regs.cl   ;
          sec  := regs.dh   ;
          frac := regs.dl   ;
          Current_Sec := ( hour * 60 + min ) * 60 + sec + frac/100
     end ;

begin
end.

