Unit KeyNames;

{  The following are collections of Key press routines for the
   IBM PC command set.  They are arranged in two formats.

   Format 1:  Control Set Commands
              All control Set commands are the direct return from the
              Inkey (READKEY) function.

   Format 2:  Alternate Set Commands (SCANCodes)
              If Inkey returns a 0, the global variable SCANCODE, or
              the next return of Inkey will contain the Alternate code }

{***** These command set controls should work with both Units Screenio and
       CRT.  If you are using CRT, Scancode can be retrieved by another call
       to READKEY.  *****}

{*******************************************************}
{***  Keynames                                       ***}
{***  () 1989 Tone Zone Computing                    ***}
{***  Brian K. Trotter                               ***}
{***  You may freely copy these constants and        ***}
{***  distribute them to your friends provided that  ***}
{***  no fee is charged for them.  You may freely    ***}
{***  use them in all your Turbo Pascal programs     ***}
{*******************************************************}

Interface

Const
     {Alternate Format}

     F1   =  59;    {Normal Function Keys}
     F2   =  60;
     F3   =  61;
     F4   =  62;
     F5   =  63;
     F6   =  64;
     F7   =  65;
     F8   =  66;
     F9   =  67;
     F10  =  68;
     SF1  =  84;    {Shifted Function Keys}
     SF2  =  85;
     SF3  =  86;
     SF4  =  87;
     SF5  =  88;
     SF6  =  89;
     SF7  =  90;
     SF8  =  91;
     SF9  =  92;
     SF10 =  93;
     CF1  =  94;    {Control Function Keys}
     CF2  =  95;
     CF3  =  96;
     CF4  =  97;
     CF5  =  98;
     CF6  =  99;
     CF7  =  100;
     CF8  =  101;
     CF9  =  102;
     CF10 =  103;
     AF1  =  104;    {Alternate Function Keys}
     AF2  =  105;
     AF3  =  106;
     AF4  =  107;
     AF5  =  108;
     AF6  =  109;
     AF7  =  110;
     AF8  =  111;
     AF9  =  112;
     AF10 =  113;

 {Alternate Keys}
     AltA   =  30;
     AltB   =  48;
     AltC   =  46;
     AltD   =  32;
     AltE   =  18;
     AltF   =  33;
     AltG   =  34;
     AltH   =  35;
     AltI   =  23;
     AltJ   =  36;
     AltK   =  37;
     AltL   =  38;
     AltM   =  50;
     AltN   =  49;
     AltO   =  24;
     AltP   =  25;
     AltQ   =  16;
     AltR   =  19;
     AltT   =  20;
     AltU   =  22;
     AltV   =  47;
     AltW   =  17;
     AltX   =  45;
     AltY   =  21;
     AltZ   =  44;

     Alt1   =  121;
     Alt2   =  122;
     Alt3   =  123;
     Alt4   =  124;
     Alt5   =  125;
     Alt6   =  126;
     Alt7   =  127;
     Alt8   =  128;
     Alt9   =  129;
     Alt10  =  130;

{Special Keys }
     NIns   =  82;
     NDel   =  83;
     NHome  =  71;
     NPgUp  =  73;
     NPgDn  =  81;
     NEnd   =  79;
     NUp    =  72;
     NDown  =  80;
     NLeft  =  75;
     NRight =  77;

{Control Format}

     CntrlA  =  1;
     CntrlB  =  2;
     CntrlC  =  3;
     CntrlD  =  4;
     CntrlE  =  5;
     CntrlF  =  6;
     CntrlG  =  7;
     CntrlH  =  8;
     CntrlI  =  9;
     CntrlJ  =  10;
     CntrlK  =  11;
     CntrlL  =  12;
     CntrlM  =  13;
     CntrlN  =  14;
     CntrlO  =  15;
     CntrlP  =  16;
     CntrlQ  =  17;
     CntrlR  =  18;
     CntrlS  =  19;
     CntrlT  =  20;
     CntrlU  =  21;
     CntrlV  =  22;
     CntrlW  =  23;
     CntrlX  =  24;
     CntrlY  =  25;
     CntrlZ  =  26;

     NPrt    =  16;
     NBack   =  8;
     NReturn =  13;


Implementation

end.
