(*-------------------------------------------------------------------------*)
(*          SigChi -- Significance of Chi-Square distribution              *)
(*-------------------------------------------------------------------------*)

FUNCTION SigChi( Chisq , Df : REAL ) : REAL;

(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*       Function:  SigChi                                                 *)
(*                                                                         *)
(*       Purpose:   Evaluates Chi-Square distribution probability          *)
(*                                                                         *)
(*       Calling Sequence:                                                 *)
(*                                                                         *)
(*            P     := SigChi( Chisq , Df );                               *)
(*                                                                         *)
(*                 Chisq  --- Chi-square value                             *)
(*                 Df     --- Degrees of freedom                           *)
(*                                                                         *)
(*                 P      --- Resultant probability                        *)
(*                                                                         *)
(*       Calls:                                                            *)
(*                                                                         *)
(*            GammaIn                                                      *)
(*                                                                         *)
(*       Method:                                                           *)
(*                                                                         *)
(*            The input values are transformed to match the                *)
(*            requirements of the Gamma distribution.  Function GammaIn    *)
(*            provides the corresponding cumulative incomplete gamma       *)
(*            probability.                                                 *)
(*                                                                         *)
(*            An error in the input arguments results in a returned        *)
(*            probability of -1.                                           *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

CONST
   MaxIter = 200;
   Dprec   = 12;

VAR
   Ierr:  INTEGER;
   Iter:  INTEGER;
   Cprec: REAL;

BEGIN (* SigChi *)

   SigChi := 1.0 - GammaIn( Chisq / 2.0, Df / 2.0, Dprec, MaxIter,
                            Cprec, Iter, Ierr );

   IF ( Ierr <> 0 ) THEN SigChi := -1.0;

END   (* SigChi *);
