UNIT GlobScrn;

INTERFACE

USES
   Dos, Crt;

(*----------------------------------------------------------------------*)
(*          Definitions for screen memory reading/writing               *)
(*----------------------------------------------------------------------*)

CONST
   EGA_Screen_Address      = $A000    (* Address of EGA color screen      *);
   Color_Screen_Address    = $B800    (* Address of color screen          *);
   Mono_Screen_Address     = $B000    (* Address of mono screen           *);
   Screen_Length           = 4000     (* 80 x 25 x 2 = screen area length *);
   Graphics_Screen_Length  = 16000    (* Length of graphics screen area   *);
   EGA_Graphics_Scr_Length = 32000    (* Length of EGA graphics screen    *);
   Max_Saved_Screen        = 6        (* Maximum no. of saved screens     *);
   MedRes_GraphMode        = 4        (* Medium resolution graphics       *);
   HiRes_GraphMode         = 6        (* High resolution graphics mode    *);
   Mono_TextMode           = 7        (* Monochrome adapter text mode     *);
   EGA_GraphMode           = 16       (* EGA adapter graphics mode        *);
   CRT_Index               = $03D4    (* CRT index register               *);
   CRT_Data                = $03D5    (* CRT data register                *);
   CRT_Mode                = $03D8    (* CRT mode register                *);
   CRT_Color_Select        = $03D9    (* CRT color select register        *);
   CRT_Status              = $03DA    (* CRT status port                  *);
   CRT_Mode_Byte           = $0465    (* CRT mode byte                    *);

TYPE
                                     (* A screen image            *)

   Screen_Type       = ARRAY[ 1 .. EGA_Graphics_Scr_Length ] OF BYTE;

   Screen_Ptr        = ^Screen_Type;

VAR
   Write_Screen_Memory : BOOLEAN   (* TRUE to allow direct screen writes *);
   Wait_For_Retrace    : BOOLEAN   (* TRUE to wait for retrace signals   *);

CONST                              (* Default maximum screen width       *)
   Max_Screen_Col      : INTEGER = 80;

IMPLEMENTATION

END   (* GlobScrn *).

