(*$R-,V-,B-,S-,I-*)
PROGRAM TryMDos;

(*----------------------------------------------------------------------*)
(*               TryMDos --- Try multitaskers for DOS                   *)
(*----------------------------------------------------------------------*)
(*                                                                      *)
(*  Author:   Philip R. Burns                                           *)
(*                                                                      *)
(*  Version:  1.2   June, 1988.                                         *)
(*                                                                      *)
(*  Overview: This program demonstrates the routines contained in the   *)
(*            file PIBMDOS.PAS, which provide Turbo Pascal interfaces   *)
(*            to several popular multitasking programs for DOS:         *)
(*                                                                      *)
(*               - DesqView from QuarterDeck                            *)
(*               - TaskView and OmniView from Sunny Hill Software       *)
(*               - TopView from IBM                                     *)
(*               - DoubleDos from SoftLogic                             *)
(*                                                                      *)
(*            Because MicroSoft Windows will emulate TopView, these     *)
(*            routines are also useful for Windows.                     *)
(*                                                                      *)
(*  Remarks:  This sample program simply writes lines of text to the    *)
(*            screen until a key is depressed.  Then, it loops waiting  *)
(*            for input to show the difference between giving up and    *)
(*            not giving up unused time to other partitions.            *)
(*                                                                      *)
(*            Note that the file WRITESXY.PAS contains a general        *)
(*            purpose routine to write a string is included.  The       *)
(*            string is written directly to screen memory if no         *)
(*            multitasker is active, or to the virtual buffer if a      *)
(*            multitasker is active.  It can also write the string      *)
(*            using standard BIOS calls if desired.                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

USES
   DOS, CRT, GLOBSCRN, PIBMTASK;

TYPE
   AnyStr   = STRING[255];

(*$I READKBD.PAS  *)
(*$I YESNO.PAS    *)
(*$I GETSCREN.PAS *)
(*$I WRITESXY.PAS *)

VAR
   LineCount : LONGINT;
   Ch        : CHAR;
   S         : STRING[8];
   Y         : INTEGER;

(*----------------------------------------------------------------------*)
(*      Flush_Keyboard --- Flush pending keystrokes in keyboard         *)
(*----------------------------------------------------------------------*)

PROCEDURE Flush_Keyboard;

VAR
   Ch: CHAR;

BEGIN (* Flush_Keyboard    *)

   WHILE( KeyPressed ) DO
      Ch := ReadKey;

END   (* Flush_Keyboard    *);

(*----------------------------------------------------------------------*)
(*      Initialize --- Initialize multitasker demonstration             *)
(*----------------------------------------------------------------------*)

PROCEDURE Initialize;

BEGIN (* Initialize *)
                                   (* Allow direct memory writes  *)
   Write_Screen_Memory := TRUE;
                                   (* Don't wait for retrace      *)
   Wait_For_Retrace    := FALSE;
                                   (* Don't let Turbo do screen writes *)
   DirectVideo         := FALSE;
                                   (* See which multitasker active *)

   TimeSharingActive := IsTimeSharingActive;

                                   (* Clear screen *)
   ClrScr;
                                   (* Indicate which multitasker active  *)
   CASE MultiTasker OF
                                   (* No multitasker -- ask if we should *)
                                   (* wait for retraces in direct screen *)
                                   (* writes, or use BIOS.               *)
      MultiTasker_None : BEGIN
                            WRITELN('No multitasker active.');
                            Wait_For_Retrace    := YesNo('Wait for retrace in direct screen writes?');
                            Write_Screen_Memory := NOT YesNo('Use BIOS instead of direct screen writes?');
                            WRITELN;
                         END;
      TopView          : WRITELN('TopView active.');
      DesqView         : WRITELN('DesqView active.');
      TaskView         : WRITELN('TaskView/OmniView active.');
      DoubleDos        : WRITELN('DoubleDos active.');
      ELSE;
   END (* CASE *);

END   (* Initialize *);

(*----------------------------------------------------------------------*)
(*      Try_Screen_Writes --- Try writing strings to screen memory      *)
(*----------------------------------------------------------------------*)

PROCEDURE Try_Screen_Writes;

BEGIN (* Try_Screen_Writes *)
                                   (* Write lines to screen until a key *)
                                   (* is hit.                           *)

   WRITELN('First test is writing text to virtual buffer.');
   WRITELN('A continuous series of lines will be written until');
   WRITELN('a key is pressed.  You can switch to another partition');
   WRITELN('and see that no bleed though occurs.');
   WRITE  ('Hit a key to start test: ');

   Read_Kbd( Ch );

   Flush_Keyboard;

   LineCount := 0;
   Y         := WhereY;

   WHILE( NOT KeyPressed ) DO
      BEGIN
         INC( LineCount );
         STR( LineCount:8 , S );
         WriteSXY( 'Line ' + S + ' is now being displayed on the screen.', 1, Y, White );
         INC( Y );
         IF ( Y > 25 ) THEN
            Y := 1;
      END;
                                   (* Flush keyboard buffer *)
   Flush_Keyboard;

END   (* Try_Screen_Writes *);

(*----------------------------------------------------------------------*)
(*      Try_GiveAway --- Try giving up time to other partitions         *)
(*----------------------------------------------------------------------*)

PROCEDURE Try_GiveAway;

BEGIN (* Try_GiveAway *)

   ClrScr;

   WRITELN('Test of busy program in this partition.');
   WRITELN('This program will loop here waiting until a key is struck.');
   WRITELN('Time is NOT donated to the other partitions.');
   WRITELN('After this starts, switch to another partition and use a program');
   WRITELN('like CPU.COM to see the effective CPU speed for that partition.');

   WRITE  ('Hit a key to stop test: ');

   WHILE( NOT KeyPressed ) DO;

   Flush_Keyboard;

   WRITE('Key pressed, test ends.');
   WRITELN;
   WRITELN;

   WRITELN('Test of busy program in this partition, but now');
   WRITELN('time IS donated to the other partitions.');
   WRITELN('This program will loop here waiting until a key is struck.');
   WRITELN('After this starts, switch to another partition and use a program');
   WRITELN('like CPU.COM to see the effective CPU speed for that partition.');
   WRITELN('You should see a notable increase in the effective CPU speed');
   WRITELN('over the last test.');
   WRITELN;
   WRITE  ('Hit a key to stop test: ');

   WHILE( NOT KeyPressed ) DO
      GiveUpTime( 2 );

   Flush_Keyboard;

   WRITE('Key pressed, test ends.');

END   (* Try_GiveAway *);

(*----------------------------------------------------------------------*)

BEGIN (* TryMDos *)
                                   (* Initialize *)
   Initialize;
                                   (* Try writing to virtual buffer *)
   Try_Screen_Writes;
                                   (* Try giving up idle time while *)
                                   (* waiting for keyboard input    *)
   IF TimeSharingActive THEN
      Try_GiveAway
   ELSE
      BEGIN
         ClrScr;
         WRITELN('Test of giving up time not performed since');
         WRITELN('multitasker not active.');
      END;

   WRITELN;
   WRITELN;
   WRITELN('End of multitasker demonstration.');

END   (* TryMDos *).
