UNIT PibTimer;

INTERFACE

USES   
   Dos, GlobType;

FUNCTION TimeOfDay : LONGINT;
FUNCTION TimeDiff( Timer1, Timer2: LONGINT ) : LONGINT;

IMPLEMENTATION

(*--------------------------------------------------------------------------*)
(*                TimeOfDay  --- Get time of day                            *)
(*--------------------------------------------------------------------------*)

FUNCTION TimeOfDay : LONGINT;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Function:  TimeOfDay                                                 *)
(*                                                                          *)
(*     Purpose:   Gets time of day from internal clock                      *)
(*                                                                          *)
(*     Calling sequence:                                                    *)
(*                                                                          *)
(*        Tod := TimeOfDay : LONGINT;                                       *)
(*                                                                          *)
(*           Tod --- Long integer number which is timer value expressed in  *)
(*                   seconds as:                                            *)
(*                   ( 3600 x hour + 60 x minutes + seconds )               *)
(*                                                                          *)
(*     Calls:  GetTime                                                      *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Hours   : WORD;
   Minutes : WORD;
   Seconds : WORD;
   SecHun  : WORD;
    
BEGIN (* TimeOfDay *)

   GetTime( Hours, Minutes, Seconds, SecHun );
   
   TimeOfDay  := Hours * 3600 + Minutes * 60 + Seconds;

END   (* TimeOfDay *);

(*--------------------------------------------------------------------------*)
(*        TimeDiff  --- Get difference in time between two timer values     *)
(*--------------------------------------------------------------------------*)

FUNCTION TimeDiff( Timer1, Timer2: LONGINT ) : LONGINT; 

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Function:  TimeDiff                                                  *)
(*                                                                          *)
(*     Purpose:   Get difference in time between two timer values in        *)
(*                seconds.                                                  *)
(*                                                                          *)
(*     Calling sequence:                                                    *)
(*                                                                          *)
(*        TDiff := TimeDiff( Timer1, Timer2: LONGINT ) : LONGINT;           *)
(*                                                                          *)
(*           Timer1  --- first timer value (earlier)                        *)
(*           Timer2  --- second timer value (later)                         *)
(*                                                                          *)
(*           TDiff   --- difference between timer values                    *)
(*                                                                          *)
(*     Calls:  None                                                         *)
(*                                                                          *)
(*     Remarks:                                                             *)
(*                                                                          *)
(*        This routine will handle time wrap around midnight.  However, it  *)
(*        only handles timer values <= 24 hours in duration.                *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

CONST
   Secs_Per_Day = 86400    (* Seconds in one day *);

VAR
   TDiff : LONGINT;

BEGIN (* TimeDiff *)

   TDiff := Timer2 - Timer1;

   IF ( TDiff < 0 ) THEN 
      TDiff := TDiff + Secs_Per_Day;

   TimeDiff := TDiff;

END   (* TimeDiff *);

END (* PibTimer *).
