         MOV     BX,[>Async_OBuffer_Head]   ;Get output queue head pointer
         LES     DI,[>Async_OBuffer_Ptr]    ;Pick up output buffer address
         ADD     DI,BX                      ;Position to current character
;
         MOV     DX,BX                      ;Save previous head pointer
         INC     BX                         ;Increment head pointer
         CMP     BX,[>Async_OBuffer_Size]   ;See if past end of buffer
         JLE     Send1                      ;Skip if not
         XOR     BX,BX                      ;Wrap to start of buffer
;
Send1:   CMP     BX,[>Async_OBuffer_Tail]   ;See if head collided with tail
         JNE     Send4                      ;No -- buffer didn't fill up
;
         MOV     CX,[>Async_Output_Delay]   ;Run delay loop and see if buffer drains
;
Send2:   PUSH    CX                         ;Save milleseconds to go
         MOV     CX,[>Async_OneMSDelay]     ;Get delay loop value for 1 ms
;
Send3:   LOOP    Send3                      ;Tight loop for 1 ms delay
;
         POP     CX                         ;Get back millesecond count
;
         CMP     BX,[>Async_OBuffer_Tail]   ;See if buffer drained yet
         JNE     Send4                      ;Yes -- OK, stop delay loop.
;
         LOOP    Send2                      ;Decrement millesecond count and loop
;
         MOV     BYTE [>Async_OBuffer_Overflow],1 ;Indicate output buffer overflow
         JMP     Send5                      ;Skip updating head pointers
;
Send4:   MOV     [>Async_OBuffer_Head],BX   ;Save updated head pointer
         MOV     AL,[BP+<C]                 ;Pick up character to send
     ES: MOV     [DI],AL                    ;Place character in output buffer
;
         MOV     AX,[>Async_OBuffer_Used]   ;Get buffer use count
         INC     AX                         ;Increment buffer use count
         MOV     [>Async_OBuffer_Used],AX   ;Save new count
         CMP     AX,[>Async_MaxOBufferUsed] ;See if larger than ever before
         JLE     Send5                      ;Skip if not
         MOV     [>Async_MaxOBufferUsed],AX ;Save new maximum usage
;
Send5:   MOV     DX,[>Async_Uart_IER]       ;Get interrupt enable register
         IN      AL,DX                      ;Check contents of IER
         TEST    AL,2                       ;See if write interrupt enabled
         JNZ     Send6                      ;Skip if so
         OR      AL,2                       ;Else enable write interrupts ...
         OUT     DX,AL                      ;... by rewriting IER contents
;
Send6:
