;
;  Check if any characters in input comm buffer
;
         MOV   AX,[>Async_Buffer_Tail]
         CMP   AX,[>Async_Buffer_Head]
         JNE   Rec1
;
;  Buffer is empty -- return NUL character
;
         LES   DI,[BP+<C]                   ;Get character address
         XOR   AX,AX                        ;Clear out unused bits
     ES: MOV   [DI],AL                      ;NUL character
         JMP   Return
;
;  Buffer not empty -- pick up next character.
;
Rec1:    LES   DI,[>Async_Buffer_Ptr]       ;Pick up buffer address
         ADD   DI,AX                        ;Add character offset
     ES: MOV   BL,[DI]                      ;Get character from buffer
         LES   DI,[BP+<C]                   ;Get result address
     ES: MOV   [DI],BL                      ;Store character from buffer
         INC   AX                           ;Increment tail pointer
         CMP   AX,[>Async_Buffer_Size]      ;Past end of buffer?
         JLE   Rec2                         ;No -- skip wrapping
         XOR   AX,AX                        ;Yes -- point to start of buffer
Rec2:    MOV   [>Async_Buffer_Tail],AX      ;Update tail pointer
         DEC   Word [>Async_Buffer_Used]    ;Update buffer use count
;
; If XOFF previously sent because buffer was too full, and
; now buffer is reasonably empty, send XON to get things rolling again.
;
         TEST  BYTE [<Async_XOff_Sent],1    ;Check if Xoff sent
         JZ    Rec3                         ;No -- skip.
;
         MOV   AX,[>Async_Buffer_Used]      ;Pick up amount of buffer used
         CMP   AX,[>Async_Buffer_Low]       ;Check if low enough
         JG    Rec3                         ;Still too full, skip
;
         MOV   AX,>XON                      ;Else push XON onto stack
         PUSH  AX
         CALL  FAR [>Async_Send_Addr]       ;Call output routine
;
         MOV   BYTE [>Async_XOff_Sent],0    ;Clear Xoff flag
;
;  Indicate character found
;
Rec3:    MOV    AX,1
;
Return:  AND    Byte [>Async_Line_Status],$FD ;Remove overflow flag
         OR     AX,AX                       ;Set zero flag to indicate return status
         MOV    SP,BP
         POP    BP
         RETF   4
