program phone;

uses WinCrt2;

{$R PHONE.RES}

type
  tprecd = record
    last : string[20];
    first: string[15];
    phone: string[12];
  end;

  sort_ary = array[1..100] of tprecd;

var
  buff             : tprecd;
  fname1, fname2   : string[14];
  in_file, out_file: text;
  reply, len       : integer;
  srt_elmt         : sort_ary;
  newfile, change  : boolean;

procedure skip(lines: integer);
var
  i: integer;
begin
  for i := 1 to lines do
    WriteLn;
end;

procedure open_read ;
var
  reply: char;
begin
  assign(in_file,fname1);
  reset(in_file);
  if IORESULT = 255 then
  begin
    WriteLn('Can''t open ', fname1);
    skip(2);
    repeat
      Write('Open a new file? ');
      readln(reply);
    until reply in['y', 'n', 'Y', 'N'];
    if reply in['y', 'Y'] then
    begin
      assign(out_file, fname1);
      reWrite(out_file);
      if IORESULT = 255 then
      begin
        Write('Can''t open ', fname1);
        exit;
      end
      else
      begin
        newfile:= true;
        change:= true;
        len:=0;
      end;
    end;
  end;
end;

procedure rd_to_aray;
label 1;
var
i: integer;
begin
  for i:= 1 to maxint do
  begin
    if eof(in_file) then
    begin
      len := i - 1;
      WriteLn (len:3,' records');
      exit;
    end;
    readln(in_file, srt_elmt[i].last);
    if pos('', srt_elmt[i].last) = 1 then
    begin
      i := pred(i);
      goto 1;
    end;
    readln(in_file, srt_elmt[i].first);
    readln(in_file, srt_elmt[i].phone);
    1:
  end;
end;

procedure sort;
var
  i, j, k, gap: integer;
  temp        : tprecd;
begin
  gap := len div 2;
  while gap > 0 do
  begin
    for i := gap + 1 to len do
    begin
      j := i - gap;
      while j > 0 do
      begin
        k := j + gap;
        if srt_elmt[j].last <= srt_elmt[k].last then
          j := 0
        else
        begin
          temp := srt_elmt[j];
          srt_elmt[j] := srt_elmt[k];
          srt_elmt[k] := temp;
        end;
      j := j - gap;
      end;
    end;
    gap := gap div 2
  end;
end;

procedure searchn;
var
  ser   : integer;
  target: string[20];
function search: integer;
var
  low, high, mid: integer;
begin
  low := 1;
  high := len;
  while low <= high do
  begin
    mid := (low + high) div 2;
    if target < srt_elmt[mid].last then
      high := mid - 1;
    if target > srt_elmt[mid].last then
      low := mid + 1;
    if target = srt_elmt[mid].last then
    begin
      search := mid;
      exit;
    end;
  end;
  search := -1;
end;
begin
  ClrScr;
  skip(3);
  WriteLn('          Number Search');
  skip(3);
  WriteLn('Enter 0 to name to exit');
  skip(1);
  repeat
    skip(1);
    Write('Enter the last name to be searched: ');
    readln(target);
    skip(1);
    if target = '0' then
      exit;
    ser := search;
    if ser = -1 then
      WriteLn('Record not found')
    else
    begin
      WriteLn(ser: 3, ' / ', srt_elmt[ser].first: 17,
        srt_elmt[ser].last: 22, srt_elmt[ser].phone: 16);
    end;
  until FALSE;
end;   
      
procedure list_aray;
var
  i    : integer;
  dummy: string;
begin
  ClrScr;
  skip(2);
  for i := 1 to len do
  begin
    WriteLn(i: 3, ' / ', srt_elmt[i].first: 17,
      srt_elmt[i].last: 22, srt_elmt[i].phone: 16);
    if (i mod 18) = 0 then
    begin
      WriteLn;
      Write('ENTER to continue: ');
      readln(dummy);
    end;
  end;
  WriteLn;
  Write('ENTER to continue: ');
  readln(dummy);
end;

procedure openw;
begin
  assign(out_file, fname2);
  reWrite(out_file);
  if IORESULT = 255 then
    WriteLn('Can''t open ', fname2)
  else
    WriteLn('Opened output file ', fname2);
end;

procedure add_name;
var
  i: integer;
  s: string;
begin
  change := TRUE;
  ClrScr;
  skip(4);
  WriteLn('        Add Records');
  skip(2);
  WriteLn('ENTER 0 to name to exit');
  for i := len + 1 to MAXINT do
  begin
    WriteLn;
    WriteLn('Record NO: ', i);
    Write('  Last name: ');
    readln(s);
    if s = '0' then
    begin
      len := i - 1;
      exit;
    end;
    srt_elmt[i].last := s;
    Write('  First name: ');
    readln(s);
    srt_elmt[i].first := s;
    Write('Phone number: ');
    readln(s);
    srt_elmt[i].phone := s;
  end;
end;

procedure delete;
var
  rn, i: integer;
  retry: boolean;
begin
  change := TRUE;
  ClrScr;
  skip(3);
  WriteLn('          Record Deletion');
  skip(2);
  WriteLn('Input 0 as record number to exit');
  skip(2);
  repeat
    skip(2);
    repeat
      retry := TRUE;
      Write('Record number to be deleted: ');
      readln(rn);
      if rn = 0 then
        exit;
      if rn > len then
      begin
        WriteLn('Record out of range');
        retry := FALSE;
      end;
    until retry;
    srt_elmt[rn].last := '                    ';
  until FALSE;
end;

procedure clse;
var
  result, i: integer;
procedure save;
label 1;
var
  i: integer;
begin
  skip(4);
  for i := 1 to len do
  begin
    if pos(' ', srt_elmt[i].last) = 1 then
      goto 1;
    WriteLn(out_file, srt_elmt[i].last);
    WriteLn(out_file, srt_elmt[i].first);
    WriteLn(out_file, srt_elmt[i].phone);
    1:
  end;
  WriteLn('Saved ', i, ' records');
end;
begin
  ClrScr;
  skip(4);
  WriteLn('        File Close and Save');
  skip(2);
  if not(newfile) then
    close(in_file);
  if newfile then
  begin
    save;
    close(out_file);
    exit;
  end;
  Write('Name of output file: ');
  readln(fname2);
  assign(out_file, fname2);
  reWrite(out_file);
  if IORESULT = 255 then
  begin
    WriteLn('Can''t close ', fname2);
    exit;
  end;
  if change then
    save;
  close(out_file);
end;

begin
  len := 0;
  change := FALSE;
  newfile := FALSE;
  ClrScr;
  skip(3);
  WriteLn('               Computer Phone Book');
  WriteLn('               -------------------');
  skip(2);
  Write('Phone book source file name: ');
  readln(fname1);
  open_read;
  rd_to_aray;
  ClrScr;
  repeat
    ClrScr;
    skip(4);
    WriteLn('        MENU');
    skip(2);
    WriteLn('1     Read Phone List');
    WriteLn;
    WriteLn('2     Add Name(s)');
    WriteLn;
    WriteLn('3     Delete name(s)');
    WriteLn;
    WriteLn('4     Search for Number');
    WriteLn;
    WriteLn('5     Close Files and Exit to Windows');
    skip(1);
    repeat
      WriteLn;
      Write('Input choice: ');
      readln(reply);
    until reply in[1..6];
    case reply of
      1: begin
           sort;
           list_aray;
         end;
      2: begin
           add_name;
           sort;
         end;
      3: delete;
      4: searchn;
      5: begin
           clse;
           donewincrt;
           exit;
         end;
    end;
  until FALSE;
end.