program SHOW256;

(* Sample implementation of PCX256.TPU. Enter a filename (without extension)
   on the command line or, if running under Turbo, in the Parameters box.

   Since the BGI doesn't seem to support the 256-color mode, we go it
   alone with BIOS calls. *)

uses DOS, CRT, PCX256;

var   regs: registers;
      blackpal: array[0..255] of RGBrec;

procedure SETMODE(mode: byte);

begin
regs.ah:= 0;                 { BIOS set mode function }
regs.al:= mode;              { Display mode }
intr($10, regs);             { Call BIOS }
end;

procedure SETREGISTERS(var palrec);

begin
regs.ah:= $10;               { BIOS color register function }
regs.al:= $12;               { Subfunction }
regs.es:= seg(palrec);       { Address of palette info. }
regs.dx:= ofs(palrec);
regs.bx:= 0;                 { First register to change }
regs.cx:= $FF;               { Number of registers to change }
intr($10, regs);             { Call BIOS }
end;

(* -------------------------- SHOW256 --------------------------------- *)

begin
pcxfilename:= paramstr(1) + '.PCX';
setmode($13);                            { Set 320 x 200 x 256 mode }
fillchar(blackpal, 768, 0);              { Set all color registers to black }
setregisters(blackpal);
read_pcx256(pcxfilename);                { Put image into display memory }
if file_error then
begin
  setmode(3);
  writeln('Can''t read that file.');
  halt;
end;
setregisters(RGBpal);                    { Show true colors }
repeat until readkey <> #1;
setmode(3);                              { Restore text mode }
end.
