;==============================
;Linkable module for PCX256.PAS
;==============================

data    segment word

        extrn   datalength: word
        extrn   scratch: dword
        extrn   page_addr: word
        extrn   repeatcount: byte
        extrn   video_index: word

data    ends

code segment word public
assume cs:code, ds:data

public  decode_pcx256

;=========================================================================

DECODE_PCX256    PROC    NEAR

                mov     ax, page_addr               ;start of video buffer
                mov     es, ax                      ;put in es for addressing
                mov     bl, repeatcount             ;count in bl
                mov     si, word ptr 0              ;index into scratch
                mov     di, video_index             ;index into video
                xor     ch, ch                      ;clean up loop counter
                cld                                 ;clear DF
;-------------------------------------------------------------------------
;Read buffer and decode data

;Here's how the data compression system works. Each byte is either image
;data or a count byte that tells how often the next image byte is repeated.
;The byte is image data if it follows a count byte, or if either of the top
;two bits is clear. Otherwise it is a count byte, with the count derived
;from the lower 6 bits.

getbyte:        cmp     si, datalength              ;end of scratch buffer?
                je      exit                        ;yes, quit
                push    es                          ;save video address
                push    di                          ;save video index
                les     di, scratch                 ;put pointer in es:di
                add     di, si                      ;add offset
                mov     al, [es:di]                 ;get byte from scratch
                inc     si                          ;increment index
                pop     di                          ;restore video index
                pop     es                          ;restore video address
                cmp     bl, 0                       ;was prev. byte a count?
                jg      repeats                     ;yes, this is data
                mov     ah, al                      ;no, copy byte to ah
                and     ah, 192                     ; and test high bytes
                cmp     ah, 192
                jne     is_data                     ;not set, not a count
;--------------------------------------------------------------------------
;It's a count byte
                xor     al, 192                     ;get count from 6 low bits
                mov     bl, al                      ;store repeat count
                jmp short  getbyte                  ;go get data byte
;----------------------------------------------------------------------------
;It's a single data byte
is_data:        stosb                               ;byte into video
                jmp     getbyte
;---------------------------------------------------------------------------
;It's data to be written "count" times
repeats:        mov     cl, bl                      ;set counter
                rep     stosb                       ;write byte cx times
                mov     bl, 0                       ;clear count byte
                jmp     getbyte
;-------------------------------------------------------------------------
exit:           mov     video_index, di             ;save status for next
                mov     repeatcount, bl             ;  run thru buffer
                ret

DECODE_PCX256   endp

;=========================================================================
code ends
end

