program ShowPCX;

(* Sample implementation of PCX.TPU. Enter a filename (extension optional)
   on the command line or, if running under Turbo, in the Parameters box. *)

{$X+}

uses DOS, CRT, PCX;

VAR
         Dir: DirStr;
         Name: NameStr;
         Ext: ExtStr;
         TheMode: word;
         Hour, Min, Sec, Sec100: word;
         Elapsed: word;

procedure Error(err: string);

begin
writeln;
writeln(err);
writeln;
writeln('Press any key.');
ReadKey;
end;

BEGIN
TheMode:= $0;
PCXFileName:= paramstr(1);
if PCXFileName = '' then
begin
  error('Enter the filename on the command line.');
  halt;
end;
FSplit(PCXFileName, Dir, Name, Ext);
if Ext = '' then PCXFileName:= PCXFileName + '.PCX';
if not WeSupport(TheMode) and (TheMode <> AutoSet) then
begin
  error('The requested video mode is not supported by this program.');
  halt;
end;
if (TheMode >= $100) then
begin
  if not DetectVESA then
  begin
    writeln;
    write('VESA BIOS extensions not found. Your video card may require');
    write('a program (typically called VESA.COM) to be loaded so that');
    write('SuperVGA images can be displayed without a special driver.');
    writeln;
    halt;
  end;
  if not HardwareSupports(TheMode) then
  begin
    error('Your card or VESA BIOS does not support the requested video mode.');
    halt;
  end;
end;
ReadIt(PCXFileName, TheMode);
if FileError <> 0 then
begin
  ReportError(FileError);
  SetMode(3, Wipe);
  Error(ErrorStr);
  halt;
end
else ReadKey;
SetMode(3, Wipe);                              { Restore text mode }
END.
