program HOEDOWN;

(*
   Demonstration of animation against a backdrop. See CLIP.DOC.

   Before compiling this program, set the "pathtodrivers" constant to the
   directory where your .BGI files reside.
*)

uses GRAPH, CRT;

const  pathtodrivers = 'C:\TP\BGI';
       datafile = 'HOEDOWN.DTA';
       step = 10;                { Governs lateral motion of figure }
       ypos = 100;               { Top line of images }

type   imagetype = record
          width, height, size, xpos: integer;
          image, backdrop: pointer;
       end;

var   grdriver, grmode, grerror: integer;
      pal: palettetype;
      icon_file: file;
      x, page: integer;
      Clem: array[0..1] of imagetype;
      bales: imagetype;
      junk: char;

(* ----------------------------------------------------------------------- *)

procedure GET_ICON(var pic: imagetype);

begin
with pic do
begin
  blockread(icon_file, width, 2);              { Dimensions first }
  blockread(icon_file, height, 2);
  size:= imagesize(0, 0, width, height);
  getmem(image, size);                        { Allocate dynamic memory }
  getmem(backdrop, size);
  seek(icon_file, filepos(icon_file) - 4);
  blockread(icon_file, image^, size);          { Store the image }
end;
end;

(* ----------------------------------------------------------------------- *)

BEGIN

(* Open data file and quit if not found. The file consists of the palette
   record followed by three images - two of the dancing man and one of
   the bales that form the backdrop. *)

assign(icon_file, datafile);
{$I-} reset(icon_file, 1);  {$I+}
if IOresult <> 0 then
begin
  writeln('File ',datafile,' not found.');
  halt;
end;

(* Initialize graphics *)

grmode:= egahi; grdriver:= ega;
initgraph(grdriver, grmode, pathtodrivers);
grerror:= graphresult;
if grerror <> 0 then
begin
  writeln('Graphics error: ',grapherrormsg(grerror));
  halt;
end;

(* Read the palette from file and set the colors *)

blockread(icon_file, pal, 17);
setallpalette(pal);

(* Initialize the position of the images *)

Clem[1].xpos:= 590; Clem[0].xpos:= Clem[1].xpos - step div 2;

(* Get the images into memory *)

for x:= 0 to 1 do get_icon(Clem[x]);
get_icon(bales);
close(icon_file);

(* Draw the scenic backdrop on both video pages, and store the part
   that will be written to the screen when the loop is entered *)

for page:= 0 to 1 do
with bales do
begin
  xpos:= 20;
  setactivepage(page);
  setvisualpage(page xor 1);
  repeat
    putimage(xpos, ypos, image^, copyput);
    inc(xpos, width);
  until xpos > getmaxx;
  with Clem[page] do
    getimage(xpos, ypos, xpos+width, ypos+height, backdrop^);
end;

(* Now flip between the two video pages. While one page is being viewed,
   update the other. First copy the stored backdrop over the dancing
   figure, then increment his position, then store the backdrop at
   his new position, and finally redraw him. *)

page:= 1;
repeat
  with Clem[page] do
  begin
    setactivepage(page);
    setvisualpage(page xor 1);
    putimage(xpos, ypos, backdrop^, copyput);
    dec(xpos, step);
    if xpos < 0 then xpos:= 590;
    getimage(xpos, ypos, xpos+width, ypos+height, backdrop^);
    putimage(xpos, ypos, image^, orput);
    delay(200);
    page:= page xor 1;
  end;
until keypressed;
junk:= readkey;     { Discard keypress }
closegraph;
END.
