/*
   HOEDOWN.C by Peter Donnelly

   Demonstration of animation against a backdrop. See CLIP.DOC.

   Before compiling and running the program, set the PATHTODRIVER constant 
   to the directory where your .BGI files reside.
 */

#include <stdio.h>
#include <graphics.h>
#include <conio.h>

#define PATHTODRIVER "C:\\TC\\BGI"
#define DATAFILE "HOEDOWN.DTA"
#define STEP 10                     /* Governs lateral motion of figure */
#define YPOS 100                    /* Top line of images */

typedef struct {
	  int            width, height, size, xpos;
	  unsigned char  *image, *backdrop;
	  } IMAGETYPE;


FILE                *icon_file;
int                 grdriver = EGA, grmode = EGAHI, grerror;
struct palettetype  pal;
int                 x, page;
IMAGETYPE           Clem[2], bales;
char                junk;

/* ---------------- Function to read an image from file ------------- */

void get_icon(IMAGETYPE *pic)
  {
  int size;

  fread(&(pic->width), 2, 1, icon_file);          /* Get dimensions first */
  fread(&(pic->height), 2, 1, icon_file);
  size = imagesize(0, 0, pic->width, pic->height);
  pic->image = (unsigned char*) malloc(size);     /* Allocate dynamic memory */
  pic->backdrop = (unsigned char*) malloc(size);
  fseek(icon_file, -4, SEEK_CUR);                 /* Back up in the file */
  fread(pic->image, size, 1, icon_file);          /* Store the image */
  }

/* ----------------------------------------------------------------------- */

void main()  {

/* Open data file and quit if not found. The file consists of the palette
   record followed by three images. */

if ((icon_file = fopen(DATAFILE, "rb")) == NULL) {
  printf("File %s not found.\n",DATAFILE);
  exit(1);
  }

/* Initialize graphics */

initgraph(&grdriver, &grmode, PATHTODRIVER);
grerror = graphresult();
if (grerror) {
  printf("Graphics error: %s\n",grapherrormsg(grerror));
  exit(1);
  }

/* Read the palette from file and set the colors */

fread(&pal, sizeof(pal), 1, icon_file);
setallpalette(&pal);

/* Initialize the position of the images */

Clem[1].xpos = 590;
Clem[0].xpos = Clem[1].xpos - STEP / 2;

/* Get the images into memory */

for (x = 0; x < 2; x++) get_icon(&Clem[x]);
get_icon(&bales);
fclose(icon_file);

/* Draw the scenic backdrop on both video pages, and store the part
   that will be written to the screen when the loop is entered */

for (page = 0; page < 2; page++) {
  bales.xpos = 20;
  setactivepage(page);
  setvisualpage(page ^ 1);
  do {
    putimage(bales.xpos, YPOS, bales.image, COPY_PUT);
    bales.xpos += bales.width;
    } while (bales.xpos < getmaxx());
  getimage(Clem[page].xpos, YPOS, Clem[page].xpos+Clem[page].width,
	   YPOS+Clem[page].height, Clem[page].backdrop);
  }

/* Now flip between the two video pages. While one page is being viewed,
   update the other. First copy the stored backdrop over the dancing
   figure, then increment his position, then store the backdrop at
   his new position, and finally redraw him. */

page = 1;
while (!kbhit()) {
  setactivepage(page);
  setvisualpage(page ^ 1);
  putimage(Clem[page].xpos, YPOS, Clem[page].backdrop, COPY_PUT);
  Clem[page].xpos -= STEP;
  if (Clem[page].xpos < 0) Clem[page].xpos = 590;
  getimage(Clem[page].xpos, YPOS,
	   Clem[page].xpos + Clem[page].width, YPOS + Clem[page].height,
	   Clem[page].backdrop);
  putimage(Clem[page].xpos, YPOS, Clem[page].image, OR_PUT);
  delay(200);
  page^= 1;
  }
junk = getch();                        /* Discard keypress */
closegraph();
}
