program LGEXAMP;

{ Copyright 1992 by Bob Hayes }
{ Please use this source code in your programs as you see fit. }
{ This file can be distributed "as is" only with PCX2TPI. }

uses DOS, CRT, GRAPH, LGUNIT;

var
   g1, g2 :pointer;  { pointers to the graphic objects }
   sysgraphadapter, sysgraphmode : integer;   { used by DetectGraph() }
   graphdriver, graphmode : integer;          { used by InitGraph() }
   X,Y,I : integer;

{--------------------------------------------------------------------------}

{ Linking Graphic1 into this file. }
{ "Graphic1" is the public name given to it with BINOBJ }

{$L GRAPHIC1.OBJ}
procedure Graphic1; external;

{--------------------------------------------------------------------------}

function EGAVGAthere: boolean;

{ This function checks for an EGA or VGA video adapter }


begin
  EGAVGAthere := FALSE;
  DetectGraph(sysgraphadapter, sysgraphmode);
  if (sysgraphadapter = 9) then EGAVGAthere := TRUE;
  if (sysgraphadapter = 3) then EGAVGAthere := TRUE;
end;

{--------------------------------------------------------------------------}

{ Linking the EGAVGA.BGI driver into the EXE.  Refer to BGILINK.PAS }
{ that came with Turbo Pascal for more information on how to link   }
{ drivers. }

procedure egavgadriverproc; external;
{$L EGAVGA.OBJ}


procedure RegisterEGAVGA;  { The linked driver must be registered }

begin
  if RegisterBGIDriver(@egavgadriverproc) < 0 then
  begin
    writeln('Error registering driver:',Grapherrormsg(graphresult));
    readln;
    Halt(1);
  end;
end;

{--------------------------------------------------------------------------}

procedure initEGAVGA;

{ This procedure initializes the EGAVGA driver, only if one is detected. }
{ If the hardware is not found, the program exits with a message saying  }
{ that it needs EGA or VGA.  The command line switch '/e' is availible   }
{ for some old EGA cards that are detected as VGA. }

var
  grapherror : integer;

begin
  if EGAVGAthere then
  begin
    graphdriver := VGA;
    graphmode := VGAHi;
    if paramstr(1) = '/e' then graphmode := EGAHi;
    detectgraph(sysgraphadapter, sysgraphmode);
    if sysgraphadapter = EGA then graphmode := EGAHi;
    initgraph(graphdriver, Graphmode,'');
    Grapherror := graphresult;
    if grapherror <> 0 then
    begin
      writeln('Error initializing graphics:',Grapherrormsg(grapherror));
      halt(1);
    end;
  end
  else
  begin
    writeln('This program requires EGA or VGA graphics to run.');
  halt(1);
  end;
end;

{--------------------------------------------------------------------------}

BEGIN
  RegisterEGAVGA;
  InitEGAVGA;
  g2 := @graphic2;  { assign the pointers to the graphics }
  g1 := @graphic1;
  SetColor(15);
  OutTextXY(2,2,'Graphic 1 was linked through the main file.');
  OutTextXY(2,12,'Graphic 2 was linked through a unit.');
  OutTextXY(2,22,'Both of the graphics and the driver are');
  OutTextXY(2,32,'included in the EXE.');
  OutTextXY(2,42,'Press ENTER to exit.');
  PutImage(10,60,g1^,normalPut);      { place the graphics }
  PutImage(120,60,g2^,NORMALPut);
  Readln;
  for i := 1 to (GetMaxY div 3) do
  begin                             { Slide the graphics off the screen }
    PutImage(10,60+(i*3),g1^,NormalPut);
    PutImage(120,60+(i*3),g2^,NormalPut);
  end;
  CloseGraph;
END.

