{ An Improved TTerminal.StrWrite() Method }
{etc.}
{================================================================
 Define an interior view for the window...
----------------------------------------------------------------}
  PInterior = ^TInterior;
  TInterior = OBJECT(TTerminal)
    TheText : PTextBuf;         { TextBuf for Terminal "writes" }
    MaxWide : Integer;              { Maximum TScroller.Limit.X }
    { Other application-specific variables }
{----------------------------------------------------------------
 TInterior Methods...
----------------------------------------------------------------}
    CONSTRUCTOR Init(VAR Bounds: TRect;
                     AHScrollBar, AVScrollBar: PScrollBar;
                     ABufSize : Word);
    DESTRUCTOR Done; VIRTUAL;
    PROCEDURE StrWrite(VAR S : TextBuf; Count : Byte); VIRTUAL;
    PROCEDURE HandleEvent(VAR Event : TEvent); VIRTUAL;
    { Other application-specific methods }
  END;
{etc.}
{****************************************************************
              T I n t e r i o r   M e t h o d s
----------------------------------------------------------------}
CONSTRUCTOR TInterior. Init(VAR Bounds: TRect;
                           AHScrollBar, AVScrollBar: PScrollBar;
                           ABufSize : Word);
{----------------------------------------------------------------
  Initializes the TInterior object.
----------------------------------------------------------------}
BEGIN
{----------------------------------------------------------------
  Call the parent object's initialization logic.
  Initialize key parameters...
----------------------------------------------------------------}
  TTerminal.Init(Bounds,AHScrollBar,AVScrollBar,ABufSize);
  TheText  := New(PTextBuf);
  MaxWide  := SizeOf(TextBuf); {------------------------- NOTE! }
  { Other application-specific initialization }
END;
{===============================================================}
DESTRUCTOR TInterior.Done;
{----------------------------------------------------------------
  Cleans up TInterior data...
----------------------------------------------------------------}
BEGIN
  { Other application-specific clean-up }
  Dispose(TheText);
  TTerminal.Done;
END;
{===============================================================}
PROCEDURE TInterior.StrWrite(VAR S : TextBuf; Count : Byte);
{----------------------------------------------------------------
 Replacement for TTerminal.StrWrite().  DOES NOT call CaldWidth;
 used MaxWide for SetLimit call.
 ----------------------------------------------------------------}
VAR
  I,J,LimitY: Word;

BEGIN
{----------------------------------------------------------------
 Ensure that the "Count" is valid.
----------------------------------------------------------------}
  IF (Count <= 0) THEN Exit;             { Exit for a bad count }
  IF (Count >= BufSize) THEN Count := BufSize - 1;
  LimitY := Limit.Y;                    { Local copy of Limit.Y }
  J      := 0;
{----------------------------------------------------------------
 Process each charater in "S"
----------------------------------------------------------------}
  FOR I := 0 TO (Count - 1) DO BEGIN 
    IF (S[I] = ^M) THEN Dec(Count)    { "Lose" carraige returns }
    ELSE BEGIN
      IF (S[I] = ^J) THEN Inc(LimitY);  { LF means another line }
      S[J] := S[I];
      Inc(J);
    END;
  END; {------------------------------ FOR I := 0 TO LvCnt... }
{----------------------------------------------------------------
 If necessary, purge oldest line(s) to fit in "Count" characters
----------------------------------------------------------------}
  WHILE (NOT CanInsert(Count)) DO BEGIN
    QueBack := NextLine(QueBack);
    Dec(LimitY);
  END;
{----------------------------------------------------------------
 If necessary, handle wraparound to beginning of buffer
----------------------------------------------------------------}
  IF ((QueFront + Count) >= BufSize) THEN BEGIN
    I := BufSize - QueFront;
    Move(S,Buffer^[QueFront],I);
    Move(S[I],Buffer^,(Count - I));
    QueFront := Count - I;
  END
{----------------------------------------------------------------
 Otherwise, move the full "S" contents into the buffer at QueFront.
----------------------------------------------------------------}
  ELSE BEGIN
    Move(S,Buffer^[QueFront],Count);
    QueFront := QueFront + Count;
  END;
{----------------------------------------------------------------
 Set the scroller's horizontal and vertical limits...
 NOTE: The replaces "SetLimit(CalcWidth,LvLimY);"
----------------------------------------------------------------}
  SetLimit(MaxWide,LimitY);
{----------------------------------------------------------------
 - Scroll to the new location, using the local "Y" limit value.
 - Calculate the new cursor position, and set the cursor there.
 - Redraw the screen before exiting.
----------------------------------------------------------------}
  ScrollTo(0,(LimitY + 1));
  I := PrevLines(QueFront,1);
  IF (I <= QueFront) THEN I := QueFront - I
  ELSE I := BufSize - (I - QueFront);
  SetCursor(I,(LimitY - Delta.Y) - 1);
  DrawView;
END;
{===============================================================}
PROCEDURE TInterior.HandleEvent(VAR Event : TEvent);
{----------------------------------------------------------------
  Handles keyboard input to the "Interior."
----------------------------------------------------------------}
BEGIN
{----------------------------------------------------------------
 Let the parent object (TTerminal) handle the standard events.
----------------------------------------------------------------}
  TTerminal.HandleEvent(Event);
{----------------------------------------------------------------
 If a key was pressed,...
----------------------------------------------------------------}
  IF (Event.What = evKeyDown) THEN BEGIN
    CASE Event.KeyCode OF
    { Application-specific processing }
    END; {--------------------------- CASE Event.KeyCode OF ... }
  END; {------------------------ IF (Event.What = evKeyDown)... }
END;

