/*==================================================================
 fptrig.cpp -- Fixed point math class trig functions [Listing #3]
 by Robert N. Goldrich
 Tested with Borland, Microsoft, Zortech, and TopSpeed C++
==================================================================*/
#include "fpnum.h"

#if( FP_FRCBITS != 16)
    #error Fixed-point trig table good only for 16 fractional bits
#endif

static unsigned sin_table[] = {   //  "static" enforces info hiding
        0U,     1143U,     2287U,     3429U,     4571U, //  0 deg.
     5711U,     6850U,     7986U,     9120U,    10252U,
    11380U,    12504U,    13625U,    14742U,    15854U, // 10
    16961U,    18064U,    19160U,    20251U,    21336U,
    22414U,    23486U,    24550U,    25606U,    26655U, // 20
    27696U,    28729U,    29752U,    30767U,    31772U,
    32768U,    33753U,    34728U,    35693U,    36647U, // 30
    37589U,    38521U,    39440U,    40347U,    41243U,
    42125U,    42995U,    43852U,    44695U,    45525U, // 40
    46340U,    47142U,    47929U,    48702U,    49460U,
    50203U,    50931U,    51643U,    52339U,    53019U, // 50
    53683U,    54331U,    54963U,    55577U,    56175U,
    56755U,    57319U,    57864U,    58393U,    58903U, // 60
    59395U,    59870U,    60326U,    60763U,    61183U,
    61583U,    61965U,    62328U,    62672U,    62997U, // 70
    63302U,    63589U,    63856U,    64103U,    64331U,
    64540U,    64729U,    64898U,    65047U,    65176U, // 80
    65286U,    65376U,    65446U,    65496U,    65526U
} ;                                                // Thru 89 deg


/*------------------------------------------------------------------
 fp_sin()
------------------------------------------------------------------*/
fpnum fp_sin( int angle )
{
    angle %= 360 ;            // force angle between 0-360 degrees
    if( angle < 0 ) {
        angle += 360 ;
    }

    fpnum sinvalue ;                // this is the return value

    if( angle == 90 ) {             // not handled by table
        return sinvalue.poke( FP_ONE ) ;
    }

    if( angle == 270 ) {            // not handled by table
        return sinvalue.poke( -FP_ONE ) ;
    }

    switch( angle/90 ) {    // switch based on quadrant
        case 0:                         // 0 - 90 deg
            return sinvalue.poke( sin_table[angle] ) ;
        case 1:                         // 90 - 180 deg
            return sinvalue.poke( sin_table[180-angle] ) ; ;
        case 2:                         // 180 - 270 deg
            return sinvalue.poke( -((long)sin_table[angle-180]) ) ;
        case 3:                         // 270 - 360 deg
            return sinvalue.poke( -((long)sin_table[360-angle]) ) ;
    }
}


/*------------------------------------------------------------------
 fp_tan()
------------------------------------------------------------------*/
fpnum fp_tan( int angle )
{
    return fp_sin( angle ) / fp_cos( angle ) ;
}
