/* DOSDISK.C */

#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>

#define DOS_DATA_SEG  0x0050

/***/
/* Returns drive currently attached to block device
   defined by 'drive'. */
char get_logical_drive(char drive)
{
char cur_drive;       /* Current drive attached to block device. */
union REGS regs;      /* Registers for interrupt calls. */

/* Default to current drive. */
drive = drive ? toupper(drive) : (getdisk() + 'A');

/* Check for valid drive letter. */
if (!isalpha(drive))
  {
  cur_drive = 0;
  _doserrno = EINVDRV;
  }
else
  /* Check for DOS version 3.20 or above. */
  if (_osmajor > 3 || _osmajor == 3 && _osminor >= 20)
    {
    /* IOCTL request 0x0E (get logical drive). */
    regs.x.ax = 0x440E;

    /* Drive number (1 = A, 2 = B, etc) is in BL. */
    regs.h.bl = drive - ('A' - 1);

    intdos(&regs, &regs);

    if (regs.x.cflag)
      /* Carry flag set, error in _doserrno. */
      cur_drive = 0;
    else
      /* Return code of 0 in AL means only one drive attached
         to block device. */
      cur_drive = regs.h.al == 0 ? drive : regs.h.al + ('A' - 1);
    }
  else
    /* For lower versions of DOS, only drives
       A and B are interchangeable. */
    if (drive == 'A' || drive == 'B')
      {
      int86(0x11, &regs, &regs);

      /* Bit 0 in AX is 1 if diskette drives are present. */
      if (regs.x.ax & 0x0001)
        if (((regs.x.ax & 0xC0) >> 6) == 0)
          /* Only one diskette installed. */
          cur_drive = drive == 'A' || drive == 'B'
          ? peekb(DOS_DATA_SEG, 0x0004) + 'A' : drive;
        else
          /* More than one diskette installed. */
          cur_drive = drive;
      else
        /* No diskette drive. */
        {
        cur_drive = 0;
        _doserrno = EINVDRV;
        }
      }
    else
      cur_drive = drive;

return (cur_drive);
}

/***/
/* Attaches logical drive to block device
   if not already attached. */
char set_logical_drive(char drive)
{
char cur_drive;    /* Current drive attached to block device. */
union REGS regs;   /* Registers for interrupt calls. */

/* Default to current drive. */
drive = drive ? toupper(drive) : (getdisk() + 'A');

if ((cur_drive = get_logical_drive(drive = toupper(drive)))
   != 0 && cur_drive != drive)
  {
  /* REPLACE THIS WITH WHATEVER YOU WANT TO PROMPT FOR CHANGE. */
  printf("Insert disk for drive %c: and press RETURN", drive);
  getchar();

  /* Check for DOS version 3.20 or above. */
  if (_osmajor > 3 || _osmajor == 3 && _osminor >= 20)
    {
    /* IOCTL request 0x0F (set logical drive). */
    regs.x.ax = 0x440F;

    /* Drive number (1 = A, 2 = B, etc) is in BL. */
    regs.h.bl = drive - ('A' - 1);

    intdos(&regs, &regs);

    if (regs.x.cflag)
      /* Carry flag set, error in _doserrno. */
      drive = 0;
    }
  else
    /* For lower versions of DOS, only drives A and B
       are interchangeable. */
    if (drive == 'A' || drive == 'B')
      pokeb(DOS_DATA_SEG, 0x0004, drive - 'A');
  }

return (cur_drive);
}
