// THREED.H: Header file for THREED.CPP.
#ifndef THREEDH
#define THREEDH
#include "vector.h"

#define EM_FILEOPENERROR -100
#define EM_FILETOOBIG -101
#define NUMCONNECTIONS 400   // An object can have this many
#define NUMVERTICES 450      // vertices and connections.
#define PCL 0                // Borders of viewing region on
#define PCR 1000             // the screen. These four variables
#define PCT 0                // correspond to the left, right,
#define PCB 1000             // top, and bottom pixel boundaries
			     // of the viewing region.
// A three-dimensional viewing class
class TThreeD {
public:
  double a, b, c, d, dval;
  VECTOR from, at, up;               // Viewing parameters
  double Angle;                      // The viewing angle
  VECTOR a1, a2, a3;                 // Used in 3-D transform
  int connect[NUMCONNECTIONS];       // Vertex connections
  VECTOR pointarray[NUMVERTICES];    // Vertices
  int pcb, pct, pcl, pcr;     // Screen boundaries of viewing area
  int length;                 // Number of vertex connections
  int vertices;               // Number of vertices
  double objxmin, objxmax;    // Extent of 3-D object
  double objymin, objymax;
  double objzmin, objzmax;
  double offsx, offsy, offsz; // Transform variables
  VECTOR dist;                // Distance between from and at points
  TThreeD();
  void Display(HDC hDC, RECT& rect); // High level display routine
  virtual int Read3DObject(char *FileName);
  void MinMax();
  void WORLDtoPC(double xw, double yw, POINT& pc);
  int Code(double x, double y, double z);
  void SetAt();
  virtual void SetFrom();
  void SetEye();
  virtual void View(HDC hDC);
  void TransformSeg(HDC hDC, VECTOR *v1, VECTOR *v2,
    POINT& pc1, POINT& pc2);
  virtual void Clip3D(HDC hDC, double x1, double y1, double z1,
    double x2, double y2, double z2, POINT& pc1, POINT& pc2);
};
typedef TThreeD *PTThreeD;
#endif THREEDH
