#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

void pascal va_push(void);
void pascal va_pop(size_t stksize);

#ifdef __cplusplus
};
#endif

/* Convert va_push(void) to va_push(type value). */
#define va_push(type, value)  \
  ((*((void pascal (*)(type))va_push))(value))

/* Depth of stack popped is n * sizeof(type) + sizeof(size_t);
type    is word-aligned on stack and extra size_t is for
parameter to    va_pop() itself. */
#define va_pop(type, n)  \
  (va_pop((size_t)((sizeof(type) + 1) & 0xFFFE) *  \
          (size_t)(n) + (size_t)sizeof(size_t)))
