function CPUtype:word;

(* Returns a value depending on the CPU type
      0 if 8088/V20 or compatible
      1 if 80286
      2 if 80386 or better

    Original code based on Nicholas Wilt's code in
    PC Techniques Feb/Mar '91 issue.  *)

label
  quit;

begin
  asm
    xor dx,dx      { clear dx }
    push dx
    popf           { Clear flags }
    pushf
    pop ax         { load 'cleared' flags into AX }
    and ax,0f000h    { check high bits of ax for F0 }
    cmp ax,0f000h
    je quit        { quit if 8088 }
    inc dx
(*
    push 0f000h    I removed this statement because
                   it won't assemble in non-286 mode!
*)
    mov ax,0f000h  { Now check for 80286 }
    push ax
    popf
    pushf
    pop ax
    and ax,0f000h { If the top 4 bits aren't set then }
    jz quit       { it's a 286 }
    inc dx        { else it's a 386 or better }
quit:
    mov @result,dx  { move CPU type into function return }
  end;
 end;

begin
  write('The CPU is a ');
  case CpuType of
    0:writeln('8088/8086/V20');
    1:writeln('80286');
    2:writeln('80386/80486');
  end;
end.