unit ClockISR;
interface

uses CRT,DOS;

type  str2 = string[2];

procedure MoveClock(row,col:byte); 
procedure RestoreClock; 
procedure SuspendClock; 
procedure ResumeClock;  

implementation

const  ClockRow : byte = 25;        
       ClockCol : byte = 74;  

var  ClkStr           : string[6];      
     coord,  curs,      
     Hour, Minute,      
     Counter          : word;      
     ExitSave, Old1C  : pointer;      
     V                : text;  { for DirectVideo writes }

function Fmt(i : integer):str2; 
var t : str2; 
begin   
  Str(i:2,t);   
  if t[1]=' ' then     
    t[1] := '0';   
  Fmt := t; 
end;  

procedure SaveCursor; 
var reg : DOS.Registers; 
begin   
  reg.AH := 3;   
  reg.BH := 0;   
  intr($10,reg);   
  coord  := reg.DX;   { Cursor position }   
  curs   := reg.CX;   { Top and bottom lines }   
  reg.AH := 1;   
  reg.CH := $20;      { Hides cursor on MDA, CGA, VGA }
  intr($10,reg);      { Change CH for Herc and EGA    } 
end;  

procedure RestoreCursor; 
var reg : DOS.Registers; 
begin   
  reg.AH := 2;   
  reg.BH := 0;   
  reg.DX := coord;  { Put cursor back in place }   
  intr($10,reg);   
  reg.CX := curs;   { Restore cursor lines }   
  reg.AH := 1;   
  intr($10,reg); 
end;  

procedure MoveClock; 
begin   
  ClockRow := row;   
  ClockCol := col; 
end;  

procedure RestoreClock; 
begin   
  ClockRow := 25;   
  ClockCol := 74; 
end;  

procedure JumpToPriorISR(p: pointer);
inline($5B/$58/$87/$5E/$0E/$87/$46/$10/$89/$EC/$5D/$07/$1F/
       $5F/$5E/$5A/$59/$CB); 

procedure Clock;interrupt; 
var a : byte; 
begin   
  dec(Counter);   
  if Counter=0 then     
    begin       
      inc(Minute);       
      if Minute>59 then         
        begin           
          inc(Hour);           
          if Hour>23 then             
            Hour := 0;           
          Minute := 0;         
        end;       
      if Hour=0 then         
        ClkStr := '12'       
      else         
        if Hour>12 then           
          ClkStr := Fmt(Hour-12)         
        else           
          ClkStr := Fmt(Hour);       
      ClkStr := ClkStr+':'+Fmt(Minute)+' ';       
      if Hour<12 then         
        ClkStr[6] := 'A'       
      else         
        ClkStr[6] := 'P';       
      Counter := 1091;     
    end;   
  if odd(Counter) then     
    begin       
      SaveCursor;       
      GotoXY(ClockCol,ClockRow);       
      a := TextAttr;     { Store current CRT color combo }
      TextAttr := 15;       
      Write(V,ClkStr);       
      TextAttr := a;     { Restore color combo }
      RestoreCursor;     
    end;   
  JumpToPriorISR(Old1C); 
end;  

procedure ClockExit; far;  { For TP4 and 5 use $F+/$F- } 
begin { Restore clock interrupt vector }   
  SetIntVec($1C,Old1C);   
  TextAttr := 7;             { tidy up the screen }
  GotoXY(ClockCol,ClockRow);   
  write('      ');  { Six spaces }   
  ExitProc := ExitSave; 
end;

procedure SuspendClock;  { Restore the original vector, } 
begin                    { suspending our clock         }    
SetIntVec($1C,Old1C); 
end;

procedure ResumeClock; 
begin   
  GetTime(Hour,Minute,Counter,Counter); { Back in business }
  Counter := 1;   
  SetIntVec($1C,@Clock); 
end;

begin   
  AssignCRT(V);   
  rewrite(V);   
  ExitSave := ExitProc;   
  ExitProc := @ClockExit;   
  GetTime(Hour,Minute,Counter,Counter);   
  Counter := 1;   
  GetIntVec($1C,Old1C);   { The old interrupt vector }
  SetIntVec($1C,@Clock);  { What we want done instead } 
end.
