Program ProComm_Plus_Directory;
{ ---------------------------------------------------------------------
  --                                                                 --
  --  Sample program which moves a block of entries from one PCPlus  --
  --  directory file to another.                                     --
  --                                                                 --
  --  Author:  Todd A. Scalzott                                      --
  --           Metro Consulting Group, Inc.                          --
  --           10605 Lakeside Oak Court                              --
  --           Burke, VA  22015                                      --
  --           (703) 250-9271                                        --
  --------------------------------------------------------------------- }
USES
   PCPLUS;

VAR
   Source_Dir,                       { Pointer to the source directory     }
   Dest_Dir    : ProComm_File;       { Pointer to the dest directory       }
   Source,                           { User specified source directory name}
   Dest        : STRING[255];        { User specified dest directory name  }
   Entry       : ProComm_Entry;      { User specified source dir name      }

   Result,                           { Result of a PCPLUS operation        }
   Dir_Count,
   Source_Start,                     { Starting entry into the source dir  }
   Source_End,                       { Ending entry into the source dir    }
   Dest_Start    : INTEGER;          { Starting entry into the dest dir    }



FUNCTION File_Exists ( File_To_Find : STRING ) : BOOLEAN;
{ ---------------------------------------------------------------------
  --                                                                 --
  --  Function to return TRUE or FALSE based upon the existence of   --
  --  a file.                                                        --
  --                                                                 --
  --------------------------------------------------------------------- }

VAR
   File_Var   : FILE;                   { File variable for attempting OPEN   }
   Throw_Away : INTEGER;                { Result of IO operations (discarded) }


BEGIN

   ASSIGN (File_Var, File_To_Find);
   {$I-}
   RESET (File_Var);
   File_Exists := (IORESULT = 0);
   CLOSE(File_Var);
   Throw_Away := IORESULT;
   {$I+}

END;   { Function File_Exists }


FUNCTION Get_Directory_Name : STRING;
{ ---------------------------------------------------------------------
  --                                                                 --
  --  Get the name of the directory file from the user.              --
  --  Will return the result of "#QUIT#" if the user pressed CR to   --
  --  quit the program.                                              --
  --                                                                 --
  --------------------------------------------------------------------- }
VAR
   Valid_File : BOOLEAN;
   Temp_Name  : STRING;


BEGIN

   REPEAT
      Valid_File := FALSE;
      READLN ( Temp_Name );
      IF (LENGTH(Temp_Name) > 0) THEN
         Valid_File := File_Exists(Temp_Name);
   UNTIL (Valid_File) OR (Temp_Name = '');

   IF (LENGTH(Temp_Name) = 0) THEN
      Get_Directory_Name := '#QUIT#'
   ELSE
      Get_Directory_Name := Temp_Name;

END;  { Function Get_Directory_Name }



{    *      M A I N      *     }

BEGIN

   WRITELN;
   WRITELN ('Enter The Name Of The Source Directory:');
   Source := Get_Directory_Name;

   IF (Source <> '#QUIT#') THEN
      { Attempt to open the source directory }
      Open_Dir_File ( Source, Source_Dir, Result );

   IF (Result = 0) THEN BEGIN
      WRITELN ('Enter The Name Of The Destination Directory:');
      Dest := Get_Directory_Name;
      { Attempt to open the destination directory }
      Open_Dir_File ( Dest, Dest_Dir, Result );
   END;

   IF (Result = 0) THEN BEGIN
      WRITELN;
      WRITE ('Source Beginning Entry Number:  ');
      READLN (Source_Start);
      WRITE ('Source Ending Entry Number   :  ');
      READLN (Source_End);
      WRITE ('Destination Beginning Entry Number:  ');
      READLN (Dest_Start);
   END;

   { Do a little bit of error checking }
   IF (Source_End < 1) OR (Source_End > 200) THEN              HALT;
   IF (Source_Start < 1) OR (Source_Start > Source_End) THEN   HALT;
   IF (Dest_Start > 200) OR (Dest_Start < 1) THEN              HALT;

   { Get and write each entry.  Could be done with the block read and
     write procedures. }
   FOR Dir_Count := Source_Start TO Source_End DO BEGIN
      Get_Entry(Source_Dir,Dir_Count,Entry,Result);

      IF (Result = 0) AND (Dest_Start < 201) THEN
         { Write in raw mode since we have not modified anything }
         Write_Entry(Dest_Dir,Dest_Start,Entry,TRUE,Result);
      Dest_Start := Dest_Start + 1;
   END;

   { Close down the files }
   Close_Dir_File ( Source_Dir, Result );
   Close_Dir_File ( Dest_Dir, Result );

END.