(*********************************************)
(*                                           *)
(*  Talks to your modem. Called by TERM.PAS  *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*  It is provided as an example of the use  *)
(*  of the Personal Communications Library.  *)
(*                                           *)
(*********************************************)

unit Modem_IO;

interface

type
  String80 = String[80];

procedure ModemEcho(Port:Integer;Echo:Integer);
function  ModemSendTo(Port:Integer;Pace:Integer;TheString:String80):Boolean;
function  ModemWaitFor(Port:Integer;WaitTics:Integer;CaseFlag:Boolean;TheString:String80):Boolean;
procedure ModemCmdState(Port:Integer);
procedure ModemHangup(Port:Integer);
function  ModemQuiet(Port:Integer;Tics:Integer):Boolean;

implementation

uses PCL4P;

function BreakTest : Boolean;
begin
  if SioBrkKey then
    begin
      WriteLn('User BREAK');
      BreakTest := True
    end
  else BreakTest := False;
end;

procedure ModemEcho(Port:Integer;Echo:Integer);
var
  rc   : Integer;
  Time : LongInt;
begin
  Time := SioTimer;
  repeat
    rc := SioGetc(Port,1);
    if rc >= 0 then write(chr(rc));
  until SioTimer > Time+Echo;
end; (* ModemEcho *)

function ModemSendTo(Port:Integer;Pace:Integer;TheString:String80):Boolean;
const CR = 13;
var
   rc   : Integer;
   i    : Integer;
   c    : Char;
   Time : LongInt;
begin
   for i := 1 to Length(TheString) do
      begin
         if BreakTest then
           begin
             ModemSendTo := False;
             exit;
           end;
         (* delay 'Pace' tics *)
         if Pace > 0 then ModemEcho(Port,Pace);
         c := TheString[i];
         case c of
            '!' : c := chr(CR);
            '~' : begin
                    (* delay 1/2 second *)
                    rc := SioDelay(10);
                    c := ' '
                  end;
             ' ': begin
                    (* delay 1/4 second *)
                    rc := SioDelay(5);
                    c := ' ';
                  end;
         end;
         (* transmit as 7 bit char *)
         rc := SioPutc(Port, chr(ord(c) and $7f));
      end; (* for *)
    ModemSendTo := True;
end; (* SendTo *)

function ModemWaitFor(Port:Integer;WaitTics:Integer;CaseFlag:Boolean;TheString:String80):Boolean;
const
  CR = 13;
  LF = 10;
var
  c1,c2 : Char;
  i,rc  : Integer;
  Time  : LongInt;
  First : Integer;
  Len   : Integer;
begin (* WaitFor *)
  First := 1;
  Len := Length(TheString);
  Time := SioTimer;
  while SioTimer < Time+WaitTics do
    begin
       (* control-BREAK ? *)
       if BreakTest then exit;
       rc := SioGetc(Port,1);
       if rc < -1 then
         begin
           ModemWaitFor := False;
           exit;
         end;
       if rc >= 0 then
         begin
           write(chr(rc));
           (* prepare chars *)
           c1 := TheString[First];
           First := First + 1;
           c2 := chr(rc);
           (* case sensitive ? *)
           if not CaseFlag then
             begin
               c1 := UpCase(c1);
               c2 := UpCase(c2);
             end;
           (* do we have a match *)
           if c1 = c2 then
             begin
               if First > Len then
                 begin
                   ModemWaitFor := True;
                   exit;
                 end
             end
           else First := 1;
         end
    end; (* while *)
  (* timed out *)
  ModemWaitFor := False;
end; (* WaitFor *)

procedure ModemCmdState(Port:Integer);
var
  i, rc : Integer;
begin
  (* delay a bit over 1 second *)
  rc := SioDelay(25);
  (* send escape code 3 times *)
  for i := 1 to 3 do
    begin
      rc := SioPutc(Port,'+');
      rc := SioDelay(5);
    end;
  (* another 1 second delay *)
  rc := SioDelay(25);
end; (* ModemCmdState *)

procedure ModemHangup(Port:Integer);
var
  Flag : Boolean;
begin
  ModemCmdState(Port);
  Flag := ModemSendTo(Port,5,'!AT!');
  ModemEcho(Port,10);
  Flag := ModemSendTo(Port,5,'ATH0');
end; (* ModemHangup *)

function  ModemQuiet(Port:Integer;Tics:Integer):Boolean;
var
  Time : LongInt;
  rc   : Integer;
begin
  Time := SioTimer;
  repeat
    (* control-BREAK ? *)
    if BreakTest then exit;
    rc := SioGetc(Port,1);
    if rc < -1 then
      begin
        ModemQuiet := False;
        exit;
      end;
    if rc >= 0 then
      begin
        Time := SioTimer;
        write(chr(rc));
      end
  until SioTimer >= Time + Tics;
  ModemQuiet := True;
end; (* ModemQuiet *)


end.
