(**********************************************)
(*                                            *)
(*      TERM.PAS         Aug  1994            *)
(*                                            *)
(*  TERM is a simple terminal emulator which  *)
(*  features XMODEM, YMODEM, YMODEM-G, and    *)
(*  ASCII file transfer.                      *)
(*                                            *)
(*  Do NOT select YMODEM-G when using a null  *)
(*  modem cable unless you are certain that   *)
(*  RTS & CTS are reversed -- which is        *)
(*  usually not true.                         *)
(*                                            *)
(*  Remember that you cannot send or receive  *)
(*  binary files with ascii protocol - this   *)
(*  includes many word processor file formats *)
(*  such as used by Wordstar.                 *)
(*                                            *)
(*  This program is donated to the Public     *)
(*  Domain by MarshallSoft Computing, Inc.    *)
(*  It is provided as an example of the use   *)
(*  of the Personal Communications Library.   *)
(*                                            *)
(**********************************************)

{$I DEFINES.PAS}

program term;

{$IFDEF SCRIPTS}
uses si, hex_io, term_io, modem_io, xymodem, xypacket, amodem, crc, crt, PCL4P;
{$ELSE}
uses hex_io, term_io, modem_io, xymodem, xypacket, amodem, crc, crt, PCL4P;
{$ENDIF}


Var (* globals *)
  ResetFlag : Boolean;
  Port : Integer;
  TxBufPtr : Pointer;
  RxBufPtr : Pointer;
  TxBufSeg : Integer;
  RxBufSeg : Integer;

  procedure MyHalt( Code : Integer );
  var
     RetCode : Integer;
  begin
     if Code < 0 then SayError( Code,'Halting' );
     if ResetFlag then RetCode := SioDone(Port);
     writeln('*** HALTING ***');
     Halt;
  end;

(* main program *)

label 500;

const
  NAK = $15;
  WrongBaud1 = 'Cannot recognize baud rate';
  WrongBaud2 = 'Must be 300,600,1200,2400,4800,9600,19200,38400,57600, or 155200';

var
  Filename : String12;
  ResultMsg: String40;
  c        : Char;
  BaudCode : Integer;
  Protocol : Char;
  Buffer   : BufferType;
  RetCode  : Integer;
  TheByte  : Char;
  i        : Integer;
  MenuMsg  : String40;
  StatusMsg: String40;
  GetNameMsg: String40;
  Text40   : String40;
  OneKflag : Boolean;
  NCGbyte  : Byte;
  BatchFlag: Boolean;
  Flag     : Boolean;
  Version  : Integer;
  TermChar : Byte;
  CharPace : Integer;
  Timeout  : Integer;
  EchoFlag : Boolean;
begin   (* main program *)
  InitCRC;
  TextMode(BW80);
  ClrScr;
  Window(1,1,80,24);
  ResetFlag := FALSE;
  Protocol := 'X';
  OneKflag := FALSE;
  NCGbyte := NAK;
  BatchFlag := FALSE;
  MenuMsg := 'Q)uit P)rotocol S)end R)eceive: ';
  GetNameMsg := 'Enter filename: ';
  StatusMsg := 'COM? X  "ESC for menu" ';
  (* fetch PORT # from command line *)
  if ParamCount < 2 then
    begin
      writeln('USAGE: "TERM <port> <baudrate> {script}" ');
      halt;
    end;
  Val( ParamStr(1),Port, RetCode );
  if RetCode <> 0 then
    begin
      writeln('Port must be 1 to 16');
      Halt;
    end;
  (* COM1 = 0, COM2 = 1, etc. *)
  Port := Port - 1;
  BaudCode := MatchBaud(ParamStr(2));
  if BaudCode < 0 then
    begin
      writeln(WrongBaud1);
      writeln(WrongBaud2);
      halt;
    end;
  (* patch up status message *)
  StatusMsg[4] := chr($31+Port);
  Insert(ParamStr(2),StatusMsg,8);
  WriteMsg(StatusMsg,40);
  if (Port<COM1) or (Port>COM16) then
    begin
      writeln('Port must be 1 to 16');
      Halt
    end;

  (*** custom configuration: 4 port card
  RetCode := SioIRQ(COM3,IRQ2);
  RetCode := SioIRQ(COM4,IRQ2);
  ***)

  (*** custom configuration: DigiBoard PC/8
  RetCode := SioPorts(8,COM1,$140,DIGIBOARD);
  RetCode := SioUART(Port,$100+8*Port) ;
  if RetCode < 0 then MyHalt( RetCode );
  RetCode := SioIRQ(Port,IRQ5) ;
  if RetCode < 0 then MyHalt( RetCode );
  ***)

  (*** custom configuration: BOCA board BB2016
  RetCode := SioPorts(16,COM1,$107,BOCABOARD);
  RetCode := SioUART(Port,$100+8*Port) ;
  if RetCode < 0 then MyHalt( RetCode );
  RetCode := SioIRQ(Port,IRQ5) ;
  if RetCode < 0 then MyHalt( RetCode );
  ***)

  (* setup 2K receive buffer *)
  GetMem(RxBufPtr,2048+16);
  RxBufSeg := (Seg(RxBufPtr)+1) + (Ofs(RxBufPtr) SHR 4);
  RetCode := SioRxBuf(Port, RxBufSeg, Size2048);
  if RetCode < 0 then MyHalt( RetCode );
  (* setup 2K transmit buffer *)
  GetMem(TxBufPtr,2048+16);
  TxBufSeg := (Seg(TxBufPtr)+1) + (Ofs(TxBufPtr) SHR 4);
  RetCode := SioTxBuf(Port, TxBufSeg, Size2048);
  if RetCode < 0 then MyHalt( RetCode );
  (* reset port *)
  RetCode := SioReset(Port,BaudCode);
  (* if error then try one more time *)
  if RetCode <> 0 then RetCode := SioReset(Port,BaudCode);
  (* Was port reset ? *)
  if RetCode <> 0 then
    begin
      writeln('Cannot reset COM',Port+1);
      MyHalt( RetCode );
    end;
  (* Port successfully reset *)
  ResetFlag := TRUE;
  ClrScr;
  (* show logon message *)
  WriteLn('   -- TERM 7/16/94 --');
  WriteLn;
  Write('TX interrupts: ');
  if SioInfo('I') = 0 then WriteLn('NO')
  else WriteLn('YES');
  Version := SioInfo('V');
  WriteLn('      Library: ',Version SHR 4,'.',15 AND Version);
  (* specify parity, # stop bits, and word length for port *)
  RetCode := SioParms(Port, NoParity, OneStopBit, WordLength8);
  if RetCode < 0 then MyHalt( RetCode );
  RetCode := SioRxFlush(Port);
  if RetCode < 0 then MyHalt( RetCode );
  Write(' Flow control: ');
{$IFDEF RTS_CTS_CONTROL}
  (* enable RTS/CTS flow control *)
  RetCode := SioFlow(Port,10*18);
  WriteLn('YES');
{$ELSE}
  WriteLn('NO');
{$ENDIF}
  (* set FIFO level if have INS16550 *)
  RetCode := SioFIFO(Port, LEVEL_8);
  Write('   16550 UART: ');
  if RetCode > 0 then WriteLn('YES')
  else WriteLn('NO');
  WriteLn;
  (* set DTR & RTS *)
  RetCode := SioDTR(Port,SetPort);
  RetCode := SioRTS(Port,SetPort);

{$IFDEF AT_COMMAND_SET}
  Write('Waiting for DSR');
  repeat
    if SioBrkKey OR KeyPressed then
      begin
        Write('Aborted by user...');
        RetCode := SioDone(Port);
        Halt
      end;
    Write('.');
    RetCode := SioDelay(18);
  until (SioDSR(Port)>0);
  WriteLn;
{$ENDIF}

{$IFDEF RTS_CTS_CONTROL}
  Write('Waiting for CTS');
  repeat
    if SioBrkKey OR KeyPressed then
      begin
        Write('Aborted by user...');
        RetCode := SioDone(Port);
        Halt
      end;
    Write('.');
    RetCode := SioDelay(18);
  until (SioCTS(Port)>0);
  WriteLn;
{$ENDIF}

{$IFDEF AT_COMMAND_SET}
  (* send initialization string to modem *)
  Flag := ModemSendTo(Port,5,'!!AT E1 S7=60 S11=60 V1 X1 Q0 S0=1!');
  if ModemWaitFor(Port,100,FALSE,'OK') then
    begin
      writeln; writeln('MODEM ready');
    end
  else writeln('WARNING: Expected OK not received');
{$ENDIF}


{$IFDEF SCRIPTS}
  if ParamCount = 3 then
  begin
    RetCode := Script(Port,ParamStr(3),False);
    if RetCode < 0 then SaySiErr(RetCode);
  end;
{$ENDIF}

  (* begin terminal loop *)
  writeln;
  writeln('Enter terminal loop ( Type ESC for menu )');
  WriteMsg(StatusMsg,40);
  LowVideo;
  while TRUE do
    begin (* while TRUE *)
      (* did user press Ctrl-BREAK ? *)
      if SioBrkKey then
        begin
          writeln('User typed Ctl-BREAK');
          RetCode := SioDone(Port);
          Halt;
        end;
      (* anything incoming over serial port ? *)
      RetCode := SioGetc(Port,1);
      if RetCode < -1 then MyHalt( RetCode );
      if RetCode > -1 then write(chr(RetCode));
      (* has user pressed keyboard ? *)
      if KeyPressed then
        begin (* keypressed *)
          (* read keyboard *)
          TheByte := ReadKey;
          (* quit if user types ESC *)
          if TheByte = chr($1b) then
            begin (* ESC *)
              WriteMsg(MenuMsg,1);
              ReadMsg(ResultMsg,32,1);
              c := UpCase(ResultMsg[1]);
              case c of
                'Q':  (* QUIT *)
                   begin
                     WriteLn;
                     WriteLn('TERMINATING: User pressed <ESC>');
                     RetCode := SioDone(Port);
                     Halt;
                   end;
                'P':  (* PROTOCOL *)
                   begin
                     WriteMsg('A)scii X)modem Y)modem ymodem-G): ',1);
                     ReadMsg(ResultMsg,35,1);
                     c := UpCase(ResultMsg[1]);
                     case c of
                       'A': (* ASCII *)
                          begin
                            Protocol := 'A';
                            (* setup ascii parameters *)
                            TermChar := $18; (* CAN or control-X *)
                            CharPace := 5;   (* 5 ms inter-byte delay *)
                            Timeout := 7;    (* timeout after 7 seconds *)
                            EchoFlag := TRUE;(* local echo *)
                            WriteMsg('Protocol = ASCII',1);
                          end;
                       'X': (* XMODEM *)
                          begin
                            Protocol := 'X';
                            OneKflag := FALSE;
                            NCGbyte := NAK;
                            BatchFlag := FALSE;
                            WriteMsg('Protocol = XMODEM',1);
                          end;
                       'Y': (* YMODEM *)
                          begin
                            Protocol := 'Y';
                            OneKflag := TRUE;
                            NCGbyte := Ord('C');
                            BatchFlag := TRUE;
                            WriteMsg('Protocol = YMODEM',1);
                          end;
                       'G': (* YMODEM-G *)
                          begin
                            Protocol := 'G';
                            OneKflag := TRUE;
                            NCGbyte := Ord('G');
                            BatchFlag := TRUE;
                            WriteMsg('Protocol = YMODEM-G',1);
                          end;
                     end; (* case *)
                     StatusMsg[6] := Protocol;
                     WriteMsg(StatusMsg,40)
                   end;
                'S': (* Send *)
                   begin
                     WriteMsg(GetNameMsg,1);
                     ReadMsg(Text40,16,20);
                     Filename := Text40;
                     if Length(FileName) = 0 then goto 500;
                     if Protocol = 'A' then
                       begin
                         (* Ascii *)
                         Flag := TxAscii(Port,Filename,Buffer,CharPace,TermChar,Timeout,EchoFlag);
                       end
                     else
                       begin
                         Filename := '';
                         if BatchFlag then Flag := YmodemTx(Port,Filename,Buffer,OneKflag)
                         else Flag := XmodemTx(Port,Filename,Buffer,OneKflag);
                       end
                     end; (* Send *)
                'R': (* Receive *)
                   begin
                     if Protocol = 'A' then
                       begin
                         (* Ascii *)
                         WriteMsg(GetNameMsg,1);
                         ReadMsg(Text40,16,20);
                         Filename := Text40;
                         if Length(FileName) = 0 then goto 500;
                         Flag := RxAscii(Port,Filename,Buffer,xyBufferSize,TermChar,Timeout,EchoFlag);
                       end
                     else
                       begin
                         Filename := '';
                         if BatchFlag then Flag := YmodemRx(Port,Filename,Buffer,NCGbyte)
                         else Flag := XmodemRx(Port,Filename,Buffer,NCGbyte);
                       end
                     end (* Receive *)
                   else WriteMsg('Bad response',1);
                   end; (* case *)
                   500:
                end; (* ESC *)
              (* send out over serial line *)
              RetCode := SioPutc(Port, TheByte );
              if RetCode < 0 then MyHalt( RetCode );
            end (* keypressed *)
      end (* while TRUE *)
end.
