Unit PCkSelfM;

{

 Programmer: Jim Nicholson

 Purpose: Implement a method for creating "self-modifying" .EXE files from
 TP which will survive the encoding techniques used by LZEXE and PKLite(tm).

 For discussion and examples, see SelfMod.Pas

 This unit contains code placed into the public domain, with the following
 provision:

 Please do not distribute modified versions of this code without indicating
 such modification by commenting the file.

 If you have questions, comments, modifications, or suggestions, please
 feel free to contact us:

              PCkS Associates
              138 Frances Place
              Hillside, NJ 07205

              On CompuServe, EasyPlex to    70152,332
              On Delphi                     CHICKENJN
              On GENie                      J.NICHOLSON1

}

interface

var
    ExeFileName : string[128];

function  ConfigBlockPresent(Size : integer)          : boolean;
function  NewConfigBlock(var C_B; Size : integer)     : boolean;
function  ReadConfigBlock(var C_B; Size : integer)    : boolean;
function  ConfigBlockRewrite(var C_B; Size : integer) : boolean;

implementation

Uses Dos;

const
    SelfModHeader : string[10] = 'PCkS SMODF';
    CtrlZ : char = ^Z;
var
    ExeFile: file;
    Buffer : string[10];

function ConfigBlockPresent(Size : integer) : boolean;
 begin
 assign(ExeFile,ExeFileName);
 reset(ExeFile,1);
 seek(ExeFile,
      FileSize(ExeFile)
      -(SizeOf(SelfModHeader)+Size+1));
 BlockRead(ExeFile,Buffer,SizeOf(SelfModHeader));
 if Buffer = SelfModHeader then
    ConfigBlockPresent := true
 else
    ConfigBlockPresent := false;
 close(ExeFile);
 end;

function NewConfigBlock(var C_B; Size : integer) : boolean;
 begin
 NewConfigBlock := false;
 if not ConfigBlockPresent(Size) then begin
     assign(ExeFile,ExeFileName);
     reset(ExeFile,1);
     Seek(ExeFile,FileSize(ExeFile));
     BlockWrite(ExeFile,SelfModHeader,SizeOf(SelfModHeader));
     BlockWrite(ExeFile,C_B,Size);
     BlockWrite(ExeFile,CtrlZ,1);
     close(ExeFile);
     NewConfigBlock := true;
     end;
 end;

function ReadConfigBlock(var C_B; Size : integer) : boolean;
 begin
 ReadConfigBlock := false;
 if ConfigBlockPresent(Size) then begin
     assign(ExeFile,ExeFileName);
     reset(ExeFile,1);
     seek(ExeFile,FileSize(ExeFile)-(Size+1));
     BlockRead(ExeFile,C_B,Size);
     close(ExeFile);
     ReadConfigBlock := true;
     end;
 end;

function ConfigBlockRewrite(var C_B; Size : integer) : boolean;
 var
     Temp : string;
 begin
 ConfigBlockRewrite := false;
 if ConfigBlockPresent(Size) then begin
     assign(ExeFile,ExeFileName);
     reset(ExeFile,1);
     seek(ExeFile,FileSize(ExeFile)-(SizeOf(SelfModHeader)+Size+1));
     BlockWrite(ExeFile,SelfModHeader,SizeOf(SelfModHeader));
     BlockWrite(ExeFile,C_B,Size);
     BlockWrite(ExeFile,CtrlZ,1);
     close(ExeFile);
     ConfigBlockRewrite := true;
     end;
 end;

begin
ExeFileName := ParamStr(0);
end.
