{SECTION ..PbSELECT }
UNIT PbSELECT;

INTERFACE

USES CRT, PbCRT, PbMISC, PbDATA, PbOBJS, PbHIGH, PbWIND;

{
Description:  Selection window stuff.

Author      : Howard Richoux
Date        : 12/18/90
Last revised: 1/12/94 Combined PbSELECT and FSELstuf
              2/18/94 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}



Procedure SetSelectWindow(xx0,xy0,xrows,xcols,xwidth : integer);
           {[CRT] Sets up window size}

Procedure SetSelectWindowLabels(xtoplabel,xbottomlabel : string);
           {[CRT] Sets up window labels}


Procedure Select(var items : STRA_object; var s : string; var n : integer;
                     var cmd : string);
           {[CRT] Displays items, returns selection}

Procedure SelectWText(var items,itemtexts : STRA_object;
                 var s : string; var n : integer; var cmd : string);
           {[CRT] Displays items and supporting text, returns selection}

Procedure SelectFile(Template : string; var s : string;
             var itemselect : integer; max,sortmode : integer; var cmd : string);
           {[CRT] Displays a list of files for choice, optional sorting }


{SECTION .zzImplementation }
IMPLEMENTATION



var wx0, wy0, rows, cols, wwidth, textwidth : integer;
var itemselect, dispmax, savebase, itembase, itemline  : integer;
var toplabel,bottomlabel   : string[60];


Procedure Normalize(count : integer;
                    var  itemselect,itembase,itemline : integer);
     begin
     if itemselect < 1 then itemselect := 1;
     if itemselect > count then itemselect := count;
     itembase := (itemselect div dispmax) * dispmax;
     itemline := itemselect mod dispmax;
     itemselect := itembase + itemline;
     if itemline < 1 then itemline := 1;
     end;


Procedure MakeSelectWindow(count : integer; var wndw : WINDOW_object);
var err,xcols,xrows : integer;
     begin
     savebase := -1;
     xcols := (cols*(wwidth+2)) + textwidth + 1;
     xrows :=  rows+2;
     wndw.init(wx0,wy0,wx0+xcols,wy0+xrows,0);
     wndw.setlabels(toplabel,bottomlabel);
     wndw.PopUp;
     wndw.smallwindow;
     Normalize(count,itemselect,itembase,itemline);
     end;



Procedure DisplayItems(var items,itemtext : STRA_object; itemselect : integer);
var i,j,k,l,x,y    : integer;
    selectstr      : string[3];
    s,s1,selectedname : string[70];
     begin
     if savebase <> itembase then clrscr;
     x := 1; y := 1;
     if items.count < 1 then
         begin
         writeln('Nothing to display.');
         writeln('');
         exit;
         end;
     PromptColor;
     for i := 1 to rows do
         begin
         for j := 0 to cols-1 do
              begin
              k := (i + j*rows) + itembase;
              if (k) <= items.count then
                   begin
                   selectstr := '   ';
                   s := items.fetchN(k);
                   if itemline=(k-itembase) then
                        begin
                        selectedname := leftstr(s,wwidth);
                        gotoxy(2+j*(wwidth+2),i);
                        EntryColor;
                        x := wherex;
                        y := wherey;
                        write(leftstr(s,wwidth));
                        PromptColor;
                        end
                   else begin
                        gotoxy(2+j*(wwidth+2),i);
                        write(leftstr(s,wwidth));
                        end;
                   if savebase <> itembase then
                        begin
                        s1 := itemtext.fetchN(k);
                        if (textwidth > 0 ) and (s <> '') then
                               write('  ',leftstr(s1,textwidth));
                        end;
                   end
              end;
         end;
     gotoxy(1,rows+1);write(' [',integerstr(itemselect,4),'] ');
     gotoxy(x,y);
     savebase := itembase;
     end;



Procedure SelectItem(var items,itemtext : STRA_object; var cmd : string;
                     var item : string; var itemnumber : integer);
var done  : boolean;
    s, CmdString : string[40];
     begin
     CmdString := cmd;
     itemselect := itemnumber;
     Normalize(items.count,itemselect,itembase,itemline);
     item := '';
     done := false;
     while not done do
          begin
          if (CmdString = '') or (CmdString = '?RESELECT') then
               begin
               DisplayItems(items,itemtext,itemselect);
               CmdString := '?RESELECT';
               GetKeyCmd(CmdString);
               end;

          if (CmdString = '?ESCAPE') then
               begin
               itemselect := 0;
               item := '';
               done := true;
               cmd := '?ESCAPE';
               end
          else if (CmdString = '?HOME')   then   itemselect := 1
          else if (CmdString = '?END')    then   itemselect := items.count
          else if (CmdString = '?UPARR')  then   itemselect := itemselect -1
          else if (CmdString = '?DOWNARR') then  itemselect := itemselect +1
          else if (CmdString = '?UP')      then
                                      itemselect := itemselect - dispmax
          else if (CmdString = '?DOWN')   then
                                      itemselect := itemselect + dispmax
          else if (CmdString = '?RIGHTARR')  then
                                      itemselect := itemselect + rows
          else if (CmdString = '?LEFTARR')  then
                                      itemselect := itemselect - rows
          else if (copy(CmdString,1,3) = '?FK')  then
               begin
               cmd := cmdstring;
               done := true;
               end
          else begin
               if itemselect < 1 then itemselect := 1;
               if itemselect > items.count then itemselect := items.count;
               cmd := '?SELECTED';
               done := true;
               end;
          CmdString := '?RESELECT';
          if itemselect <> 0 then
               begin
               Normalize(items.count,itemselect,itembase,itemline);
               item := items.fetchN(itemselect);
               end;
          end;
     if item = '' then itemselect := 0;
     itemnumber := itemselect;
     end;



{SECTION  SetSelectWindow }
Procedure SetSelectWindow(xx0,xy0,xrows,xcols,xwidth : integer);
     begin
     wx0    := xx0;
     wy0    := xy0;
     rows   := xrows;
     cols   := xcols;
     wwidth := xwidth;
     dispmax := rows * cols;
     end;



{SECTION  SetSelectWindowLabels }
Procedure SetSelectWindowLabels(xtoplabel,xbottomlabel : string);
     begin
     if xtoplabel <> '' then toplabel := xtoplabel;
     if xbottomlabel <> '' then bottomlabel := xbottomlabel;
     end;



{SECTION  Select }
Procedure Select(var items : STRA_object; var s : string; var n : integer;
                     var cmd : string);
var itemtext : STRA_object;
var wndw     : WINDOW_object;
     begin
     itemtext.init(items.count);
     itemselect := n;
     textwidth := 0;
     s := '';
     MakeSelectWindow(items.count, wndw);  { wndw will be initted here }
     cmd := '?RESELECT';
     DisplayItems(items,itemtext,n);
     SelectItem(items,itemtext,cmd,s,n);
     s := UpCaseStr(s);
     wndw.done;
     end;



{SECTION  SelectWText }
Procedure SelectWText(var items,itemtexts : STRA_object;
                 var s : string; var n : integer; var cmd : string);
var wndw     : WINDOW_object;
     begin
     itemselect := n;
     s := '';
     textwidth := 70-wwidth;
     MakeSelectWindow(items.count, wndw);  { wndw will be initted here }
     cmd := '?RESELECT';
     DisplayItems(items,itemtexts,n);
     SelectItem(items,itemtexts,cmd,s,n);
     s := UpCaseStr(s);
     wndw.done;
     end;




{SECTION  SelectFile }
Procedure SelectFile(Template : string; var s : string;
             var itemselect : integer; max,sortmode : integer; var cmd : string);
var files : STRA_object;
     begin
     files.init(max);
     GetFilesSTRA(Template, files,sortmode);
     Select(files,s,itemselect,cmd);
     files.done;
     end;



{SECTION  zPbSELECTInit }
Procedure zPbSELECTInit;
     begin
     textwidth := 0;
     savebase  := -1;
     toplabel       := ' Select Item ';
     bottomlabel    := ' (Esc/Enter/Arrows&Page) ';
     SetSelectWindow(5,5,8,4,12);
     end;



{SECTION  zzInitialization }
     begin {initialization}
     zPbSELECTInit;
     end.
