UNIT PbSCRN;

INTERFACE

uses PbMISC, PbOBJS, PbDDL;

{
Description : Decodes the screen.CRT file and updates the DDL

Author      : Howard Richoux
Date        : 2/6/94
Last revised: 2/18/94 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7
Status      : Placed in the Public Domain by HNR Software 1/94
Published in: none
}


var flds       : DDL_object;   { hold list of fields/lengths (if needed) }
var UsesStr    : string;     { slipped into the USES statement }


var txt        : STRA_object;  { 200 lines }
    image      : STRA_object;  { 25 lines - screen picture only }
    literals   : stra_object;  { 25 lines - screen/no data image }
    vars       : STRA_object;  { 50 lines - whole VAR lines }
    fields     : STRA_object;  { 50 lines - from var lines }

var DeclareData : boolean;     { tells SCRNGEN to declare the data variables }

var scrnwidth  : byte;
    scrnlength : byte;
    scrntoplabl : string[40];
    scrnbotlabl : string[40];


Procedure ProcessCRTFile(fn,sect : string; var flds : DDL_object);



{SECTION .ZIMPLEMENTATION }
IMPLEMENTATION


Procedure RemoveStuffFromString( stuff : string; var str : string);
var s : string;
    i : integer;
     begin
     i := 1;
     s := str;
     i := pos(stuff,s);
     while i > 0 do
          begin
          i := pos(stuff,s);
          if i > 0 then delete(s,i,length(stuff));
          end;
     str := s;
     end;


Function ExtractLabelStr( str : string) : string;
var s : string;
     begin
     s := str;
     {peel off the "|---...--"  and "----...--|"   whats left is the label}
     RemoveStuffFromString('--',s);
     RemoveStuffFromString('|-',s);
     RemoveStuffFromString('-|',s);
     RemoveStuffFromString('|',s);
     ExtractLabelStr := s;
     end;


Procedure ProcessVARline(str : string);
var s,s1,v,nam,opt : string;
    i          : integer;
    typ        : char;
    l,len,decp : byte;
     begin
     s := str;
     delete(s,1,3);
     RemoveLeading(s,' ');
     vars.append(s);
     nam := GetLeftStr(s,':');
     nam := UpCaseStr(nam);
     trim(nam);
     fields.append(nam);
     opt := ExtractDelimitedStr(s,'{','}');
     v := s;
     v := UpCaseStr(v);
     RemoveStuffFromString(';',v);
     RemoveStuffFromString(' ',v);
     if length(v) > 0 then
          begin
          decp := 0;
          typ := v[1];
          case typ of
               'I'   : begin
                       len := 2;
                       l   := 6;
                       end;
               'L'   : begin
                       len := 4;
                       l   := 8;
                       end;
               'R'   : begin
                       len := 4;
                       l   := 10;
                       end;
               'S'   : begin
                       s1 := GetDelimitedStr(v,'[',']');
                       len := strint(s1);
                       l   := len;
                       end;
                else   begin
                       end;
                end;
          end;

     i := flds.find(nam);
     if i = 0 then
          begin
          flds.append(nam,typ,len,decp);
          end;
     i := flds.find(nam);
     if i > 0 then flds.ddl[i].options := opt;
     end;


Procedure ProcessOPTIONline(str : string);
var s, opt, value : string;
     begin
     s := str;
     UpCaseStr(s);
     opt := GetLeftStr(s,'=');
     trim(opt);
     value := s; trim(value);
     if (opt='DECLARE') and (value='YES') then DeclareData := true;
     if (opt='USES') then UsesStr := ', '+value;
     end;


Procedure LoadScreenDef;
var i,j   : integer;
    done  : boolean;
    s,s1  : string;
     begin
     done := false;
     scrnwidth  := 0;
     scrnlength := 0;
     scrntoplabl := '';
     scrnbotlabl := '';
     i := 0;
     while (i < txt.count) and not done do
          begin
          inc(i);
          s := txt.fetchN(i);
          trim(s);
          if (s[1] = '|') and (s[length(s)] = '|') then
               begin
               image.append(s);
               scrnwidth := length(s);
               s1 := s;
               delete(s1,1,1);delete(s1,length(s1),1);
               patchstr(s1,'_',' ');
               RemoveTrailing(s1,' ');
               literals.append(s1);
               inc(scrnlength);
               end
          else if CompareUpL(s,'VAR',3) then
               begin
               ProcessVARline(s);
               end
          else begin
               j := pos('=',s);
               if j > 0 then ProcessOptionLine(s);
               end;
          end;
     if (scrnwidth  < 3)  then scrnwidth  := 3;
     if (scrnwidth  > 80) then scrnwidth  := 80;
     if (scrnlength > 25) then scrnlength := 25;
     if (scrnlength < 3)  then scrnlength := 3;
     s := image.fetchN(1);
     scrntoplabl := ExtractLabelStr(s);
     s := image.fetchN(image.count);
     scrnbotlabl := ExtractLabelStr(s);
     end;


Procedure UpdateDDLs(fnam : string; fldrow,fldcol,fldln : byte);
var i : integer;
     begin
     i := flds.find(fnam);
     if i > 0 then
          begin
          flds.ddl[i].r := fldrow;
          flds.ddl[i].c := fldcol;
          flds.ddl[i].l := fldln;
          end;
     end;


Procedure MatchNamesAndFields;
var i,j,k,fnum : integer;
    r,c,ln : byte;
    done   : boolean;
    s,nam  : string;
     begin
     vars.dump;
     fnum := 1;
     done := false;
     k := 1;
     while (k < image.count) and not done do
          begin
          inc(k);
          s := image.fetchN(k);
          trim(s);
          s := RemoveBrackets(s);
          j := pos('_',s);
          while (j > 0) do
               begin
               c := j; r := k; ln := 1;
               while s[j] = '_' do
                    begin
                    s[j] := '~';
                    ln := j - c;
                    inc(j);
                    end;
               UpdateDDLs(fields.fetchN(fnum),r-1,c-1,ln+1);
               inc(fnum);
               j := pos('_',s);
               end;
          end;
     end;




Procedure ProcessCRTFile(fn,sect : string; var flds : DDL_object);
     begin
     txt.loadsection(fn,'{SECTION',sect);
     LoadScreenDef;
     MatchNamesAndFields;
     end;





{SECTION  ZInitialization }
     begin {Initialization}
     scrnwidth   := 0;
     scrnlength  := 0;
     scrntoplabl := '';
     scrnbotlabl := '';
     txt.init     (200);
     image.init    (25);
     literals.init (25);
     vars.init     (50);
     fields.init   (50);
     declaredata := false;
     end.
