{SECTION ..PbOBJS }
UNIT PbOBJS;

INTERFACE

uses DOS, printer, PbMISC, PbDATA;

{
Description : HNR Object Library

Author      : Howard Richoux
Date        : 2/18/91
Last revised: 2/18/94 TFILE_object, BFILE_object, STRA_object
              2/18/94 INFO_object, LOOKUP_object
              2/18/94 OUT_object_0, OUT_object_1
Application : IBM PC and compatibles, done in Turbo Pascal 7
Status      : Placed in the Public Domain by HNR Software 2/18/1994
Published in: none
}


{SECTION .BFILE_object }

const BFILE_maxheader       = 1024;
type  BFILE_headerbuf_type  = array[1..BFILE_maxheader] of byte;
const BFILE_Bad_Recnum_ERR  = -5;
type  BFILE_RecToStringProc = procedure(var rec; var s : string);
type  BFILE_StringToRecProc = procedure(s : string; var rec);

TYPE  BFILE_object = OBJECT
             Fil      : file;
             filename : string[60];
             recsiz   : integer;
             opened   : boolean;
             position : longint;
             err      : integer;
             curr     : longint;
             hdrptr   : ^BFILE_headerbuf_type;
             hdrsiz   : integer;

             procedure init(fn : string; recsz,FMode : integer);
             procedure InitWithHdr(fn : string; recsz,hdsz,FMode : integer);
             Procedure open       (fn : string; create : boolean);
             Procedure SetHdrSiz  (hdsz : integer); { Mostly for reading, like DBF }
             Function  UpDateHeader   : boolean;    { Rewrites hdr buffer }
             Function  ReadHeader     : boolean;    { Reads file for hdr buffer }
             Function  IOResultErrChk : boolean;    { Checks IOResult, sets Err }
             Function  NoError        : boolean;    { Checks Err variable }
             Function  Count          : longint;    { Computes based on filesize }
             Procedure close;
             Procedure clearfile;
             Procedure refreshfile;

             Function  RecAddress(n : longint) : longint;  { Computes based on hdrsiz and recsiz }
             function  SeekN     (n : longint)          : boolean;  { First rec is rec #1 }
             function  fetchN    (n : longint; var rec) : boolean;  { Fetches recs 1.. count}
             function  storeN    (n : longint; var rec) : boolean;  { stores any n>0}
             function  fetchnext (var rec)              : boolean;  { inc(curr) and fetchN}
             Function  append    (var rec)              : boolean;  { stores count+1 }

             Procedure export (fn : string; workproc : BFILE_RecToStringproc;
                               var rec; purgedata : boolean);
             Procedure import (fn : string; workproc : BFILE_StringToRecproc;
                               var rec; purgedata : boolean);
             Procedure Dump;       { debugging aid }
             Procedure SmartDump;  { uses header & records -  debugging aid }
             Procedure done;
             end;




{SECTION .TFILE_object }

TYPE  TFILE_object = OBJECT
             Fil      : TEXT;
             filename : string[60];
             opened   : boolean;
             err      : integer;
             linenum  : longint;
             PosCurr  : longint;

             procedure init      (fn : string; create : boolean);
             procedure initAppend(fn : string);
             Procedure open      (fn : string; create : boolean);
             Function  IOResultErrChk : boolean;
             Procedure seek      (l : longint);
             function  currentposition : longint;
             Function  fetchnext(var s : string) : boolean;
             Function  append(s : string) : boolean;
             Procedure clearfile;
             Procedure refreshfile;
             Function  error    : boolean;
             Procedure close;
             procedure done;
             end;



{SECTION .STR_object }
type  stringptr = ^string;

TYPE  STR_object = OBJECT
             strptr: stringptr;                       { pointer to string on heap }
             Procedure   init;                        { gets heap space     }
             Function    store (st: String): boolean; { Stores the string   }
             Function    fetch: String;               { Fetches the string  }
             Procedure   dump;                        { debug write         }
             procedure   dispose;                     { releases heap space }
             end;



{SECTION .STRA_object }
const STRA_BigArrayMax = 15000;
type  STRA_BigArray = array[1..STRA_BigArrayMax] of STR_object;
{type  STRA_BigIndex = array[1..STRA_BigArrayMax] of integer;}

TYPE  STRA_object = OBJECT
             arrayptr    : ^STRA_BigArray;
             arraymax    : integer;
             arrayused   : integer;
             arraysorted : boolean;
             modified    : boolean;
             Procedure init         (max : integer);
             Function  append       (st : string)              : boolean;
             Function  appendpush   (st : string)              : boolean;
             Function  insertstr    (n : integer;st : string)  : boolean;
             Function  deletestr    (n : integer)              : boolean;
             Function  linearfind   (st : string)              : integer;
             Function  linearsearch (st : string; mode : byte) : integer;
             Function  storeN       (n : integer; st : string) : boolean;
             Function  fetchN       (n : integer) : string;

             Function  fetchString  (n : integer) : string;  {returns nth string as itself}
             Function  fetchInteger (n : integer) : integer; {returns nth string as integer}
             Function  fetchLongInt (n : integer) : longint; {returns nth string as longint}
             Function  fetchreal    (n : integer) : real;    {returns nth string as real}
             Function  fetchboolean (n : integer) : boolean; {returns nth string as boolean}

             Function  count        : integer; { returns number of slots used }
             Function  sorted       : boolean; { returns whether sorted }
             Function  arraymaxsize : integer; { returns max (from init)}
             Procedure dump;                   { for debugging }
             Procedure clear;                  { empties array }

             Procedure listpage   (f,n,w : integer);           { mini dump for text windows }
             Procedure save       (fname : string);            { to text file }
             Procedure load       (fname : string);            { from text file }
             Procedure loadsection(fname,sectiontag,sectionname : string); { from text file }

             Procedure swap(i,j : integer);                    { for sort }
             Procedure sort;                                   { shell sort}
             Function  binsearchEQ    (st : string) : integer; { if sorted }
             Function  binsearchAPPROX(st : string) : integer; { if sorted }
             Function  binsearchLE    (st : string) : integer; { if sorted }
             Function  binsearchGE    (st : string) : integer; { if sorted }

             Function  find   (st : string) : integer;              { sorted or not }
             Function  search (st : string; mode : byte) : integer; { sorted or not }
             Procedure done;
             end;


{SECTION .INFO_object }
type  INFO_object = object
          infoheader         : STR_object;
          keystring,keyvalue : STRA_object;
          sepchar            : char;      { separator between key and value ';' }
          sortmode,sorted    : boolean;
          CONSTRUCTOR init(max : integer);
          Function  count                     : integer;
          Function  arraymaxsize              : integer;

          Function  storeheader (s : string) : boolean;
          Function  fetchheader : string;
          Function  store        (ks,kv : string) : boolean;
          Function  fetch        (ks : string)    : string;
          Function  FetchString  (ks : string) : string;
          Function  FetchInteger (ks : string) : integer;
          Function  Fetchreal    (ks : string) : real;
          Function  FetchLongInt (ks : string) : longint;
          Function  FetchBoolean (ks : string) : boolean;
          Function  fetchkeyn    (n : integer)   : string;   { fetch nth key}
          Function  fetchn       (n : integer)    : string;  { fetch nth item}
          Function  search       (ks : string; mode : byte) : string;
          Procedure load         (fname : string);
          Procedure save         (fname : string);
          Procedure swap         (i,j  : integer);
          Procedure setsortmode  (flag : boolean);
          Procedure setsepchar   (sep  : char);
          Procedure sort;
          Procedure dump;
          Procedure clear;
          Procedure done;
          end;


{SECTION .LOOKUP_object }
type LOOKUP_object = object
        hold : INFO_object;

        Procedure init(num : integer);
        Procedure append(tag,str : string);
        Function  lookup (tag : string) : string;
        Function  fetchN(n : integer) : string;
        Procedure done;
        Procedure dump;
        end;


{SECTION .HOLD_object }
const HOLD_BigIndexMax = 5000;   { find out real limits - hnr 1/94 }

type  HOLD_NumType     = longint;
type  HOLD_NdxType     = integer;
type  HOLD_BigIndex    = array[1..HOLD_BigIndexMax] of HOLD_NumType;


TYPE  HOLD_object = OBJECT(STRA_object)
        ArrNum     : ^HOLD_BigIndex;
        ArrHighVal : HOLD_NumType;
        MaxEntries : HOLD_NdxType;

        comment    : string[80];

        CONSTRUCTOR init   (n : HOLD_NdxType);
        Function  append   (                st :string;     Num :HOLD_NumType): Boolean;
        Function  storeN   (n : HOLD_NdxType;    st :string;     Num :HOLD_NumType): Boolean;
        Function  fetchN   (n : HOLD_NdxType;var st :string; var Num :HOLD_NumType): Boolean;
        Function  fetchNumN(n : HOLD_NdxType)   : HOLD_NumType;
        Function  fetchStrN(n : HOLD_NdxType)   : string;

        Function  findstr  (st  : string)    : HOLD_NdxType;
        Function  findnum  (Num : HOLD_NumType)   : HOLD_NdxType;

        Function  count                    : HOLD_NdxType;
        Function  HighNum                  : HOLD_NumType;
        Procedure swap     (i,j : HOLD_NdxType);
        Procedure sort;
        Procedure dump;
        Procedure dumpN    (n : HOLD_NdxType);
        Procedure save     (fname : string);
        Procedure load     (fname : string);
        Procedure done;
        end;



{SECTION .OUT_objects }

const OUT_typCRT  = 1;
      OUT_typPRT  = 2;
      OUT_typFIL  = 3;
      OUT_typNUL  = 4;

      OUT_typAPPEND  = 0;     { append to existing file }
      OUT_typREWRITE = 1;     { rewrite file }

type OUT_object_0 = OBJECT        { basic functionality }
       DevTyp    : byte;        { typCRT }
       app       : byte;        { typAPPEND }
       f         : TEXT;
       fname     : string[40];  { '' - file name }
       plen      : integer;     { 24 - lines per page }
       llen      : integer;     { 79 - chars per line }
       currllen  : integer;     { llen - changed with indenting and offset }
       currline  : integer;     { 1  - current line number }
       currpage  : integer;     { 1  - current page number }
       loff      : byte;        { 0  - line offset for everything}
       indent    : byte;        { 0  - line indent for data, beyond offset }
       linesprinted : longint;  { 0  - only data lines, no headers ...}
       linesmax  : longint;     { 999999 - print line limit }

       opened    : boolean;     { false - false if open failed }
       err       : integer;     { 0     - holds error number }
       nopause   : boolean;     { false - don't pause if CRT }
       noprint   : boolean;     { false - suppress actual I/O while true }
       loffstr   : string;      { ''    - pad at left of line }
       indentstr : string;      { ''    - pad at left of line }

       compressed     : boolean;     { true   - laser Esc seq. }
       landscape      : boolean;     { false  - laser Esc seq. }
       PrinterInitted : boolean;

       Procedure init(fn: string; dtyp, append : byte;
                      pl, lw : integer; off : byte);
       Procedure LISTInit(fn: string; append : byte);  { simplified }
       Procedure LISTOpen;              { Do the actual OPEN i/o }
       Procedure ResetCounts;
       Procedure SetOffSet( i : byte);  { left margin }
       Procedure SetIndent( i : byte);  { left margin }
       Procedure SetNoPause;            { don't pause at e.o.p if CRT }
       Procedure SetCompressed;         { sets flag for InitPrinter }
       Procedure SetLandscape;          { sets flag for InitPrinter }
       Procedure pause;                 { wait for key if CRT }
       Procedure formfeed;              { <ff> if printer, pause if CRT }
       Procedure OutHeader;             { basicly dummy routine }
       Procedure OutFooter;             { basicly dummy routine }
       Procedure OutERRNoCR(s : string);{ no CR/LF, no bookkeeping }
       Procedure OutERR(s : string);    { actual write }
       Procedure Out(s : string);       { with bookkeeping }

       Procedure DoneWithPage;
       Procedure done;

       Procedure InitPrinter;                            { *private* }
       Procedure HandleFName(fn: string; append : byte); { *private* }
       end;



type OUT_object_1 = OBJECT(OUT_object_0)    { fancy }
       alldone      : boolean;     { false }
       header1spec  : string[50];  { page header def '||@PAGE'}
       header2spec  : string[30];  { second line def ''}
       header3spec  : string[30];  { third       def ''}
       footer2spec  : string[30];  { above the footer line  def '' }
       footer1spec  : string[50];  { page footer def ''}
       pagelabel1   : string[40];  { misc string @LABEL1 }
       pagelabel2   : string[40];  { misc string @LABEL2 }
       pagelabel3   : string[40];  { misc string @LABEL3 }

       joinflag     : boolean;     {number of lines to join   }
       joinwidth    : integer;     {point to break lines      }
       joinlinehold : string;      {holding area for leftovers}


       Procedure LISTInit(fn: string; append : byte);  { simplified }
       Procedure init(fn: string; dtyp, append : byte;
                                  pl, lw : integer; off : byte);
       Procedure SetHeaders(h1spec,h2spec,h3spec,f1spec,f2spec : string);

       Procedure Out(s : string);     { with bookkeeping }
       Procedure OutHeader;           { fancy }
       Procedure OutFooter;           { fancy }

       Procedure DoneWithPage;        { to get Footers }
       Procedure done;                { to get Footers }

       Procedure FlushJoin(joindone : boolean);
       Procedure OutJoin(line : string);

       {Private methods}
       Function  SpecialStr(str : string) : string;
       Function  FmtHeaderPiece(spec : string) : string;
       Function  pFmtHeader(spec : string; width : integer) : string;
       end;




{SECTION .zIMPLEMENTATION }
IMPLEMENTATION

{$I objBFILE.inc }

{$I objTFILE.inc }

{$I objSTRA.inc }

{$I objINFO.inc }

{$I objHOLD.inc }

{$I objOUT.inc }

{SECTION _Initialization }
     begin {Initialization }
     end.
