PROGRAM SKEL3;

{$M 20000,0,655000}

Uses DOS, PbCRT, PbMISC, PbDATA, PbPARMS, PbOUT0;

{
Description : Skeleton for CRT Interactive program

Author      : Howard Richoux
Date        : 12/9/93
Last revised: 12/15/93 hnr cleanup
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      :
Published in: none

Intended Use:
     Simple NON-page mode use of CRT.  Prompt is placed on screen
and commands are accepted until <quit> or whatever. NO Function keys
are implemented.  First use of this mode is TP, my own 'IDE'.

Commands can also be accepted from a command file @<fname>

SKEL3a will start here and go on farther.

Config Parameters        meaning                      Default
PROMPT=xxxx              CRT prompt string            '->'
}


const typInputCRT = 1;          { Commands are coming from keyboard }
const typInputFIL = 2;          { Commands are coming from file }

var   prompt    : string;       { Interactive mode prompt }
var   InputType : integer;

{*****************************************************************}

Procedure GetCRTInput(prompt : string; var s,cmd : string);
     begin
     write(prompt);
     GetKeyInput(s,cmd);
     writeln('');
     end;


Procedure ProcessInput(var str,cmd : string);
     begin
     writeln('     str=[',str,']   cmd[',cmd,']');
     end;


Procedure MainInputLoop;
var str,cmd : string;
var i     : integer;
     begin
     i := 0; str := ''; cmd := '?STRING';
     while (cmd <> '?EXIT') and (cmd <> '?ESCAPE') do
          begin
          case InputType of
                 typInputCRT : GetCRTInput(prompt,str,cmd);  {SEE PbCRT}
                 typInputFIL : begin
                               writeln('FILE input not implemented yet.');
                               exit;
                               end
                 else          begin
                               writeln('MAIN Input loop - bad input type [',
                                        InputType,']');
                               cmd := '?ESCAPE';
                               end;
                 end;
          ProcessInput(str,cmd);
          inc(i); if i > 100 then cmd := '?ESCAPE';   {safety valve}
          end;
     end;


Procedure Init;
var s : string;
     begin
     InputType := typInputCRT;     {Note. File input not yet implemented }
     AddParm(1,'PROMPT','->');     {default}

     StandardOUTInit;

     prompt   := GetParmStr('PROMPT');
     end;


(*  Main program *)
     BEGIN
     pProgID := 'SKEL3 1.02';
     writeln(' ( Escape to quit ) ');
     writeln('');
     Init;
     MainInputLoop;
     OUTdone;
     end.


