Program DUMPProg;

{$M 20000,0,50000}

uses PbMISC, PbDATA, PbOBJS, PbOUT0, PbPARMS;

{
Description:  Simple Hex/ASCII File Dump

Author      : Howard Richoux
Date        : 10/10/90
Last revised: 11/18/93  new PbPARMS initializations
              12/25/93  hnr change to PbOUT
               1/16/94  hnr 2.00 BFILE_object
               2/18/94  hnr 2.02 new libraries
               2/22/94  hnr 2.04 moved header buffer to HEAP
               4/30/94  hnr 2.05 error -5 on last partial buffer
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

Idiosyncrasy, logic checking on pFirst gets it set to 1.  Record numbering
starts with 0 on files with no header, so to get all records, pFirst checking
is ignored for records 0 and 1.  Otherwise, it should be consistant.

}



var  X : BFILE_object;

var   recsread     : longint;
var   addr         : longint;
var   HexAddrFlag  : boolean;  {true = HEX false=DEC - mode for addr display }

var   RecSize      : integer;
var   HdrSize      : integer;
var   reclineflag  : boolean;
var   hdrlineflag  : boolean;
var   DBFFlag      : boolean;


Function ThisIsDBFFile(fn: string;var hsiz,rsiz : integer) : boolean;
var f   : BFILE_object;
    buf : array[1..4095] of byte;
    hs,rs : integer;
     begin
     hs := 0;
     rs := 0;
     f.init(fn,32,fOPENSHARE);
     f.fetchN(0,buf);
     if f.NoError then
          begin
          if (buf[1] = $03) or (buf[1] = $83) then { dBase version #s }
               begin
               move(buf[9],hs,2);
               move(buf[11],rs,2);
              { OUT('rec size = ',rs+'   hdr size=',hs);}
               end;
          end;
     f.done;
     hsiz := hs;
     rsiz := rs;
     ThisIsDBFFile := (hs > 0);
     end;


Function OpenAsDBFFile(fn : string; var f : BFILE_object) : boolean;
var rs,hs  : integer;
     begin
     rs := 0;
     hs := 0;
     if ThisIsDBFFile(fn,hs,rs) then
          begin
          f.initWithHdr(fn,rs,hs,fOPENSHARE);
          end
     else OUT('This is not a DBF file ['+fn+']');
     OpenAsDBFFile := f.opened;
     end;


procedure SmartDump;
var l : longint;
    results : integer;
    rbuf : array[1..4096] of byte;
    zbuf : array[1..16] of byte;
    i    : integer;
    j,filsz,reccount    : longint;
    skipit : boolean;
     begin
     l := 0;
     if not X.opened then exit;
     filsz := filesize(X.fil);
     OUT(' ');
     OUT('Dump: '+X.filename+
             '  Size:'+longintstr(filsz,9));
     OUT('              HdrSiz:'+integerstr(X.hdrsiz,4)+
             '  RecSiz:'+integerstr(X.recsiz,4)+
             '  Recs:'+longintstr(X.count,8));
     if (X.hdrsiz > 0) and (X.hdrptr <> NIL) then
          begin
          X.ReadHeader;
          if X.NoError then
               begin
               i := 1;
               if hdrlineflag then OUT('Header - size='+ integerstr(X.hdrsiz,4));
               while i < X.hdrsiz do
                   begin
                   move(X.hdrptr^[i],zbuf,16);
                   OUT(Buf16ToHexStr(i,((X.hdrsiz-i)+1),zbuf,HexAddrFlag));
                   i := i + 16;
                   end;
               if X.hdrsiz > 16 then OUT(' ');
               end
          else OUT('Read Header error '+integerstr(X.err,4));
          end;
     j := 0;
     reccount := X.count;
     if (reccount = 0) and (filsz > 0) then reccount := 1;
     while j < reccount do
          begin
          skipit := false;
          if (pFirst > 1) and (j < pFirst) then skipit := true
          else if recsread > pLast then exit;

          fillchar(rbuf,sizeof(rbuf),0);
          X.fetchN(j,rbuf);
          if X.NoError then
               begin
                    inc(recsread);
               if not skipit then
                    begin
                    i := 1;
                    if reclineflag then
                         OUT('Record - '+integerstr(j,5)+'    size='+
                              integerstr(X.recsiz,4));
                    while i < X.recsiz do
                        begin
                        move(rbuf[i],zbuf,16);
                        if X.recsiz > 16 then
                             OUT(Buf16ToHexStr(i,((X.recsiz-i)+1),zbuf,HexAddrFlag))
                        else OUT(Buf16ToHexStr(X.RecAddress(j),16,zbuf,HexAddrFlag));
                        i := i + 16;
                        end;
                    if X.recsiz > 16 then OUT(' ');
                    end;
               end
          else begin
               OUT('Fetch error '+integerstr(X.err,4));
               end;
          inc(j);
          end;
     end;


Procedure DoDump;
var RSiz, HSiz : integer;
    filsz : longint;
     begin
     if RecSize > 16 then reclineflag := true;
     if HdrSize > 0  then hdrlineflag := true;
     if DBFFlag then
          begin
          if ThisIsDBFFile(pCurrFName,RSiz,HSiz) then
               begin
               OUT('Interpreting this file as an xBase DBF file');
               reclineflag := true;
               hdrlineflag := true;
               OpenAsDBFFile(pCurrFName,X);
               end
          else begin
               OUT('This file is NOT a valid xBASE DBF file. Header(?):');
               pfirst := 1; pcount := 4;
               X.InitWithHdr(pCurrFName, 16,0, fOPENSHARE);
               end;
          end
     else if HdrSize > 0 then
          begin
          X.InitWithHdr(pCurrFName, RecSize, HdrSize, fOPENSHARE);
          end
     else begin
          X.Init(pCurrFName, RecSize, fOPENSHARE);
          filsz := filesize(X.fil);
          if RecSize > filsz then RecSize := trunc(filsz);   { very short files}
          X.done;
          X.Init(pCurrFName, RecSize, fOPENSHARE);
          end;
     SmartDump;
     X.done;
     end;


Procedure DUMPProgInit;
var chunk : integer;
     begin
     recsread    := 0;
     reclineflag := false;
     hdrlineflag := false;

     AddParm(1,'COMPRESSED','YES');
     AddParm(1,'HEX','YES');
     AddParm(1,'DBF','NO');
     AddParm(1,'RECSIZE','16');
     AddParm(1,'HDRSIZE','0');
     AddParm(1,'FIRST','0');

     StandardOUTInit;

     HexAddrFlag := CheckOK('HEX');
     DBFFlag     := CheckOK('DBF');
     RecSize     := GetParmNum('RECSIZE');
     HdrSize     := GetParmNum('HDRSIZE');
     if pDEBUG then
          OUT('first,last,count '+ integerstr(pfirst,5) +'  '+
                              integerstr(plast,5) +'  '+
                              integerstr(pcount,5));
     end;


     begin {initialization}
     pProgID := 'DUMP 2.05';
     DUMPProgInit;
     if paramcount > 0 then pCurrFName := UpCaseStr(paramstr(1));
     if pCurrFName[1] <> '<' then
          begin
          if fileexists(pCurrFName) then DoDUMP
          else writeln('Unable to find file: ',pCurrFName);
          end
     else begin
          ShowDocFile;
          end;
     OUTdone;
     end.
