PROGRAM DIRS;

{$M 20000,0,50000}

Uses DOS, CRT, PbMISC, PbDATA, PbOBJS, PbOUT0, PbPARMS;

{
Description : DIRS - Root level DIRS, summary & size

Author      : Howard Richoux
Date        : 12/10/93
Last revised: 12/21/93 hnr 1.02 minor changes
               2/18/94 hnr 1.03 new libraries
               5/4/94  hnr 1.05 DIRS c:\pb gets subdirs
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

}


const debug = 0;

var err      : byte;
    dirlist  : STRA_object;
    outp     : STRA_object;
    rootstr  : string;

type dir_rec = record
      cnt      : longint;
      bytes    : longint;
      lasttime : longint;
      end;

var  dir     : dir_rec;
var  tot     : dir_rec;

{ SearchRec - for reference
    type searchrec = record
           fill  : array[1..21] of byte;
           attr  : byte;
           time  : longint;
           size  : longint;
           name  : string[12];
           end;
}



{*****************************************************************}


Procedure Logdir( var sr : SearchRec; p : pathstr);
var s : string;
     begin
     if sr.attr <> directory then exit;
     if debug > 0 then
          OUT('D-->'+ FullFmtSearchRec(sr,p));
     if (sr.name <> '.') and (sr.name <> '..') then
          dirlist.append(p+sr.name);
     end;


Procedure LogFile( var sr : SearchRec; p : pathstr);
var s : string;
     begin
     inc(dir.cnt);
     inc(tot.cnt);
     dir.bytes := dir.bytes + sr.size;
     tot.bytes := tot.bytes + sr.size;
     if dir.lasttime < sr.time then dir.lasttime := sr.time;
     if tot.lasttime < sr.time then tot.lasttime := sr.time;
     end;


Function FmtDirRec(filespec : string; d : dir_rec) : string;
var s,s1,fl : string;
     begin
     fl := '(' + longintstr(d.cnt,6) + ')';
     removeblanks(fl);
     s1 := filespec;
     s := ExtractPath(s1); { extract path and discard }
     s := leftstr(s1,8) +
          leftstr(fl,7) +
          rightstr(FmtKstrComma(d.bytes),8) + '  ' +
          leftstr(FmtPDateStr(d.lasttime),8);
     FmtDirRec := s;
     end;


Procedure PrintIt;
var i,j,k : integer;
    begin
    if outp.count > 110 then OUTSetCompressed;
    j := outp.count;
    if j < 1 then
         begin
         OUT('Directory output Empty');
         exit;
         end;
    if (((j div 2) * 2) <> j) then outp.append(' '); { make even # lines}
    j := outp.count div 2;
    for i := 1 to j do
         begin
         OUT(leftstr(outp.fetchN(i),34)+' | '+
               leftstr(outp.fetchN(i+j),34));
         end;
    OUT(' ');
    OUT(FmtDirREc('TOTAL',tot));
    end;


Procedure GoDownOnePath(filespec : string);
     begin
     fillchar(dir,sizeof(dir),0);
     if debug > 0 then OUT('-->GoDownOnePath ['+filespec+']');
     SearchEngineAll(filespec+'\','*.*',anyfile,LogFile,Err);
     outp.append(FmtDirREc(filespec,dir));
     end;


Procedure GoDownEachPath;
var i : integer;
     begin
     if dirlist.count < 1 then exit;
     fillchar(tot,sizeof(tot),0);
     fillchar(dir,sizeof(dir),0);

     SearchEngine(rootstr,anyfile,LogFile,err); {root}
     outp.append(FmtDirREc('(ROOT)',dir));

     i := 1;
     while (i <= dirlist.count) do
          begin
          if keypressed then exit;
          GoDownOnePath(dirlist.fetchN(i));
          inc(i);
          end;
     end;


Procedure GetRootDirs;
     begin
     writeln('Now you can use "DIRS \WINDOWS" , "DIRS \PB" , ... also.');
     OUT('root = [ '+rootstr+' ]');
     dirlist.init(200);
     outp.init(200);
     SearchEngine(rootstr,directory,LogDir,err);
     if debug > 0 then dirlist.dump;
     end;


Procedure Init;
var s : string;
     begin
     AddParm(1,'ROOT','c:\*.*');
     StandardOUTInit;
     rootstr := GetParmStr('ROOT');

     if paramcount > 0 then
          begin
          s := UpCaseStr(paramstr(1));
          if (s[1] <> '?') and (s <> 'P') then rootstr := s;
          end;
     if rightstr(rootstr,3) <> '*.*' then
          begin
          rootstr := AddBackSlash(rootstr);
          rootstr := rootstr + '*.*';
          end;
     end;


Procedure Shutdown;
     begin
     dirlist.done;
     outp.done;
     OUTDone;
     end;


(*  Main program *)
     BEGIN
     pProgID := 'DIRS 1.05';
     Init;
     GetRootDirs;
     dirlist.sort;
     GoDownEachPath;
     PrintIt;
     Shutdown;
     end.


