{SECTION ..PbOUT0 }
UNIT PbOUT0;

INTERFACE

uses PbMISC, PbDATA, PbOBJS, PbPARMS;


{
Description : Medium level Use of OUT_object

Author      : Howard Richoux
Date        : 12/24/93
Last revised:  2/18/94 changed libraries
Application : IBM PC and compatibles, done in Turbo Pascal 7
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none

     OUT is a shell around the OUT_object so that calling
programs don't have to worry about a lot of the details.  They
also don't get much control, just the pre-open variables set
in the program and through PARMS.

Through the variables are options for CON/LPT1/file output,
     compressed & landscape printing, headers and footers.

Use is:
          StandardOUTInit;
          ...
          OUT(<string>);
          ...
          OUTdone;

Use PbOUT0 for simple output, PbOUT1 for Headers/footers/ ...
}

var pCompressed : boolean;
var pLandscape  : boolean;


Procedure OUT(s:string);
             {[OUT] Outputs a string }

Procedure OUTChangeAPPEND(fn : string);
             {[OUT] Closes current output file/dev opens a new one APPEND }

Procedure OUTChangeREWRITE(fn : string);
             {[OUT] Closes current output file/dev opens a new one CLEARING contents }

Function  OUTcompressed : boolean;
             {[OUT] Returns true if output compressed }

Function  OUTCurrentLineLen : integer;
             {[OUT] Returns current line length }

Function  OUTcurrentPage : integer;
             {[OUT] Returns current page number }

Procedure OUTdone;
             {[OUT] Closes output device }

Procedure OUTdoneWithPage;
             {[OUT] Next line will go on new page }

Function  OUTLinesLeft : integer;
             {[OUT] lines left on current page }

Procedure OUTNoCR(s:string);
             {[OUT] Outputs a string - NO CR/LF }

Procedure OUTSetCompressed;
             {[OUT] Go to Compressed print }

Procedure OUTSetHeaders(h1,h2,h3,f1,f2 : string);
             {[OUT] Dummy to make it easier to switch to PbOUT0 }

Procedure OUTSetIndent( i : integer);
             {[OUT] Extra left space }

Procedure OUTSetLandscape;
             {[OUT] Go to Landscape Mode }

Procedure OUTSetLengths(ll,pl : integer);
             {[OUT] Manual override }

Procedure OUTSetNoPause;
             {[OUT] Cancels pausing on CRT output }

Procedure OUTSetNoPrint;
             {[OUT] Suppress output, keep bookkeeping }

Procedure OUTSetPrint;
             {[OUT] Turn printing back on. }

Procedure OUTPause;
             {[OUT] Pauses if CRT output. }

Procedure StandardOUTInit;
             {[OUT] Support for PbOUT; calls StandardpVarsInit }


{ extra utility procs using PbOUT0 basic calls }

Procedure OUTDOSErr(s : string; e : integer);
             {[OUT] Outputs a line containing the DOS error message}


{SECTION .ZIMPLEMENTATION }
IMPLEMENTATION

var Outp        : OUT_object_0;

{SECTION  AddOUTpVars }
Procedure AddOUTpVars;
     begin
     AddParm(1,'COMPRESSED','NO');
     AddParm(1,'LANDSCAPE','NO');
     end;


{SECTION  GetOUTpVars }
Procedure GetOUTpVars;
     begin
     pCompressed := CheckOK('COMPRESSED');
     pLandscape  := CheckOK('LANDSCAPE');
     end;


{SECTION  OUT }
Procedure OUT(s:string);
     begin
     Outp.out(s);
     end;


{SECTION  OUTChangeAPPEND }
Procedure OUTChangeAPPEND(fn : string);
             {[OUT] Closes current output file/dev opens a new one APPEND }
     begin
     Outp.done;
     pOutFile := fn;
     OUTp.LISTinit(pOutFile,OUT_typAPPEND);
     if pCompressed then OUTp.SetCompressed;
     if pLandscape  then OUTp.SetLandscape;
     OUTp.LISTopen;
     end;


{SECTION  OUTChangeREWRITE }
Procedure OUTChangeREWRITE(fn : string);
             {[OUT] Closes current output file/dev opens a new one CLEARING contents }
     begin
     Outp.done;
     pOutFile := fn;
     OUTp.LISTinit(pOutFile,OUT_typREWRITE);
     if pCompressed then OUTp.SetCompressed;
     if pLandscape  then OUTp.SetLandscape;
     OUTp.LISTopen;
     end;



{SECTION  OUTCompressed }
Function  OUTcompressed : boolean;
     begin
     OUTCompressed := Outp.compressed;
     end;


{SECTION  OUTCurrentLineLen }
Function  OUTCurrentLineLen : integer;
     begin
     OUTCurrentLineLen := Outp.currllen;
     end;


{SECTION  OUTCurrentPage }
Function  OUTCurrentPage : integer;
     begin
     OUTCurrentPage := Outp.currpage;
     end;


{SECTION  OUTdone }
Procedure OUTdone;
     begin
     Outp.done;
     end;


{SECTION  OUTdoneWithPage }
Procedure OUTdoneWithPage;
     begin
     Outp.DoneWithPage;
     end;


{SECTION  OUTLinesLeft }
Function  OUTLinesLeft : integer;
             {[OUT] lines left on current page }
     begin
     OUTLinesLeft := (Outp.plen - Outp.currline) + 1;
     end;


{SECTION  OUTNoCR }
Procedure OUTNoCR(s:string);
     begin
     Outp.outERRNoCR(s);  { no CR/LF and no bookkeeping }
     end;



{SECTION  OUTPause }
Procedure OUTPause;
     begin
     Outp.pause;
     end;


{SECTION  OUTSetCompressed }
Procedure OUTSetCompressed;
     begin
     Outp.SetCompressed;
     end;


{SECTION  OUTSetHeaders }
Procedure OUTSetHeaders(h1,h2,h3,f1,f2 : string);
     begin
     { dummy call }
     end;


{SECTION  OUTSetIndent }
Procedure OUTSetIndent( i : integer);
     begin
     Outp.SetIndent(i);
     end;


{SECTION  OUTSetLandscape }
Procedure OUTSetLandscape;
     begin
     Outp.SetLandscape;
     end;


{SECTION  OUTSetLengths }
Procedure OUTSetLengths(ll,pl : integer);
     begin
     Outp.llen := ll;
     Outp.plen := pl;
     end;


{SECTION  OUTSetNoPause }
Procedure OUTSetNoPause;
     begin
     Outp.SetNoPause;
     end;


{SECTION  OUTSetNoPrint }
Procedure OUTSetNoPrint;
     begin
     Outp.noprint := true;
     end;


{SECTION  OUTSetPrint }
Procedure OUTSetPrint;
     begin
     Outp.noprint := false;
     end;


{SECTION  StandardOUTInit }
Procedure StandardOUTInit;
     begin

     StandardpVarsInit;    { Picks up the other pVars as well }
     GetOUTpVars;          { OUT specific pVars }

     if ScanParms('P') then pOutFile := 'LPT1';

     OUTp.LISTinit(pOutFile,OUT_typAPPEND);
     if pCompressed then OUTp.SetCompressed;
     if pLandscape  then OUTp.SetLandscape;
     OUTp.LISTopen;
     end;


{SECTION  OUTDOSErr }
Procedure OUTDOSErr(s : string; e : integer);
{[OUT] Outputs a line containing the DOS error message}
     begin
     OUT(s+' '+DOSErrStr(e));
     end;


{SECTION  zPbOUTInit }
Procedure zPbOUTInit;
     begin
     pCompressed := false;
     pLandscape  := false;
     AddOUTpVars;          { OUT specific pVars }
     end;



{SECTION  zzInitialization }
     begin {initialization}
     zPbOUTInit;
     end.
