{SECTION ..PbLJII }
UNIT PbLJII;

{
Description:  LaserJet II Escape sequences

Author      : Howard Richoux
Date        : 1/21/91
Last revised: 11/8/93 - added Envelope Printing stuff
Application : IBM PC and compatibles, done in Turbo Pascal 5.5
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}

INTERFACE

Function LJIICmd(n : integer) : string;

Function LJIICmdText(n : integer) : string;


IMPLEMENTATION

Function LJIICmd(n : integer) : string;
var s : string;
     begin
     case n of
         0    : s := #27 + 'E';       {RESET}
         1    : s := #27 + '&k2S';    {132 col compressed mode}
         2    : s := #27 + '&l0O';    {Portrait mode}
         3    : s := #27 + '&l1O';    {Landscape mode}
         4    : s := #27 + '(10U';    {IBM PC char set}
         5    : s := #27 + '&k0S';    {10 CPI}
         6    : s := #27 + '&k4S';    {12 CPI}
         7    : s := #27 + '&l0H';    {FormFeed}
         8    : s := #27 + '&l2H';    {Manual Feed}
         9    : s := #27 + '&l81A';   {Legal Env size}
         else   s := '';
         end;
     LJIICmd := s;
     end;

Function LJIICmdText(n : integer) : string;
var s : string;
     begin
     case n of
         0    : s := 'RESET';
         1    : s := '132 col compressed mode';
         2    : s := 'Portrait mode (def.)';
         3    : s := 'Landscape mode';
         4    : s := 'IBM PC char set';
         5    : s := '10 CPI';
         6    : s := '12 CPI';
         7    : s := 'FormFeed';
         8    : s := 'Manual Feed';
         9    : s := 'Legal Env size';
         else   s := '';
         end;
     LJIICmdText := s;
     end;



end.
