UNIT PbFIELDS;

INTERFACE

uses CRT, PbCRT, PbMISC;

{
Description : One chunk of screen, entry of data.

Author      : Howard Richoux
Date        : 2/04/94
Last revised: 2/10/94 data space revisions - see note below
              2/18/94 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7
Status      : Placed in the Public Domain by HNR Software 1/94
Published in: none

Data space was going wild until I discovered that each field was allocating
3 255 byte strings ( working, original and prompt )  These were trimmed to
80, 80 and 24 and made global.  This means that ALL fields share the same
working space.  It would not be possible to interrupt field input to enter
another field and resume later.  This should NOT be a real limitation.

String variables are limited to 80 chars.

}
{----------------------------------------------------------------------------}
{since there is only one field being edited at any instant, these are global }

var FLD_working   : string[80];      { string being edited           }
var FLD_original  : string[80];      { copy of FLD_original string for esc }
var FLD_prompt    : string[24];      { to the left of (x,y)          }

{----------------------------------------------------------------------------}

type FIELD_object = object
              x,y,l     : byte;        { point and entry length        }
              TC        : char;        { terminating (exit) character  }
              modified  : boolean;     { set if field modified by user }
              readonly  : boolean;     { display only if true          }

              Procedure init(row,col,ll : byte; pr : string);
              Procedure done;                      { cleanup }
              Procedure display (    str : string);
              Function  input   (var str : string) : boolean;  { maj/min exit }
              Procedure dump;
              end;



type STRING_FIELD_object = object(FIELD_object)
              st        : string[80];
              Upshift   : boolean;
              Procedure init    (row,col,ll : byte; pr : string);
              Procedure SetUpShift;
              Procedure display (str : string);
              Function  input   (var str : string) : boolean;
              Procedure dump;
              end;


type DBDATE_FIELD_object = object(FIELD_object)
              dt         : string[8];
              Procedure init    (row,col,ll : byte; pr : string);
              Procedure display (str : string);
              Function  input   (var str : string) : boolean;
              Procedure dump;
              end;


type REAL_FIELD_object = object(FIELD_object)
              rr        : real;
              decp      : byte;
              Procedure init    (row,col,ll,dcp : byte; pr : string);
              Procedure display ( r : real);
              Function  input   (var r : real) : boolean;
              Procedure dump;
              end;



type INTEGER_FIELD_object = object(FIELD_object)
              ii         : integer;
              Procedure init    (row,col,ll : byte; pr : string);
              Procedure display (i : integer);
              Function  input   (var i : integer) : boolean;
              Procedure dump;
              end;



type LONGINT_FIELD_object = object(FIELD_object)
              ll         : longint;
              Procedure init    (row,col,llx : byte; pr : string);
              Procedure display (lng : longint);
              Function  input   (var lng : longint) : boolean;
              Procedure dump;
              end;



{SECTION .ZIMPLEMENTATION }
IMPLEMENTATION

Function  MaxFieldLen(col,ln : integer) : integer;
var l : integer;
     begin
     l := (80 - col);
     if l > ln then l := ln;
     MaxFieldLen := l;
     end;


{SECTION  FIELD_object }
Procedure FIELD_object.init(row,col,ll : byte; pr : string);
     begin
     modified := false;
     readonly := false;
     FLD_prompt   := pr;
     FLD_working := '';
     FLD_original := '';
     l := ll;     y := row;     x := col;
     TC := ' ';
     end;


Procedure FIELD_object.done;          { cleanup }
     begin
     end;


Procedure FIELD_object.dump;
     begin
     gotoxy(1,4);write('dump (',x,',',y,') [',FLD_prompt,'] [',FLD_working,']');
     end;


Procedure FIELD_object.display( str : string);
var ok : boolean;
     begin
     FLD_working  := str;
     ok := InputStr(y,x,FLD_prompt,FLD_working,l,'O',TC);  { for now }
     end;


Function  FIELD_object.input(var str : string) : boolean;
var ok : boolean;
     begin
     TC := ' ';
     FLD_working  := str;
     FLD_original := str;
     if readonly then begin input := false; exit; end;
     ok := InputStr(y,x,FLD_prompt,FLD_working,l,'U',TC);  { for now }
     if TC = #27 then FLD_working := FLD_original;
     str := FLD_working;
     input := ok;
     end;


{ ----------------------------------------------------------------------- }

{SECTION  STRING_FIELD_object }
Procedure STRING_FIELD_object.init(row,col,ll : byte; pr : string);
var lx : integer;
     begin
     st := '';
     lx := MaxFieldLen(col,ll);
     FIELD_object.init(row,col,lx,pr);
     Upshift  := false;
     if Upshift then FLD_working := UpCaseStr(FLD_working);
     end;


Procedure STRING_FIELD_object.SetUpShift;
var s : string;
     begin
     Upshift := true;
     end;


Procedure STRING_FIELD_object.display( str : string);
var s : string;
     begin
     st := str;
     FLD_working := st;
     if Upshift then FLD_working := UpCaseStr(FLD_working);
     FIELD_object.display(FLD_working);
     end;


Procedure STRING_FIELD_object.dump;
     begin
     FIELD_object.dump;
     write('  st=[',st,']');
     end;


Function  STRING_FIELD_object.input(var str : string) : boolean;
var ok : boolean;
     begin
     FLD_working := str;
     if Upshift then FLD_working := UpCaseStr(FLD_working);
     ok := FIELD_object.input(FLD_working);
     st := FLD_working;
     str := st;
     display(str);
     input := ok;
     end;


{ ----------------------------------------------------------------------- }


{SECTION  DBDATE_FIELD_object }
Procedure DBDATE_FIELD_object.init(row,col,ll : byte; pr : string);
var s  : string;
    lx : integer;
     begin
     if ll > 8 then lx := 8
     else lx := ll;
     lx := MaxFieldLen(col,lx);
     FIELD_object.init(row,col,ll,pr);
     end;


Procedure DBDATE_FIELD_object.dump;
     begin
     FIELD_object.dump;
     write('  dt=[',dt,']    formatted [',FmtPDateStr(DBaseToPTime(dt)),']');
     end;


Procedure DBDATE_FIELD_object.display(str : string);
var s : string;
     begin
     dt := str;
     FLD_working := FmtPDateStr(DBaseToPTime(dt));
     FIELD_object.display(FLD_working);
     end;


Function  DBDATE_FIELD_object.input(var str : string) : boolean;
var ok : boolean;
var s  : string;
    yy,mm,dd : integer;
     begin
     FLD_working := FmtPDateStr(DBaseToPTime(dt));
     ok := FIELD_object.input(FLD_working);
     StrCal(FLD_working,dd,mm,yy);
     dt := integerstr(1900+yy,4) + integerstr(mm,2)+integerstr(dd,2);
     patchstr(dt,' ','0');
     display(dt);
     str := dt;
     input := ok;
     end;



{ ----------------------------------------------------------------------- }


{SECTION  REAL_FIELD_object }
Procedure REAL_FIELD_object.init(row,col,ll,dcp : byte; pr : string);
var s  : string;
    lx : integer;
     begin
     rr := 0;
     decp := dcp;
     if ll > 14 then lx := 14
     else lx := ll;
     lx := MaxFieldLen(col,lx);
     FIELD_object.init(row,col,ll,pr);
     end;


Procedure REAL_FIELD_object.dump;
     begin
     FIELD_object.dump;
     write('  rr=[',rr:10:3,']    formatted [',RealStr(rr,10,3),']');
     end;


Procedure REAL_FIELD_object.display( r : real);
var s : string;
     begin
     rr := r;
     FLD_working := RealStr(rr,l,decp);
     FIELD_object.display(FLD_working);
     end;


Function  REAL_FIELD_object.input(var r : real) : boolean;
var ok : boolean;
var s  : string;
    yy,mm,dd : integer;
     begin
     FLD_working := trimstr(RealStr(rr,l,decp));
     ok := FIELD_object.input(FLD_working);
     rr := StrReal(FLD_working);
     r := rr;
     display(r);
     input := ok;
     end;



{SECTION  INTEGER_FIELD_object }
Procedure INTEGER_FIELD_object.init(row,col,ll : byte; pr : string);
var s : string;
    lx : integer;
     begin
     ii := 0;
     if ll > 6 then lx := 6
     else lx := ll;
     lx := MaxFieldLen(col,lx);
     FIELD_object.init(row,col,lx,pr);
     end;


Procedure INTEGER_FIELD_object.dump;
     begin
     FIELD_object.dump;
     write('  [',ii,'] ');
     end;


Procedure INTEGER_FIELD_object.display( i : integer );
var s : string;
     begin
     ii := i;
     FLD_working := integerstr(ii,l);
     FIELD_object.display(FLD_working);
     end;


Function INTEGER_FIELD_object.input(var i : integer) : boolean;
var ok : boolean;
var s  : string;
    yy,mm,dd : integer;
     begin
     FLD_working := trimstr(integerstr(ii,l));
     ok := FIELD_object.input(FLD_working);
     ii := StrInt(FLD_working);
     display(ii);
     i := ii;
     input := ok;
     end;




{SECTION  LONGINT_FIELD_object }
Procedure LONGINT_FIELD_object.init(row,col,llx : byte; pr : string);
var s : string;
    lx : integer;
     begin
     ll := 0;
     if llx > 9 then lx := 9
     else lx := llx;
     lx := MaxFieldLen(col,lx);
     FIELD_object.init(row,col,lx,pr);
     end;


Procedure LONGINT_FIELD_object.dump;
     begin
     FIELD_object.dump;
     write('  [',ll,'] ');
     end;


Procedure LONGINT_FIELD_object.display( lng : longint );
var s : string;
     begin
     ll := lng;
     FLD_working := longintstr(ll,l);
     FIELD_object.display(FLD_working);
     end;


Function LONGINT_FIELD_object.input(var lng : longint) : boolean;
var ok : boolean;
var s  : string;
    yy,mm,dd : integer;
     begin
     FLD_working := trimstr(longintstr(ll,l));
     ok := FIELD_object.input(FLD_working);
     ll := StrLong(FLD_working);
     display(ll);
     lng := ll;
     input := ok;
     end;





{SECTION  ZInitialization }
     begin {Initialization}
     end.
