
Unit PbDDL;

INTERFACE

uses PbMISC;

{
Description:  Sort of a mini-Data Dictionary - for SCRNGEN

Author      : Howard Richoux
Date        : 2/1/94  still fluid
Last revised: 2/18/94 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}



type DDLRec = record
     nam    : string[24];     { field name }
     typ    : char;           { field type }
     len    : byte;           { data length }
     decp   : byte;           { decimals }
     r,c,l  : byte;           { row, col, display len }
     prompt : string[20];     { display prompt }
     options: string[40];     { picture/readonly/... }
     end;


{SECTION .DDL_object }

const fldsmax = 100;

type DDL_object = object
        ddl   : array[1..fldsmax] of DDLRec;
        count : integer;

        Procedure init;
        Procedure append(nam : string; typ : char; len,decp : integer);
        Function  find  (nam : string) : integer;
        Procedure dump;
        Procedure done;
        end;

{SECTION .Procs }

Function  DDLRecSize(var flds : DDL_object) : integer;

Procedure FieldSpecToPbDDL(FieldSpec : string; var flds : DDL_object);


{SECTION  .zImplementation }
IMPLEMENTATION


Function  DDLRecSize(var flds : DDL_object) : integer;
var i,j : integer;
     begin
     j := 0;
     if flds.count > 0 then
          begin
          for i := 1 to flds.count do j := j + flds.ddl[i].len;
          end;
     DDLRecSize := j;
     end;



{SECTION  FieldSpecToPbDDL }
Procedure FieldSpecToPbDDL(FieldSpec : string; var flds : DDL_object);
var i        : integer;
    s, s1,s2,s3 : string;
var x        : DDLRec;
     begin
     writeln('-------');
     s := RemoveBrackets(FieldSpec);
     writeln('{FIELDS='+s+'}');
     while length(s) > 0 do
          begin
          fillchar(x,sizeof(x),0);
          s1 := GetLeftStr(s,',');
         { writeln('[',s1,']'); pause; }
          s2 := UpCaseStr(GetDelimitedStr(s1,'(',')'));
          x.nam := s1;
          x.typ := s2[1];
          case s2[1] of
             'C' : begin    {char array}
                   i  := GetInteger(s2);
                   if i = 0 then i := 1;
                   end;
             'D' : i := 8;  {DBase Date field}
             'I' : i := 2;  {integer}
             'L' : i := 4;  {longint}
             'N' : begin    {DBase Number field}
                   delete(s2,1,1);  {N}
                   s1 := GetLeftStr(s2,'.');
                   i := Strint(s1);
                   x.decp := strint(s2);
                   end;
             'R' : i := 4;  {real}
             'S' : begin    {string}
                   i  := GetInteger(s2);
                   if i = 0 then i := 1;
                   end;
              else begin
                   writeln('Unknown field type [',s2[1],']');
                   i := 0;
                   end;
              end;
          x.len := i;
          flds.append(x.nam,x.typ,x.len,x.decp);
          end;
     writeln('-------');
     writeln('  Total length ',DDLRecSize(flds));
     writeln('-------');
     end;


{SECTION  DDL_object }
Procedure DDL_object.init;
     begin
     fillchar(ddl,sizeof(ddl),0);
     count := 0;
     end;


Procedure DDL_object.append(nam : string; typ : char; len,decp : integer);
var s : string;
     begin
     if count < fldsmax then
          begin
          inc(count);
          s := nam;
          trim(s);
          s := UpCaseStr(s);
          ddl[count].nam  := s;
          ddl[count].typ  := UpCase(typ);
          ddl[count].len  := len;
          ddl[count].decp := decp;
          end;
     end;


Function  DDL_object.find  (nam : string) : integer;
var i,j : integer;
     begin
     j := 0;
     if count > 0 then
          begin
          for i := 1 to count do
               begin
               if nam = ddl[i].nam then j := i;
               end;
          end;
     find := j;
     end;


Procedure DDL_object.dump;
var i : integer;
     begin
     writeln('dumping DDL   fields = ',count);
     if count > 0 then
          begin
          for i := 1 to count do
               begin
               writeln('[',ddl[i].nam,']  ',ddl[i].typ,'  ',
                           ddl[i].len, '  ',ddl[i].decp,'  (',
                           ddl[i].r,',',ddl[i].c,')  ',ddl[i].l);
               end;
          end;
     end;


Procedure DDL_object.done;
     begin
     count := 0;
     end;




     begin {initialization}
     end.


