

{SECTION  OUT_object_0 }
Procedure OUT_object_0.HandleFName(fn: string; append : byte);
    begin
    fname      := UpCaseStr(fn);
    if      (fname = '') then fname := 'CON';
    RemoveTrailing(fname,':');

    if      (fname = 'LPT1') then devtyp := OUT_typPRT
    else if (fname = 'LPT2') then devtyp := OUT_typPRT
    else if (fname = 'CON')  then devtyp := OUT_typCRT
    else if (fname = 'NUL')  then devtyp := OUT_typNUL
    else devtyp := OUT_typFIL;
    if FileExt(fname) = 'LST' then devtyp := OUT_typPRT;

    if      DevTyp = OUT_typPRT then
         begin plen := 59; llen := 90; loff := 5; end
    else if DevTyp = OUT_typFIL then
         begin plen := 32700; llen := 131; loff := 0; end
    else if DevTyp = OUT_typNUL then
         begin plen := 32700; llen := 80; loff := 0; end
    else begin plen := 24; llen := 79; loff := 0; end;
    end;


Procedure OUT_object_0.LISTInit(fn: string; append : byte);
    begin
    HandleFName(fn,append);
    Init(fname,devtyp,append,plen,llen,loff);
    end;


Procedure OUT_object_0.Init(fn: string; dtyp, append : byte;
                                  pl, lw : integer; off : byte);
    begin
    noprint    := false;
    opened     := false;
    err        := 0;
    indent     := 0;
    compressed := false;
    landscape  := false;
    PrinterInitted := false;

    fname      := fn;
    devtyp     := dtyp;
    app        := append;
    llen       := lw;
    plen       := pl;
    SetOffset(off);
    SetINdent(indent);
    ResetCounts;
    end;


Procedure OUT_object_0.LISTOpen;
    begin
    {$I-} close(f); {$I+}   {just make sure}
    err    := IOResult;
    opened := false;
    err    := 0;

    case DevTyp of
         OUT_typCRT  : begin
                  {$I-} assign(f,''); {$I+}
                   err := IOResult;
                   if err = 0 then
                        begin
                        {$I-} rewrite(f); {$I+}
                        err := IOResult;
                        end;
                   if err <> 0 then
                        writeln('Unable to open CRT  err=',err);
                   end;

         OUT_typPRT  : begin
                  {$I-} assign(lst,fname); {$I+}
                   err := IOResult;
                   if err = 0 then
                        begin
                        {$I-} rewrite(lst); {$I+}
                        err := IOResult;
                        end;
                   if err <> 0 then
                        writeln('Unable to open PRINTER  err=',err);
                   end;

         OUT_typFIL  : begin
                  {$I-} assign(f,fname); {$I+}
                   err := IOResult;
                   if err = 0 then
                        begin
                        if app = OUT_typREWRITE then
                             begin
                             {$I-} rewrite(f); {$I+}
                             err := IOResult;
                             end
                        else if app = OUT_typAPPEND then
                             begin
                             {$I-} append(f); {$I+}
                             err := IOResult;
                             if err = 2 then
                                  begin
                                 {$I-} rewrite(f); {$I+}
                                  err := IOResult;
                                  app := OUT_typREWRITE;
                                  end;
                             end;
                        end;
                   if err <> 0 then
                        writeln('Unable to open FILE  err=',err);
                   end;
         end;
    if err = 0 then opened := true;
    end;


Procedure OUT_object_0.SetOffset( i : byte);  {all lines on page}
    begin
    loff := i;
    loffstr := conststr(' ',loff);
    currllen := llen - (loff + indent);
    end;


Procedure OUT_object_0.SetIndent( i : byte);  {all lines on page}
    begin
    indentstr := '';
    indent := i;
    indentstr := {'<'+integerstr(i,2)+'>'}+conststr(' ',indent);
    currllen := llen - (loff + indent);
    end;


Procedure OUT_object_0.ResetCounts;
    begin
    currline   := 1;
    currpage   := 1;
    linesprinted := 0;
    linesmax     := 999999;
    end;



Procedure OUT_object_0.SetCompressed;
     begin
     if devtyp <> OUT_typPRT then exit;
     compressed := true;
     printerinitted := false;
     if landscape then
          begin llen := 172; plen := 58; loff := 6; end
     else begin llen := 130; plen := 78; loff := 12; end;
     loffstr := conststr(' ',loff);
     currllen := llen - (loff + indent);
     end;


Procedure OUT_object_0.SetLandscape;
     begin
     if devtyp <> OUT_typPRT then exit;
     landscape := true;
     printerinitted := false;
     if compressed then
          begin llen := 172; plen := 58; loff := 6; end
     else begin llen := 120; plen := 43; loff := 5; end;
     loffstr := conststr(' ',loff);
     currllen := llen - (loff + indent);
     end;


Procedure OUT_object_0.pause;
var s : string;
    begin
    if nopause then exit;
    if DevTyp = OUT_typCRT then
         begin
         if linesprinted > linesmax then exit;
         write('pause'); readln(s);
         if ord(s[1]) = 27 then linesprinted := linesmax + 1;
         end;
    end;


Procedure OUT_object_0.SetNoPause;
    begin
    nopause := true;
    end;


Procedure OUT_object_0.formfeed;
    begin
    currline := 1;
    if not opened then exit;
    if noprint then exit;
    case DevTyp of
         OUT_typCRT  : begin
                   pause;
                   end;

         OUT_typPRT  : begin
                  {$I-} write(lst,^L); {$I+}
                   err := IOResult;
                   end;
         end;
    end;


Procedure OUT_object_0.InitPrinter;
var s : string;
     begin
     PrinterInitted := true;
     if devtyp = OUT_typPRT then
          begin
          s := chr(27) + 'E';        { RESET }
          write(lst,s);
          if landscape then
               begin
               s := chr(27) + '&l1O';        { Landscape }
               write(lst,s);
               end;
          if compressed then
               begin
               s := chr(27) + '(s16.66h(s2B'+
                    chr(27)+'&l8D'; { 132 col,demibold,8lpi }
               write(lst,s);
               end;
          end;
      end;


Procedure OUT_object_0.OutERRNoCR(s : string);  { Physical I/O level }
    begin
    err := 0;
    if not opened then exit;
    if not printerinitted then InitPrinter;
    case DevTyp of
           OUT_typCRT  : begin
                    {$I-} write(s); {$I+}
                     err := IOResult;
                     end;

           OUT_typPRT  : begin
                    {$I-} write(lst,s); {$I+}
                     err := IOResult;
                     end;

           OUT_typFIL  : begin
                    {$I-} write(f,s); {$I+}
                     err := IOResult;
                     end;
           end;
{    if err <> 0 then writeln('OutERRNoCR ',err);}
    end;


Procedure OUT_object_0.OutERR(s : string);  { Physical I/O level }
var line : string;
    i    : integer;
    begin
    err := 0;
    if not opened then exit;
    if linesprinted > linesmax then exit;
    if noprint then exit;
    line := leftstr(loffstr+indentstr+s,llen-1);
    RemoveTrailing(line,' ');
    case DevTyp of
           OUT_typCRT  : begin
                    {$I-} writeln(line); {$I+}
                     err := IOResult;
                     end;

           OUT_typPRT  : begin
                    {$I-} writeln(lst,line); {$I+}
                     err := IOResult;
                     if err <> 0 then
                         begin
                         while err = 152 do   { LJ memory full? }
                             begin
                             writeln('Error 152 printing (',currpage,',',
                                      currline,') [',s,']');
                       {$I-} writeln(lst,line); {$I+}
                             err := IOResult;
                             end;
                        end;
                     end;

           OUT_typFIL  : begin
                    {$I-} writeln(f,line); {$I+}
                     err := IOResult;
                     end;
           end;
{    if err <> 0 then writeln('OutERR ',err);}
    end;


Procedure OUT_object_0.OutHeader;
     begin
     if (devtyp = OUT_typPRT) and landscape then OutErr(' ');
     currline := 1;
     end;


Procedure OUT_object_0.OutFooter;
     begin
     if currline > 1 then formfeed;
     inc(currpage);
     end;


Procedure OUT_object_0.Out(s : string);   { Logical I/O level }
     begin
     if linesprinted > linesmax then exit;
     if (devtyp = OUT_typPRT) and (not printerinitted) then InitPrinter;
     if currline <= 1 then OutHeader;
     OutERR(s);
     inc(currline);
     if currline > plen then OutFooter;
     end;



Procedure OUT_object_0.DoneWithPage;
var i,j : integer;
     begin
     if currline = 1 then exit;
     if devtyp = OUT_typPRT then
          begin
          j := currline;
          for i := j to plen do
               begin
               OutErr(' ');
               inc(currline);
               end;
          end;
     OutFooter;
     end;


Procedure OUT_object_0.done;
var s : string;
     begin
     nopause := true;
     if currline > 1 then DoneWithPage;
     if devtyp = OUT_typPRT then
          begin
          s := chr(27) + 'E';        { RESET }
          write(lst,s);
          end;
     if devtyp = OUT_typPRT then
          begin
          {$I-} close(lst); {$I+}
          end
     else if devtyp <> OUT_typCRT then
          begin
          {$I-} close(f); {$I+}
          end;
     err := IOResult;
     opened := false;
     end;



{SECTION  OUT_object_1 }
{All the fancy stuff}
Procedure OUT_object_1.LISTInit(fn: string; append : byte);
    begin
    HandleFName(fn,devtyp);
    Init(fname,devtyp,append,plen,llen,loff);
    end;


Procedure OUT_object_1.Init(fn: string; dtyp, append : byte;
                                  pl, lw : integer; off : byte);
    begin
    OUT_object_0.init(fn,dtyp,append,pl,lw,off);
    alldone    := false;
    header1spec  := '@DATE||Page @PAGE'; header2spec := ''; header3spec := '';
    footer1spec  := ''; footer2spec := '';
    pagelabel1   := ''; pagelabel2  := ''; pagelabel3 := '';
    joinflag     := false;
    joinwidth    := currllen;
    joinlinehold := '';
    end;


Procedure OUT_object_1.SetHeaders(h1spec,h2spec,h3spec,f1spec,f2spec : string);
    begin
    header1spec := h1spec;
    header2spec := h2spec;
    header3spec := h3spec;
    footer1spec := f1spec;
    footer2spec := f2spec;
    if footer1spec <> '' then dec(plen);
    if footer2spec <> '' then dec(plen);
    end;



Function OUT_object_1.SpecialStr(str : string) : string; {header/Footer}
var s : string;
     begin
     s := UpCaseStr(str);
     if      s = '@DATE'     then s := leftstr(FormatDTime,8)
     else if s = '@DTIME'    then s := leftstr(FormatDTime,14)
     else if s = '@TIME'     then s := copy(FormatDTime,10,5)
     else if s = '@PAGE'     then s := trimstr(integerstr(currpage,3))
     else if s = '@LABEL1'   then s := pagelabel1
     else if s = '@LABEL2'   then s := pagelabel2
     else if s = '@LABEL3'   then s := pagelabel3
     else if s = '@PROGID'   then s := pProgID
     else if s = '@FILE'     then s := pCurrFName
     else begin s := str; end;
     {writeln('SpecialStr in= [',str,']   out= [',s,']');}
     SpecialStr := s;
     end;


Function OUT_object_1.FmtHeaderPiece(spec : string) : string;
var s,s1,s2, result,r1 : string;
    i       : integer;
    ch      : char;
     begin
     result := '';
     s := spec;
     PatchStr(s,' ','~');
    { writeln('FmtHeaderPiece [',s,']');}
     while length(s) > 0 do
          begin
          r1 := '';
          s1 := GetLeftStr(s,'@');
          if s <> '' then
               begin
              { writeln('Found @  s1 [',s1,']  s [',s,']');}
               result := result + s1;                  { up to @ }
               s1 := GetLeftStr(s,'~');          { get the @v }
               result := result + SpecialStr('@'+s1);  { processed @v }
               s := '~' + s;                           { '@v ' }
               end
          else result := result + s1;
          end;
     PatchStr(result,'~',' ');
     FmtHeaderPiece := result;
     end;


Function OUT_object_1.pFmtHeader(spec : string; width : integer) : string;
{  Header/Footer specification --> '<2>|<1>|<3>' where
     <n>   = text (delimited by the | or end of string    and/or
           = @keyword         such as @today or @page     and/or
           = @variable        set by \set @variable = '...' <- not ready
}
var s,result : string;
    s1,s2,s3 : string[60];
    i        : integer;
    ch       : char;
     begin
     result := '';
     s := spec;
     if (s[1] = '''') or (s[1]='"')  then
         begin
         delete(s,1,1);
         delete(s,length(s),1);
         end;
     s2 := GetLeftStr(s,'|');
     s1 := GetLeftStr(s,'|');
     s3 := GetLeftStr(s,'|');
     s := ' ';

     if length(s1) > 0 then        { center }
          begin
          s1 := FmtHeaderPiece(s1);
          result := CenterStr(s1,width);
          end
     else result := ' ';
     if length(s2) > 0 then        { left }
          begin
          s2 := FmtHeaderPiece(s2);
          result := MergeStr(result,1,s2);
          end;
     if length(s3) > 0 then        { left }
          begin
          s3 := FmtHeaderPiece(s3);
          result := MergeStr(result,(width-length(s3)),s3);
          end;
     pFmtHeader := result;
     end;

{PAGE}



Procedure OUT_object_1.OutHeader;
     begin
     currline := 1;
     if (devtyp = OUT_typPRT) and landscape then OutErr(' ');
     if header1spec <> '' then
         begin
         OutERR(pFmtHeader(header1spec,currllen));
         inc(currline);
         end;
     if header2spec <> '' then
         begin
         OutERR(pFmtHeader(header2spec,currllen));
         inc(currline);
         end;
     if header3spec <> '' then
         begin
         OutERR(pFmtHeader(header3spec,currllen));
         inc(currline);
         end;
     end;


Procedure OUT_object_1.OutFooter;
     begin
     if footer2spec <> '' then
         begin
         OutERR(pFmtHeader(footer2spec,currllen));
         end;
     if footer1spec <> '' then
         begin
         OutERR(pFmtHeader(footer1spec,currllen));
         end;
     formfeed;
     inc(currpage);
     end;


Procedure OUT_object_1.Out(s : string);   { Logical I/O level }
     begin
     if linesprinted > linesmax then exit;
     if (devtyp = OUT_typPRT) and (not printerinitted) then InitPrinter;
     if currline <= 1 then OutHeader;
     OutERR(s);
     inc(currline);
     if currline > plen then OutFooter;
     end;



Procedure OUT_object_1.DoneWithPage;
var i,j : integer;
     begin
     if currline = 1 then exit;
     if devtyp = OUT_typPRT then
          begin
          j := currline;
          for i := j to plen do
               begin
               OutErr(' ');
               inc(currline);
               end;
          end;
     OutFooter;
     end;


Procedure OUT_object_1.done;
var s : string;
     begin
     nopause := true;
     alldone := true;
     flushjoin(true); { if needed }
     if currline > 1 then DoneWithPage;
     if devtyp = OUT_typPRT then
          begin
          s := chr(27) + 'E';        { RESET }
          write(lst,s);
          end;
     if devtyp = OUT_typPRT then
          begin
          {$I-} close(lst); {$I+}
          end
     else if devtyp <> OUT_typCRT then
          begin
          {$I-} close(f); {$I+}
          end;
     err := IOResult;
     if err <> 0 then writeln('Done - CLOSE error= ',err);
     opened := false;
     end;


{PAGE JOIN}


Procedure OUT_object_1.FlushJoin(joindone : boolean);
     begin
     if not joinflag then exit;
     if length(joinlinehold) > 0 then
          begin
          out(joinlinehold);
          joinlinehold := '';
          end;
     if joindone then joinflag := false;
     end;


Procedure OUT_object_1.OutJoin(line : string);
var i : integer;
     begin
     if joinflag then
          begin
          i := 0;
          if (length(joinlinehold) > 0) then
               joinlinehold := joinlinehold + ' ' + line
          else joinlinehold := line;
          while (length(joinlinehold) > joinwidth) do
               begin
               out(BreakLine(joinlinehold,joinwidth));
               inc(i);
               if i > 20 then
                    begin
                    writeln('*** join failure [',joinlinehold,']');
                    joinlinehold := ''; {emergency exit}
                    end;
               end;
          trim(joinlinehold);
          if line = '' then
               begin
               flushjoin(false);
               out(' ');
               end;
          end
     else out(line);
     end;


